/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.Cache;
import javax.cache.CacheStatistics;
import javax.cache.implementation.RICache;

public class RICacheStatistics
implements CacheStatistics,
Serializable {
    private static final long serialVersionUID = -5589437411679003894L;
    private static final long NANOSECONDS_IN_A_MILLISECOND = 1000000L;
    private transient Cache<?, ?> cache;
    private final AtomicLong cacheRemovals = new AtomicLong();
    private final AtomicLong cacheExpiries = new AtomicLong();
    private final AtomicLong cachePuts = new AtomicLong();
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheEvictions = new AtomicLong();
    private final AtomicLong cachePutTimeTakenNanos = new AtomicLong();
    private final AtomicLong cacheGetTimeTakenNanos = new AtomicLong();
    private final AtomicLong cacheRemoveTimeTakenNanos = new AtomicLong();
    private Date lastCollectionStartDate = new Date();

    public RICacheStatistics(Cache<?, ?> cache, String cacheManagerName) {
        this.cache = cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getStatus() {
        return this.cache.getStatus().toString();
    }

    public void clearStatistics() {
        this.cachePuts.set(0L);
        this.cacheMisses.set(0L);
        this.cacheRemovals.set(0L);
        this.cacheExpiries.set(0L);
        this.cacheHits.set(0L);
        this.cacheEvictions.set(0L);
        this.cacheGetTimeTakenNanos.set(0L);
        this.cachePutTimeTakenNanos.set(0L);
        this.cacheRemoveTimeTakenNanos.set(0L);
        this.lastCollectionStartDate = new Date();
    }

    public Date statsAccumulatingFrom() {
        return this.lastCollectionStartDate;
    }

    public long getEntryCount() {
        return ((RICache)this.cache).getSize();
    }

    public long getCacheHits() {
        return this.cacheHits.longValue();
    }

    public float getCacheHitPercentage() {
        return this.getCacheHits() / this.getCacheGets();
    }

    public long getCacheMisses() {
        return this.cacheMisses.longValue();
    }

    public float getCacheMissPercentage() {
        return this.getCacheMisses() / this.getCacheGets();
    }

    public long getCacheGets() {
        return this.getCacheHits() + this.getCacheMisses();
    }

    public long getCachePuts() {
        return this.cachePuts.longValue();
    }

    public long getCacheRemovals() {
        return this.cacheRemovals.longValue();
    }

    public long getCacheEvictions() {
        return this.cacheEvictions.longValue();
    }

    public long getAverageGetMillis() {
        return this.cacheGetTimeTakenNanos.longValue() / this.getCacheGets() / 1000000L;
    }

    public long getAveragePutMillis() {
        return this.cachePutTimeTakenNanos.longValue() / this.getCacheGets() / 1000000L;
    }

    public long getAverageRemoveMillis() {
        return this.cacheRemoveTimeTakenNanos.longValue() / this.getCacheGets() / 1000000L;
    }

    void increaseCacheRemovals(long number) {
        this.cacheRemovals.getAndAdd(number);
    }

    void increaseCacheExpiries(long number) {
        this.cacheExpiries.getAndAdd(number);
    }

    void increaseCachePuts(long number) {
        this.cachePuts.getAndAdd(number);
    }

    void increaseCacheHits(long number) {
        this.cacheHits.getAndAdd(number);
    }

    void increaseCacheMisses(long number) {
        this.cacheMisses.getAndAdd(number);
    }

    void increaseCacheEvictions(long number) {
        this.cacheEvictions.getAndAdd(number);
    }

    public void addGetTimeNano(long duration) {
        if (this.cacheGetTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.cacheGetTimeTakenNanos.addAndGet(duration);
        } else {
            this.clearStatistics();
            this.cacheGetTimeTakenNanos.set(duration);
        }
    }

    public void addPutTimeNano(long duration) {
        if (this.cachePutTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.cachePutTimeTakenNanos.addAndGet(duration);
        } else {
            this.clearStatistics();
            this.cachePutTimeTakenNanos.set(duration);
        }
    }

    public void addRemoveTimeNano(long duration) {
        if (this.cacheRemoveTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.cacheRemoveTimeTakenNanos.addAndGet(duration);
        } else {
            this.clearStatistics();
            this.cacheRemoveTimeTakenNanos.set(duration);
        }
    }
}

