/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheException;
import javax.cache.CacheLoader;
import javax.cache.CacheManager;
import javax.cache.CacheStatistics;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.Status;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.NotificationScope;
import javax.cache.implementation.RIByReferenceSimpleCache;
import javax.cache.implementation.RIByValueSimpleCache;
import javax.cache.implementation.RICacheConfiguration;
import javax.cache.implementation.RICacheStatistics;
import javax.cache.implementation.RISerializer;
import javax.cache.implementation.RISimpleCache;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public final class RICache<K, V>
implements Cache<K, V> {
    private static final int CACHE_LOADER_THREADS = 2;
    private final RISimpleCache<K, V> store;
    private final String cacheName;
    private final String cacheManagerName;
    private final ClassLoader classLoader;
    private final CacheConfiguration configuration;
    private final CacheLoader<K, V> cacheLoader;
    private final CacheWriter<K, V> cacheWriter;
    private final Set<ScopedListener<K, V>> cacheEntryListeners = new CopyOnWriteArraySet<ScopedListener<K, V>>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private volatile Status status = Status.UNINITIALISED;
    private volatile RICacheStatistics statistics;

    private RICache(String cacheName, String cacheManagerName, Set<Class<?>> immutableClasses, ClassLoader classLoader, CacheConfiguration configuration, CacheLoader<K, V> cacheLoader, CacheWriter<K, V> cacheWriter, CopyOnWriteArraySet<ListenerRegistration<K, V>> listeners) {
        assert (configuration != null);
        assert (cacheName != null);
        assert (cacheManagerName != null);
        assert (immutableClasses != null);
        assert (classLoader != null);
        this.cacheName = cacheName;
        this.cacheManagerName = cacheManagerName;
        this.configuration = configuration;
        this.cacheLoader = cacheLoader;
        this.cacheWriter = cacheWriter;
        this.classLoader = classLoader;
        this.store = configuration.isStoreByValue() ? new RIByValueSimpleCache(new RISerializer(classLoader, immutableClasses), new RISerializer(classLoader, immutableClasses)) : new RIByReferenceSimpleCache();
        this.statistics = new RICacheStatistics(this, cacheManagerName);
        for (ListenerRegistration<K, V> listener : listeners) {
            this.registerCacheEntryListener(((ListenerRegistration)listener).cacheEntryListener, ((ListenerRegistration)listener).scope, ((ListenerRegistration)listener).synchronous);
        }
    }

    public String getName() {
        return this.cacheName;
    }

    public CacheManager getCacheManager() {
        return Caching.getCacheManager((ClassLoader)this.classLoader, (String)this.cacheManagerName);
    }

    public V get(K key) {
        this.checkStatusStarted();
        return this.getInternal(key);
    }

    public Map<K, V> getAll(Collection<? extends K> keys) {
        this.checkStatusStarted();
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.getInternal(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public boolean containsKey(K key) {
        this.checkStatusStarted();
        return this.store.containsKey(key);
    }

    public Future<V> load(K key) {
        this.checkStatusStarted();
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.cacheLoader == null) {
            return null;
        }
        if (this.containsKey(key)) {
            return null;
        }
        FutureTask task = new FutureTask(new RICacheLoaderLoadCallable<K, V>(this, this.cacheLoader, key));
        this.executorService.submit(task);
        return task;
    }

    public Future<Map<K, V>> loadAll(Collection<? extends K> keys) {
        this.checkStatusStarted();
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (this.cacheLoader == null) {
            return null;
        }
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        FutureTask<Map<K, V>> task = new FutureTask<Map<K, V>>(new RICacheLoaderLoadAllCallable<K, V>(this, this.cacheLoader, keys));
        this.executorService.submit(task);
        return task;
    }

    public CacheStatistics getStatistics() {
        this.checkStatusStarted();
        if (this.statisticsEnabled()) {
            return this.statistics;
        }
        return null;
    }

    public void put(K key, V value) {
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        this.store.put(key, value);
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
    }

    public V getAndPut(K key, V value) {
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        V result = this.store.getAndPut(key, value);
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        long start;
        this.checkStatusStarted();
        long l = start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        if (map.containsKey(null)) {
            throw new NullPointerException("key");
        }
        this.store.putAll(map);
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(map.size());
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
    }

    public boolean putIfAbsent(K key, V value) {
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        boolean result = this.store.putIfAbsent(key, value);
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    public boolean remove(K key) {
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        boolean result = this.store.remove(key);
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    public boolean remove(K key, V oldValue) {
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        boolean result = this.store.remove(key, oldValue);
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    public V getAndRemove(K key) {
        this.checkStatusStarted();
        V result = this.store.getAndRemove(key);
        if (this.statisticsEnabled()) {
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCacheRemovals(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.checkStatusStarted();
        if (this.store.replace(key, oldValue, newValue)) {
            if (this.statisticsEnabled()) {
                this.statistics.increaseCachePuts(1L);
            }
            return true;
        }
        return false;
    }

    public boolean replace(K key, V value) {
        this.checkStatusStarted();
        boolean result = this.store.replace(key, value);
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
        }
        return result;
    }

    public V getAndReplace(K key, V value) {
        this.checkStatusStarted();
        V result = this.store.getAndReplace(key, value);
        if (this.statisticsEnabled()) {
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCachePuts(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    public void removeAll(Collection<? extends K> keys) {
        this.checkStatusStarted();
        for (K key : keys) {
            this.store.remove(key);
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(keys.size());
        }
    }

    public void removeAll() {
        this.checkStatusStarted();
        int size = this.statisticsEnabled() ? this.store.size() : 0;
        this.store.removeAll();
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(size);
        }
    }

    public CacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> cacheEntryListener, NotificationScope scope, boolean synchronous) {
        ScopedListener scopedListener = new ScopedListener(cacheEntryListener, scope, synchronous);
        return this.cacheEntryListeners.add(scopedListener);
    }

    public boolean unregisterCacheEntryListener(CacheEntryListener<?, ?> cacheEntryListener) {
        CacheEntryListener<?, ?> castCacheEntryListener = cacheEntryListener;
        ScopedListener scopedListener = new ScopedListener(castCacheEntryListener, null, true);
        return this.cacheEntryListeners.remove(scopedListener);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkStatusStarted();
        return new RIEntryIterator(this.store.iterator());
    }

    public void start() {
        this.status = Status.STARTED;
    }

    public void stop() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
        this.store.removeAll();
        this.status = Status.STOPPED;
    }

    private void checkStatusStarted() {
        if (!this.status.equals((Object)Status.STARTED)) {
            throw new IllegalStateException("The cache status is not STARTED");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    CacheWriter<K, V> getCacheWriter() {
        return this.cacheWriter;
    }

    CacheLoader<K, V> getCacheLoader() {
        return this.cacheLoader;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + cls + " is not a supported by this implementation");
    }

    private boolean statisticsEnabled() {
        return this.configuration.isStatisticsEnabled();
    }

    private V getInternal(K key) {
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        V value = this.store.get(key);
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
        }
        if (value == null) {
            if (this.statisticsEnabled()) {
                this.statistics.increaseCacheMisses(1L);
            }
            if (this.cacheLoader != null) {
                return this.getFromLoader(key);
            }
            return null;
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheHits(1L);
        }
        return value;
    }

    private V getFromLoader(K key) {
        Cache.Entry entry = this.cacheLoader.load(key);
        if (entry != null) {
            this.store.put(entry.getKey(), entry.getValue());
            return (V)entry.getValue();
        }
        return null;
    }

    long getSize() {
        return this.store.size();
    }

    private static final class ListenerRegistration<K, V> {
        private final CacheEntryListener<K, V> cacheEntryListener;
        private final NotificationScope scope;
        private final boolean synchronous;

        private ListenerRegistration(CacheEntryListener<K, V> cacheEntryListener, NotificationScope scope, boolean synchronous) {
            this.cacheEntryListener = cacheEntryListener;
            this.scope = scope;
            this.synchronous = synchronous;
        }
    }

    public static class Builder<K, V>
    implements CacheBuilder<K, V> {
        private final String cacheName;
        private final ClassLoader classLoader;
        private final String cacheManagerName;
        private final Set<Class<?>> immutableClasses;
        private final RICacheConfiguration.Builder configurationBuilder = new RICacheConfiguration.Builder();
        private CacheLoader<K, V> cacheLoader;
        private CacheWriter<K, V> cacheWriter;
        private final CopyOnWriteArraySet<ListenerRegistration<K, V>> listeners = new CopyOnWriteArraySet();

        public Builder(String cacheName, String cacheManagerName, Set<Class<?>> immutableClasses, ClassLoader classLoader) {
            if (cacheName == null) {
                throw new NullPointerException("cacheName");
            }
            this.cacheName = cacheName;
            if (classLoader == null) {
                throw new NullPointerException("cacheLoader");
            }
            this.classLoader = classLoader;
            if (cacheManagerName == null) {
                throw new NullPointerException("cacheManagerName");
            }
            this.cacheManagerName = cacheManagerName;
            if (immutableClasses == null) {
                throw new NullPointerException("immutableClasses");
            }
            this.immutableClasses = immutableClasses;
        }

        public RICache<K, V> build() {
            RICacheConfiguration configuration = this.configurationBuilder.build();
            if (configuration.isReadThrough() && this.cacheLoader == null) {
                throw new InvalidConfigurationException("cacheLoader");
            }
            if (configuration.isWriteThrough() && this.cacheWriter == null) {
                throw new InvalidConfigurationException("cacheWriter");
            }
            RICache riCache = new RICache(this.cacheName, this.cacheManagerName, this.immutableClasses, this.classLoader, configuration, this.cacheLoader, this.cacheWriter, this.listeners);
            configuration.setRiCache(riCache);
            return riCache;
        }

        public Builder<K, V> setCacheLoader(CacheLoader<K, V> cacheLoader) {
            if (cacheLoader == null) {
                throw new NullPointerException("cacheLoader");
            }
            this.cacheLoader = cacheLoader;
            return this;
        }

        public CacheBuilder<K, V> setCacheWriter(CacheWriter<K, V> cacheWriter) {
            if (cacheWriter == null) {
                throw new NullPointerException("cacheWriter");
            }
            this.cacheWriter = cacheWriter;
            return this;
        }

        public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener, NotificationScope scope, boolean synchronous) {
            this.listeners.add(new ListenerRegistration(listener, scope, synchronous));
            return this;
        }

        public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
            this.configurationBuilder.setStoreByValue(storeByValue);
            return this;
        }

        public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            this.configurationBuilder.setTransactionEnabled(isolationLevel, mode);
            return this;
        }

        public CacheBuilder<K, V> setStatisticsEnabled(boolean enableStatistics) {
            this.configurationBuilder.setStatisticsEnabled(enableStatistics);
            return this;
        }

        public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
            this.configurationBuilder.setReadThrough(readThrough);
            return this;
        }

        public CacheBuilder<K, V> setWriteThrough(boolean writeThrough) {
            this.configurationBuilder.setWriteThrough(writeThrough);
            return this;
        }

        public CacheBuilder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (duration == null) {
                throw new NullPointerException();
            }
            this.configurationBuilder.setExpiry(type, duration);
            return this;
        }
    }

    private static class RICacheLoaderLoadAllCallable<K, V>
    implements Callable<Map<K, V>> {
        private final RICache<K, V> cache;
        private final CacheLoader<K, V> cacheLoader;
        private final Collection<? extends K> keys;

        RICacheLoaderLoadAllCallable(RICache<K, V> cache, CacheLoader<K, V> cacheLoader, Collection<? extends K> keys) {
            this.cache = cache;
            this.cacheLoader = cacheLoader;
            this.keys = keys;
        }

        @Override
        public Map<K, V> call() throws Exception {
            ArrayList<K> keysNotInStore = new ArrayList<K>();
            for (K key : this.keys) {
                if (this.cache.containsKey(key)) continue;
                keysNotInStore.add(key);
            }
            Map value = this.cacheLoader.loadAll(keysNotInStore);
            this.cache.putAll(value);
            return value;
        }
    }

    private static class RICacheLoaderLoadCallable<K, V>
    implements Callable<V> {
        private final RICache<K, V> cache;
        private final CacheLoader<K, V> cacheLoader;
        private final K key;

        RICacheLoaderLoadCallable(RICache<K, V> cache, CacheLoader<K, V> cacheLoader, K key) {
            this.cache = cache;
            this.cacheLoader = cacheLoader;
            this.key = key;
        }

        @Override
        public V call() throws Exception {
            Cache.Entry entry = this.cacheLoader.load(this.key);
            this.cache.put(entry.getKey(), entry.getValue());
            return (V)entry.getValue();
        }
    }

    private static final class RIEntryIterator<K, V>
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> mapIterator;

        private RIEntryIterator(Iterator<Map.Entry<K, V>> mapIterator) {
            this.mapIterator = mapIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        @Override
        public Cache.Entry<K, V> next() {
            Map.Entry<K, V> mapEntry = this.mapIterator.next();
            return new RIEntry<K, V>(mapEntry.getKey(), mapEntry.getValue());
        }

        @Override
        public void remove() {
            this.mapIterator.remove();
        }
    }

    private static class RIEntry<K, V>
    implements Cache.Entry<K, V> {
        private final K key;
        private final V value;

        public RIEntry(K key, V value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RIEntry e2 = (RIEntry)o;
            return this.getKey().equals(e2.getKey()) && this.getValue().equals(e2.getValue());
        }

        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }
    }

    private static final class ScopedListener<K, V> {
        private final CacheEntryListener<? super K, ? super V> listener;
        private final NotificationScope scope;
        private final boolean synchronous;

        private ScopedListener(CacheEntryListener<? super K, ? super V> listener, NotificationScope scope, boolean synchronous) {
            this.listener = listener;
            this.scope = scope;
            this.synchronous = synchronous;
        }

        private CacheEntryListener<? super K, ? super V> getListener() {
            return this.listener;
        }

        private NotificationScope getScope() {
            return this.scope;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScopedListener other = (ScopedListener)obj;
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        public String toString() {
            return this.listener.toString();
        }
    }
}

