/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Set;
import javax.cache.CacheException;
import javax.cache.implementation.Binary;
import javax.cache.implementation.Serializer;

public class RISerializer<T>
implements Serializer<T> {
    private final SerializationHelper serializationHelper;
    private final Set<Class<?>> immutableClasses;

    public RISerializer(ClassLoader classLoader, Set<Class<?>> immutableClasses) {
        assert (classLoader != null);
        assert (immutableClasses != null);
        this.serializationHelper = new SerializationHelper(classLoader);
        this.immutableClasses = immutableClasses;
    }

    @Override
    public Binary<T> createBinary(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.immutableClasses.contains(value.getClass()) ? new RIByReferenceBinary<T>(value) : new RIBinary(value, this.serializationHelper);
    }

    private static final class SerializationHelper {
        private final ClassLoader classLoader;

        private SerializationHelper(ClassLoader classLoader) {
            if (classLoader == null) {
                throw new NullPointerException("classLoader");
            }
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] toBytes(Object value) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                bos.flush();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bos = new ByteArrayInputStream(bytes);
            try {
                MyObjectInputStream ois = new MyObjectInputStream(bos, this.classLoader);
                Object object = ois.readObject();
                return object;
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }

        public void validate(Object toStore) {
            Class<?> class1 = toStore.getClass();
            try {
                Class<?> class2 = this.classLoader.loadClass(class1.getName());
                if (class1 != class2) {
                    throw new IllegalArgumentException("from different class loader: " + toStore);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("not in class loader: " + toStore);
            }
        }

        private static final class MyObjectInputStream
        extends ObjectInputStream {
            private final ClassLoader classloader;

            private MyObjectInputStream(InputStream in, ClassLoader classloader) throws IOException {
                super(in);
                this.classloader = classloader;
            }

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String name = desc.getName();
                try {
                    return Class.forName(name, false, this.classloader);
                }
                catch (ClassNotFoundException ex) {
                    return super.resolveClass(desc);
                }
            }
        }
    }

    private static final class RIBinary<V>
    implements Binary<V> {
        private final byte[] bytes;
        private final int hashCode;
        private final SerializationHelper serializationHelper;

        private RIBinary(V value, SerializationHelper serializationHelper) {
            this.serializationHelper = serializationHelper;
            this.hashCode = value.hashCode();
            try {
                this.bytes = serializationHelper.toBytes(value);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Serializer: " + e.getMessage(), e);
            }
        }

        @Override
        public V get() {
            try {
                Object value = this.serializationHelper.fromBytes(this.bytes);
                return (V)value;
            }
            catch (IOException e) {
                throw new CacheException("Serializer: " + e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException("Serializer: " + e.getMessage(), (Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (o instanceof RIBinary) {
                RIBinary riBinary = (RIBinary)o;
                return this.hashCode == riBinary.hashCode && Arrays.equals(this.bytes, riBinary.bytes);
            }
            Binary binary = (Binary)o;
            return this.hashCode == binary.hashCode() && this.get().equals(binary.get());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class RIByReferenceBinary<V>
    implements Binary<V> {
        private final V value;

        public RIByReferenceBinary(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Binary binary = (Binary)o;
            return this.hashCode() == binary.hashCode() && this.get().equals(binary.get());
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

