/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheStatistics;
import javax.cache.CacheWriter;
import javax.cache.Status;
import javax.cache.event.CacheEntryListener;
import javax.cache.implementation.AbstractCache;
import javax.cache.implementation.AbstractCacheConfiguration;
import javax.cache.implementation.DelegatingCacheMXBean;
import javax.cache.implementation.RIByReferenceSimpleCache;
import javax.cache.implementation.RIByValueSimpleCache;
import javax.cache.implementation.RICacheConfiguration;
import javax.cache.implementation.RICacheStatistics;
import javax.cache.implementation.RISerializer;
import javax.cache.implementation.RISimpleCache;
import javax.cache.mbeans.CacheMXBean;

public final class RICache<K, V>
extends AbstractCache<K, V> {
    private final RISimpleCache<K, V> store;
    private final Set<CacheEntryListener<? super K, ? super V>> cacheEntryListeners = new CopyOnWriteArraySet<CacheEntryListener<? super K, ? super V>>();
    private volatile Status status;
    private final RICacheStatistics statistics;
    private final CacheMXBean mBean;
    private final LockManager<K> lockManager = new LockManager();

    private RICache(String cacheName, String cacheManagerName, ClassLoader classLoader, CacheConfiguration<K, V> configuration, CacheLoader<K, ? extends V> cacheLoader, CacheWriter<? super K, ? super V> cacheWriter, Set<CacheEntryListener<K, V>> listeners) {
        super(cacheName, cacheManagerName, classLoader, configuration, cacheLoader, cacheWriter);
        this.status = Status.UNINITIALISED;
        this.store = configuration.isStoreByValue() ? new RIByValueSimpleCache(new RISerializer(classLoader), new RISerializer(classLoader)) : new RIByReferenceSimpleCache();
        this.statistics = new RICacheStatistics((Cache<?, ?>)this);
        this.mBean = new DelegatingCacheMXBean((Cache)this);
        for (CacheEntryListener<K, V> listener : listeners) {
            this.registerCacheEntryListener(listener);
        }
    }

    public V get(K key) {
        this.checkStatusStarted();
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getInternal(key);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkStatusStarted();
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.getInternal(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        this.checkStatusStarted();
        if (key == null) {
            throw new NullPointerException();
        }
        ((LockManager)this.lockManager).lock(key);
        try {
            boolean bl = this.store.containsKey(key);
            return bl;
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
    }

    public Future<V> load(K key) {
        this.checkStatusStarted();
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getCacheLoader() == null) {
            return null;
        }
        if (this.containsKey(key)) {
            return null;
        }
        FutureTask task = new FutureTask(new RICacheLoaderLoadCallable(this, this.getCacheLoader(), key));
        this.submit(task);
        return task;
    }

    public Future<Map<K, ? extends V>> loadAll(Set<? extends K> keys) {
        this.checkStatusStarted();
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (this.getCacheLoader() == null) {
            return null;
        }
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        RICacheLoaderLoadAllCallable callable = new RICacheLoaderLoadAllCallable(this, this.getCacheLoader(), keys);
        FutureTask<Map<K, ? extends V>> task = new FutureTask<Map<K, ? extends V>>(callable);
        this.submit(task);
        return task;
    }

    public CacheStatistics getStatistics() {
        this.checkStatusStarted();
        if (this.statisticsEnabled()) {
            return this.statistics;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        ((LockManager)this.lockManager).lock(key);
        try {
            this.store.put(key, value);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, V value) {
        V result;
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.getAndPut(key, value);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        long start;
        this.checkStatusStarted();
        long l = start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        if (map.containsKey(null)) {
            throw new NullPointerException("key");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            ((LockManager)this.lockManager).lock(key);
            try {
                this.store.put(key, entry.getValue());
            }
            finally {
                ((LockManager)this.lockManager).unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(map.size());
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(K key, V value) {
        boolean result;
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.putIfAbsent(key, value);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        boolean result;
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.remove(key);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V oldValue) {
        boolean result;
        this.checkStatusStarted();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.remove(key, oldValue);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndRemove(K key) {
        V result;
        this.checkStatusStarted();
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.getAndRemove(key);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (this.statisticsEnabled()) {
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCacheRemovals(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result;
        this.checkStatusStarted();
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.replace(key, oldValue, newValue);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V value) {
        boolean result;
        this.checkStatusStarted();
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.replace(key, value);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndReplace(K key, V value) {
        V result;
        this.checkStatusStarted();
        ((LockManager)this.lockManager).lock(key);
        try {
            result = this.store.getAndReplace(key, value);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (this.statisticsEnabled()) {
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCachePuts(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<? extends K> keys) {
        this.checkStatusStarted();
        for (K key : keys) {
            ((LockManager)this.lockManager).lock(key);
            try {
                this.store.remove(key);
            }
            finally {
                ((LockManager)this.lockManager).unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(keys.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.checkStatusStarted();
        int size = this.statisticsEnabled() ? this.store.size() : 0;
        Iterator iterator = this.store.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = entry.getKey();
            ((LockManager)this.lockManager).lock(key);
            try {
                iterator.remove();
            }
            finally {
                ((LockManager)this.lockManager).unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(size);
        }
    }

    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> cacheEntryListener) {
        return this.cacheEntryListeners.add(cacheEntryListener);
    }

    public boolean unregisterCacheEntryListener(CacheEntryListener<?, ?> cacheEntryListener) {
        return this.cacheEntryListeners.remove(cacheEntryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeEntryProcessor(K key, Cache.EntryProcessor<K, V> entryProcessor) {
        this.checkStatusStarted();
        if (key == null) {
            throw new NullPointerException();
        }
        if (key == entryProcessor) {
            throw new NullPointerException();
        }
        Object result = null;
        ((LockManager)this.lockManager).lock(key);
        try {
            RIMutableEntry<K, V> entry = new RIMutableEntry<K, V>(key, this.store);
            result = entryProcessor.process(entry);
            ((RIMutableEntry)entry).commit();
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        return result;
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkStatusStarted();
        return new RIEntryIterator(this.store.iterator(), this.lockManager);
    }

    public CacheMXBean getMBean() {
        return this.mBean;
    }

    public void start() {
        this.status = Status.STARTED;
    }

    public void stop() {
        super.stop();
        this.store.removeAll();
        this.status = Status.STOPPED;
    }

    private void checkStatusStarted() {
        if (!this.status.equals((Object)Status.STARTED)) {
            throw new IllegalStateException("The cache status is not STARTED");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return cls.cast((Object)this);
        }
        throw new IllegalArgumentException("Unwrapping to " + cls + " is not a supported by this implementation");
    }

    private boolean statisticsEnabled() {
        return this.getConfiguration().isStatisticsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getInternal(K key) {
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        V value = null;
        ((LockManager)this.lockManager).lock(key);
        try {
            value = this.store.get(key);
        }
        finally {
            ((LockManager)this.lockManager).unLock(key);
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
        }
        if (value == null) {
            if (this.statisticsEnabled()) {
                this.statistics.increaseCacheMisses(1L);
            }
            if (this.getCacheLoader() != null) {
                return this.getFromLoader(key);
            }
            return null;
        }
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheHits(1L);
        }
        return value;
    }

    private V getFromLoader(K key) {
        Cache.Entry entry = this.getCacheLoader().load(key);
        if (entry != null) {
            this.store.put(entry.getKey(), entry.getValue());
            return (V)entry.getValue();
        }
        return null;
    }

    long getSize() {
        return this.store.size();
    }

    private static class RIMutableEntry<K, V>
    implements Cache.MutableEntry<K, V> {
        private final K key;
        private V value;
        private final RISimpleCache<K, V> store;
        private boolean exists;
        private boolean remove;

        RIMutableEntry(K key, RISimpleCache<K, V> store) {
            this.key = key;
            this.store = store;
            this.exists = store.containsKey(key);
        }

        private void commit() {
            if (this.remove) {
                this.store.remove(this.key);
            } else if (this.value != null) {
                this.store.put(this.key, this.value);
            }
        }

        public boolean exists() {
            return this.exists;
        }

        public void remove() {
            this.remove = true;
            this.exists = false;
            this.value = null;
        }

        public void setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.exists = true;
            this.remove = false;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value != null ? this.value : this.store.get(this.key);
        }
    }

    private static final class LockManager<K> {
        private final ConcurrentHashMap<K, ReentrantLock> locks = new ConcurrentHashMap();
        private final LockFactory lockFactory = new LockFactory();

        private LockManager() {
        }

        private void lock(K key) {
            ReentrantLock lock = this.lockFactory.getLock();
            ReentrantLock oldLock;
            while ((oldLock = this.locks.putIfAbsent(key, lock)) != null) {
                oldLock.lock();
                this.lockFactory.release(oldLock);
            }
            return;
        }

        private void unLock(K key) {
            ReentrantLock lock = this.locks.remove(key);
            this.lockFactory.release(lock);
        }

        private static final class LockFactory {
            private static final int CAPACITY = 100;
            private static final ArrayList<ReentrantLock> LOCKS = new ArrayList(100);

            private LockFactory() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ReentrantLock getLock() {
                ReentrantLock qLock = null;
                ArrayList<ReentrantLock> arrayList = LOCKS;
                synchronized (arrayList) {
                    if (!LOCKS.isEmpty()) {
                        qLock = LOCKS.remove(0);
                    }
                }
                ReentrantLock lock = qLock != null ? qLock : new ReentrantLock();
                lock.lock();
                return lock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release(ReentrantLock lock) {
                lock.unlock();
                ArrayList<ReentrantLock> arrayList = LOCKS;
                synchronized (arrayList) {
                    if (LOCKS.size() <= 100) {
                        LOCKS.add(lock);
                    }
                }
            }
        }
    }

    public static class Builder<K, V>
    extends AbstractCache.Builder<K, V> {
        private final Set<CacheEntryListener<K, V>> listeners = new CopyOnWriteArraySet<CacheEntryListener<K, V>>();

        public Builder(String cacheName, String cacheManagerName, ClassLoader classLoader) {
            this(cacheName, cacheManagerName, classLoader, new RICacheConfiguration.Builder());
        }

        private Builder(String cacheName, String cacheManagerName, ClassLoader classLoader, RICacheConfiguration.Builder configurationBuilder) {
            super(cacheName, cacheManagerName, classLoader, (AbstractCacheConfiguration.Builder)configurationBuilder);
        }

        public RICache<K, V> build() {
            CacheConfiguration configuration = this.createCacheConfiguration();
            RICache riCache = new RICache(this.cacheName, this.cacheManagerName, this.classLoader, configuration, this.cacheLoader, this.cacheWriter, this.listeners);
            ((RICacheConfiguration)configuration).setRiCache(riCache);
            return riCache;
        }

        public Builder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener) {
            this.listeners.add(listener);
            return this;
        }
    }

    private static class RICacheLoaderLoadAllCallable<K, V>
    implements Callable<Map<K, ? extends V>> {
        private final RICache<K, V> cache;
        private final CacheLoader<K, ? extends V> cacheLoader;
        private final Collection<? extends K> keys;

        RICacheLoaderLoadAllCallable(RICache<K, V> cache, CacheLoader<K, ? extends V> cacheLoader, Collection<? extends K> keys) {
            this.cache = cache;
            this.cacheLoader = cacheLoader;
            this.keys = keys;
        }

        @Override
        public Map<K, ? extends V> call() throws Exception {
            ArrayList<K> keysNotInStore = new ArrayList<K>();
            for (K key : this.keys) {
                if (this.cache.containsKey(key)) continue;
                keysNotInStore.add(key);
            }
            Map value = this.cacheLoader.loadAll(keysNotInStore);
            this.cache.putAll(value);
            return value;
        }
    }

    private static class RICacheLoaderLoadCallable<K, V>
    implements Callable<V> {
        private final RICache<K, V> cache;
        private final CacheLoader<K, ? extends V> cacheLoader;
        private final K key;

        RICacheLoaderLoadCallable(RICache<K, V> cache, CacheLoader<K, ? extends V> cacheLoader, K key) {
            this.cache = cache;
            this.cacheLoader = cacheLoader;
            this.key = key;
        }

        @Override
        public V call() throws Exception {
            Cache.Entry entry = this.cacheLoader.load(this.key);
            this.cache.put(entry.getKey(), entry.getValue());
            return (V)entry.getValue();
        }
    }

    private static final class RIEntryIterator<K, V>
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> mapIterator;
        private final LockManager<K> lockManager;

        private RIEntryIterator(Iterator<Map.Entry<K, V>> mapIterator, LockManager<K> lockManager) {
            this.mapIterator = mapIterator;
            this.lockManager = lockManager;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cache.Entry<K, V> next() {
            Map.Entry<K, V> mapEntry = this.mapIterator.next();
            K key = mapEntry.getKey();
            ((LockManager)this.lockManager).lock(key);
            try {
                RIEntry<K, V> rIEntry = new RIEntry<K, V>(key, mapEntry.getValue());
                return rIEntry;
            }
            finally {
                ((LockManager)this.lockManager).unLock(key);
            }
        }

        @Override
        public void remove() {
            this.mapIterator.remove();
        }
    }

    private static class RIEntry<K, V>
    implements Cache.Entry<K, V> {
        private final K key;
        private final V value;

        public RIEntry(K key, V value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RIEntry e2 = (RIEntry)o;
            return this.getKey().equals(e2.getKey()) && this.getValue().equals(e2.getValue());
        }

        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }
    }
}

