/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.cache.implementation.AbstractCacheManager;
import javax.cache.implementation.DelegatingCacheBuilder;
import javax.cache.implementation.RICache;
import javax.transaction.UserTransaction;

public class RICacheManager
extends AbstractCacheManager
implements CacheManager {
    private static final Logger LOGGER = Logger.getLogger("javax.cache");
    private final HashMap<String, Cache<?, ?>> caches = new HashMap();
    private volatile Status status = Status.UNINITIALISED;

    public RICacheManager(String name, ClassLoader classLoader) {
        super(name, classLoader);
        if (classLoader == null) {
            throw new NullPointerException("No classLoader specified");
        }
        if (name == null) {
            throw new NullPointerException("No name specified");
        }
        this.status = Status.STARTED;
    }

    public Status getStatus() {
        return this.status;
    }

    public <K, V> CacheBuilder<K, V> createCacheBuilder(String cacheName) {
        if (this.caches.get(cacheName) != null) {
            throw new CacheException("Cache " + cacheName + " already exists");
        }
        if (cacheName == null) {
            throw new NullPointerException("A cache name must must not be null.");
        }
        Pattern searchPattern = Pattern.compile("\\S+");
        Matcher matcher = searchPattern.matcher(cacheName);
        if (!matcher.find()) {
            throw new IllegalArgumentException("A cache name must contain one or more non-whitespace characters");
        }
        return new RICacheBuilder(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            Cache<?, ?> cache = this.caches.get(cacheName);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Cache<?, ?>> getCaches() {
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            HashSet set = new HashSet();
            for (Cache<?, ?> cache : this.caches.values()) {
                set.add(cache);
            }
            return Collections.unmodifiableSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCacheInternal(Cache<?, ?> cache) {
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            if (this.caches.get(cache.getName()) != null) {
                throw new CacheException("Cache " + cache.getName() + " already exists");
            }
            this.caches.put(cache.getName(), cache);
        }
        cache.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCache(String cacheName) {
        Cache<?, ?> oldCache;
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            oldCache = this.caches.remove(cacheName);
        }
        if (oldCache != null) {
            oldCache.stop();
        }
        return oldCache != null;
    }

    public UserTransaction getUserTransaction() {
        throw new UnsupportedOperationException("Transactions are not supported.");
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return Caching.isSupported((OptionalFeature)optionalFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList cacheList;
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        super.shutdown();
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            cacheList = new ArrayList(this.caches.values());
            this.caches.clear();
        }
        for (Cache<?, ?> cache : cacheList) {
            try {
                cache.stop();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error stopping cache: " + cache);
            }
        }
        this.status = Status.STOPPED;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return cls.cast((Object)this);
        }
        throw new IllegalArgumentException("Unwapping to " + cls + " is not a supported by this implementation");
    }

    Logger getLogger() {
        return LOGGER;
    }

    private class RICacheBuilder<K, V>
    extends DelegatingCacheBuilder<K, V> {
        public RICacheBuilder(String cacheName) {
            super(new RICache.Builder(cacheName, RICacheManager.this.getName(), RICacheManager.this.getClassLoader()));
        }

        public Cache<K, V> build() {
            Cache cache = super.build();
            RICacheManager.this.addCacheInternal(cache);
            return cache;
        }
    }
}

