/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.implementation.RIByReferenceSimpleCache;
import javax.cache.implementation.RISimpleCache;

public class RIExpiringByReferenceSimpleCache<K, V>
implements RISimpleCache<K, V> {
    private final RIByReferenceSimpleCache<K, ExpiryWrapper<V>> store = new RIByReferenceSimpleCache();

    @Override
    public V get(Object key) {
        ExpiryWrapper<V> value = this.store.get(key);
        if (value == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        return value.getValue(now);
    }

    @Override
    public boolean containsKey(Object key) {
        ExpiryWrapper<V> value = this.store.get(key);
        return value != null;
    }

    @Override
    public void put(K key, V value) {
        long now = System.currentTimeMillis();
        this.store.put(key, new ExpiryWrapper<V>(value, now));
    }

    @Override
    public V getAndPut(K key, V value) {
        long now = System.currentTimeMillis();
        ExpiryWrapper<V> oldValue = this.store.getAndPut(key, new ExpiryWrapper<V>(value, now));
        if (oldValue == null) {
            return null;
        }
        return oldValue.getValue(now);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        long now = System.currentTimeMillis();
        HashMap<K, ExpiryWrapper<V>> toStore = new HashMap<K, ExpiryWrapper<V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            toStore.put(entry.getKey(), new ExpiryWrapper<V>(entry.getValue(), now));
        }
        this.store.putAll(toStore);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        ExpiryWrapper<V> oldValue = this.store.get(key);
        long now = System.currentTimeMillis();
        if (oldValue == null) {
            this.store.put(key, new ExpiryWrapper<V>(value, now));
            return false;
        }
        return this.store.putIfAbsent(key, new ExpiryWrapper<V>(value, now));
    }

    @Override
    public boolean remove(Object key) {
        return this.getAndRemove(key) != null;
    }

    @Override
    public boolean remove(Object key, V oldValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getAndRemove(Object key) {
        ExpiryWrapper<V> oldValue = this.store.getAndRemove(key);
        if (oldValue == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        return oldValue.getValue(now);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getAndReplace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        this.store.removeAll();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        throw new UnsupportedOperationException();
    }

    private static class ExpiryWrapper<V> {
        private V value;
        private long modificationTime;
        private long accessTime;

        ExpiryWrapper(V value, long creationTime) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value = value;
            this.modificationTime = creationTime;
            this.accessTime = creationTime;
        }

        public V getValue(long accessTime) {
            this.accessTime = accessTime;
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ExpiryWrapper) {
                ExpiryWrapper that = (ExpiryWrapper)o;
                return this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

