/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.embeddable;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContainer
implements AutoCloseable {
    public static final String PROVIDER = "javax.ejb.embeddable.provider";
    public static final String MODULES = "javax.ejb.embeddable.modules";
    public static final String APP_NAME = "javax.ejb.embeddable.appName";
    private static final String newLine = "\r\n";
    private static final ServiceLoader<EJBContainerProvider> providers = ServiceLoader.load(EJBContainerProvider.class);

    public static EJBContainer createEJBContainer() {
        return EJBContainer.createEJBContainer(null);
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties) {
        EJBContainer container = null;
        HashMap<String, String> errors = new HashMap<String, String>();
        HashSet<String> returnedNull = new HashSet<String>();
        providers.reload();
        for (EJBContainerProvider provider : providers) {
            try {
                container = provider.createEJBContainer(properties);
                if (container != null) break;
                returnedNull.add(provider.getClass().getName());
            }
            catch (EJBException e) {
                throw e;
            }
            catch (Throwable t) {
                errors.put(provider.getClass().getName(), EJBContainer.createErrorMessage(t));
            }
        }
        if (container == null) {
            EJBContainer.reportError(properties, errors, returnedNull);
        }
        return container;
    }

    public abstract Context getContext();

    @Override
    public abstract void close();

    private static void reportError(Map<?, ?> properties, Map<String, String> errors, Set<String> returnedNull) throws EJBException {
        Object specifiedProvider;
        StringBuffer message = new StringBuffer("No EJBContainer provider available");
        if (properties != null && (specifiedProvider = properties.get(PROVIDER)) != null) {
            message.append(" for requested provider: " + specifiedProvider);
        }
        if (errors.isEmpty() && returnedNull.isEmpty()) {
            message.append(": no provider names had been found.");
        } else {
            message.append("\n");
        }
        for (Map.Entry<String, String> me : errors.entrySet()) {
            message.append("Provider named ");
            message.append((Object)me.getKey());
            message.append(" threw unexpected exception at create EJBContainer: \n");
            message.append((Object)me.getValue()).append("\n");
        }
        if (!returnedNull.isEmpty()) {
            message.append("The following providers:\n");
            for (String n : returnedNull) {
                message.append(n).append("\n");
            }
            message.append("Returned null from createEJBContainer call.\n");
        }
        throw new EJBException(message.toString());
    }

    private static String createErrorMessage(Throwable t) {
        StringWriter errorMessage = new StringWriter();
        errorMessage.append(t.getClass().getName()).append(newLine);
        t.printStackTrace(new PrintWriter(errorMessage));
        errorMessage.append(newLine);
        return errorMessage.toString();
    }
}

