/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import javax.el.ELContext;

public abstract class EvaluationListener {
    public void beforeEvaluation(ELContext context, String expression) {
    }

    public void afterEvaluation(ELContext context, String expression) {
    }

    public void propertyResolved(ELContext context, Object base, Object property) {
    }

    public static void notifyBeforeEvaluation(ELContext context, String expr) {
        if (context.getEvaluationListeners() == null) {
            return;
        }
        for (EvaluationListener listener : context.getEvaluationListeners()) {
            listener.beforeEvaluation(context, expr);
        }
    }

    public static void notifyAfterEvaluation(ELContext context, String expr) {
        if (context.getEvaluationListeners() == null) {
            return;
        }
        for (EvaluationListener listener : context.getEvaluationListeners()) {
            listener.afterEvaluation(context, expr);
        }
    }

    public static void notifyPropertyResolved(ELContext context, Object base, Object property) {
        if (context.getEvaluationListeners() == null) {
            return;
        }
        for (EvaluationListener listener : context.getEvaluationListeners()) {
            listener.propertyResolved(context, base, property);
        }
    }
}

