/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

public class LambdaExpression {
    private List<String> formalParameters = new ArrayList<String>();
    private ValueExpression expression;

    public LambdaExpression(List<String> formalParameters, ValueExpression expression) {
        this.formalParameters = formalParameters;
        this.expression = expression;
    }

    public Object invoke(ELContext elContext, Object ... args) throws ELException {
        int i = 0;
        HashMap<String, Object> lambdaArgs = new HashMap<String, Object>();
        for (String fParam : this.formalParameters) {
            if (i >= args.length) {
                throw new ELException("Expected Argument " + fParam + " missing in Lambda Expression");
            }
            lambdaArgs.put(fParam, args[i++]);
        }
        elContext.enterLambdaScope(lambdaArgs);
        Object ret = this.expression.getValue(elContext);
        elContext.exitLambdaScope();
        return ret;
    }
}

