/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.Renderer;

public abstract class UIComponentBase
extends UIComponent {
    private static WeakHashMap descriptors = new WeakHashMap();
    private WeakHashMap pdMap = null;
    private static Object[] empty = new Object[0];
    private Map attributes = null;
    private Map bindings = null;
    private String clientId = null;
    private String id = null;
    private UIComponent parent = null;
    private boolean rendered = true;
    private boolean renderedSet = false;
    private String rendererType = null;
    private List children = null;
    private static String separatorString = ":";
    private Map facets = null;
    private List listeners;
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private transient FacesContext facesContext = null;
    private boolean transientFlag = false;
    static /* synthetic */ Class class$javax$faces$event$FacesListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponentBase() {
        WeakHashMap weakHashMap = descriptors;
        synchronized (weakHashMap) {
            this.pdMap = (WeakHashMap)descriptors.get(this.getClass());
            if (this.pdMap != null) {
                return;
            }
            PropertyDescriptor[] pd = this.getPropertyDescriptors();
            if (pd != null) {
                this.pdMap = new WeakHashMap(pd.length);
                for (int i = 0; i < pd.length; ++i) {
                    this.pdMap.put(pd[i].getName(), pd[i]);
                }
                descriptors.put(this.getClass(), this.pdMap);
            }
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.pdMap != null) {
            return (PropertyDescriptor)this.pdMap.get(name);
        }
        return null;
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pd = null;
        try {
            pd = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new FacesException(e);
        }
        return pd;
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap();
        }
        return this.attributes;
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.bindings == null) {
            return null;
        }
        return (ValueBinding)this.bindings.get(name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if ("id".equals(name) || "parent".equals(name)) {
            throw new IllegalArgumentException();
        }
        if (binding != null) {
            if (this.bindings == null) {
                this.bindings = new HashMap();
            }
            this.bindings.put(name, binding);
        } else if (this.bindings != null) {
            this.bindings.remove(name);
            if (this.bindings.size() == 0) {
                this.bindings = null;
            }
        }
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.clientId != null) {
            return this.clientId;
        }
        UIComponent containerComponent = this;
        Renderer renderer = null;
        String parentIds = "";
        while (null != (containerComponent = containerComponent.getParent()) && !(containerComponent instanceof NamingContainer)) {
        }
        if (null != containerComponent) {
            parentIds = containerComponent.getClientId(context) + ':';
        }
        this.clientId = null != this.id ? parentIds + this.id : parentIds + context.getViewRoot().createUniqueId();
        renderer = this.getRenderer(context);
        if (null != renderer) {
            this.clientId = renderer.convertClientId(context, this.clientId);
        }
        return this.clientId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.validateId(id);
        this.id = id;
        this.clientId = null;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    public void setParent(UIComponent parent) {
        this.parent = parent;
    }

    public boolean isRendered() {
        if (this.renderedSet) {
            return this.rendered;
        }
        ValueBinding vb = this.getValueBinding("rendered");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.rendered;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
        this.renderedSet = true;
    }

    public String getRendererType() {
        if (this.rendererType != null) {
            return this.rendererType;
        }
        ValueBinding vb = this.getValueBinding("rendererType");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setRendererType(String rendererType) {
        this.rendererType = rendererType;
    }

    public boolean getRendersChildren() {
        boolean result = false;
        Renderer renderer = null;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            result = renderer.getRendersChildren();
        }
        return result;
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList();
        }
        return this.children;
    }

    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    private void eraseParent(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        List children = parent.getChildren();
        int index = children.indexOf(component);
        if (index >= 0) {
            children.remove(index);
            return;
        }
        Map facets = parent.getFacets();
        Iterator entries = facets.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getValue() != component) continue;
            entries.remove();
            return;
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private void validateId(String id) {
        if (id == null) {
            return;
        }
        int n = id.length();
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(id);
        }
    }

    public UIComponent findComponent(String expr) {
        if (expr == null) {
            throw new NullPointerException();
        }
        UIComponent base = this;
        if (expr.startsWith(separatorString)) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            expr = expr.substring(1);
        } else {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        String id = null;
        UIComponent result = null;
        if (expr.length() > 0) {
            int separator = expr.indexOf(58);
            if (separator >= 0) {
                id = expr.substring(0, separator);
                expr = expr.substring(separator + 1);
            } else {
                id = expr;
                expr = "";
            }
            result = this.findComponent(base, id);
            if (result != null && expr.length() != 0) {
                if (result instanceof NamingContainer) {
                    result = result.findComponent(expr);
                } else {
                    throw new IllegalArgumentException(id);
                }
            }
        }
        return result;
    }

    private UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent kid = null;
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            kid = (UIComponent)kids.next();
            if (!(kid instanceof NamingContainer)) {
                result = this.findComponent(kid, id);
                if (result == null) continue;
                break;
            }
            if (!id.equals(kid.getId())) continue;
            result = kid;
            break;
        }
        return result;
    }

    public Map getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap();
        }
        return this.facets;
    }

    public UIComponent getFacet(String name) {
        if (this.facets != null) {
            return (UIComponent)this.facets.get(name);
        }
        return null;
    }

    public Iterator getFacetsAndChildren() {
        ArrayList<Object> combined = new ArrayList<Object>();
        if (this.facets != null) {
            Iterator facets = this.getFacets().values().iterator();
            while (facets.hasNext()) {
                combined.add(facets.next());
            }
        }
        if (this.children != null) {
            Iterator kids = this.getChildren().iterator();
            while (kids.hasNext()) {
                combined.add(kids.next());
            }
        }
        return new FacetsAndChildrenIterator(combined);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            FacesListener listener = (FacesListener)iter.next();
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).decode(context, this);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeChildren(context, this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, this);
        }
    }

    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!(class$javax$faces$event$FacesListener == null ? (class$javax$faces$event$FacesListener = UIComponentBase.class$("javax.faces.event.FacesListener")) : class$javax$faces$event$FacesListener).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> results = new ArrayList<FacesListener>();
        Iterator items = this.listeners.iterator();
        while (items.hasNext()) {
            FacesListener item = (FacesListener)items.next();
            if (!clazz.isAssignableFrom(item.getClass())) continue;
            results.add(item);
        }
        return (FacesListener[])results.toArray((Object[])Array.newInstance(clazz, results.size()));
    }

    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processUpdates(context);
        }
    }

    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] stateStruct = new Object[2];
        Object[] childState = null;
        stateStruct[0] = this.saveState(context);
        int i = 0;
        int len = this.getChildren().size() + this.getFacets().keySet().size();
        stateStruct[1] = childState = new Object[len];
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            Object cState = kid.processSaveState(context);
            if (cState == null) continue;
            childState[i++] = cState;
        }
        Iterator myFacets = this.getFacets().keySet().iterator();
        String facetName = null;
        UIComponent facet = null;
        Object facetState = null;
        Object[][] facetSaveState = null;
        while (myFacets.hasNext()) {
            facetName = (String)myFacets.next();
            facet = (UIComponent)this.getFacets().get(facetName);
            if (!facet.isTransient()) {
                facetState = facet.processSaveState(context);
                facetSaveState = new Object[1][2];
                facetSaveState[0][0] = facetName;
                facetSaveState[0][1] = facetState;
                childState[i] = facetSaveState;
            } else {
                childState[i] = null;
            }
            ++i;
        }
        return stateStruct;
    }

    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] stateStruct = (Object[])state;
        Object[] childState = (Object[])stateStruct[1];
        this.restoreState(context, stateStruct[0]);
        int i = 0;
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            Object currentState;
            UIComponent kid = (UIComponent)kids.next();
            if ((currentState = childState[i++]) == null) continue;
            kid.processRestoreState(context, currentState);
        }
        int facetsSize = this.getFacets().size();
        Object[][] facetSaveState = null;
        String facetName = null;
        UIComponent facet = null;
        Object facetState = null;
        for (int j = 0; j < facetsSize; ++j) {
            if (null == (facetSaveState = (Object[][])childState[i++])) continue;
            facetName = (String)facetSaveState[0][0];
            facetState = facetSaveState[0][1];
            facet = (UIComponent)this.getFacets().get(facetName);
            facet.processRestoreState(context, facetState);
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Renderer getRenderer(FacesContext context) {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            return context.getRenderKit().getRenderer(this.getFamily(), rendererType);
        }
        return null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[8];
        if (this.attributes != null) {
            HashMap attributesCopy;
            values[0] = attributesCopy = new HashMap(this.attributes);
        }
        values[1] = this.saveBindingsState(context);
        values[2] = this.clientId;
        values[3] = this.id;
        values[4] = this.rendered ? Boolean.TRUE : Boolean.FALSE;
        values[5] = this.renderedSet ? Boolean.TRUE : Boolean.FALSE;
        values[6] = this.rendererType;
        values[7] = UIComponentBase.saveAttachedState(context, this.listeners);
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.attributes = this.getAttributes();
        if (values[0] != null) {
            HashMap attributesCopy = (HashMap)values[0];
            Iterator it = attributesCopy.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = attributesCopy.get(key);
                this.attributes.put(key, value);
            }
        }
        this.bindings = this.restoreBindingsState(context, values[1]);
        this.clientId = (String)values[2];
        this.id = (String)values[3];
        this.rendered = (Boolean)values[4];
        this.renderedSet = (Boolean)values[5];
        this.rendererType = (String)values[6];
        List restoredListeners = null;
        restoredListeners = (List)UIComponentBase.restoreAttachedState(context, values[7]);
        if (null != restoredListeners) {
            if (null != this.listeners) {
                this.listeners.addAll(restoredListeners);
            } else {
                this.listeners = restoredListeners;
            }
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == attachedObject) {
            return null;
        }
        Serializable result = null;
        List attachedList = null;
        ArrayList<StateHolderSaver> resultList = null;
        Iterator listIter = null;
        if (attachedObject instanceof List) {
            attachedList = (List)attachedObject;
            resultList = new ArrayList<StateHolderSaver>(attachedList.size());
            listIter = attachedList.iterator();
            Object cur = null;
            while (listIter.hasNext()) {
                Object e = listIter.next();
                cur = e;
                if (null == e) continue;
                resultList.add(new StateHolderSaver(context, cur));
            }
            result = resultList;
        } else {
            result = new StateHolderSaver(context, attachedObject);
        }
        return result;
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == stateObj) {
            return null;
        }
        ArrayList<Object> result = null;
        List stateList = null;
        ArrayList<Object> resultList = null;
        Iterator iter = null;
        StateHolderSaver saver = null;
        if (stateObj instanceof List) {
            stateList = (List)stateObj;
            resultList = new ArrayList<Object>(stateList.size());
            iter = stateList.iterator();
            while (iter.hasNext()) {
                try {
                    saver = (StateHolderSaver)iter.next();
                }
                catch (ClassCastException cce) {
                    throw new IllegalStateException("Unknown object type");
                }
                resultList.add(saver.restore(context));
            }
            result = resultList;
        } else if (stateObj instanceof StateHolderSaver) {
            saver = (StateHolderSaver)stateObj;
            result = saver.restore(context);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return result;
    }

    private Map restoreBindingsState(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], UIComponentBase.restoreAttachedState(context, states[i]));
        }
        return bindings;
    }

    private Object saveBindingsState(FacesContext context) {
        if (this.bindings == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> states = new ArrayList<Object>();
        Iterator keys = this.bindings.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            ValueBinding binding = (ValueBinding)this.bindings.get(key);
            names.add(key);
            states.add(UIComponentBase.saveAttachedState(context, binding));
        }
        Object[] values = new Object[]{names.toArray(new String[names.size()]), states.toArray(new Object[states.size()])};
        return values;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FacetsMapValuesIterator
    implements Iterator {
        private FacetsMap map = null;
        private Iterator iterator = null;
        private Object last = null;

        public FacetsMapValuesIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = this.iterator.next();
            return this.map.get(this.last);
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    private class FacetsMapValues
    extends AbstractCollection {
        private FacetsMap map;

        public FacetsMapValues(FacetsMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean isEmpty() {
            return this.map.size() == 0;
        }

        public Iterator iterator() {
            return new FacetsMapValuesIterator(this.map);
        }

        public int size() {
            return this.map.size();
        }
    }

    private class FacetsMapKeySetIterator
    implements Iterator {
        private FacetsMap map = null;
        private Iterator iterator = null;
        private Object last = null;

        public FacetsMapKeySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = this.iterator.next();
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    private class FacetsMapKeySet
    extends AbstractSet {
        private FacetsMap map = null;

        public FacetsMapKeySet(FacetsMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean containsAll(Collection c) {
            Iterator v = c.iterator();
            while (v.hasNext()) {
                if (this.map.containsKey(v.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.map.size() == 0;
        }

        public Iterator iterator() {
            return new FacetsMapKeySetIterator(this.map);
        }

        public boolean remove(Object o) {
            if (this.map.containsKey(o)) {
                this.map.remove(o);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator v = c.iterator();
            while (v.hasNext()) {
                Object o = v.next();
                if (!this.map.containsKey(o)) continue;
                this.map.remove(o);
                result = true;
            }
            return result;
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        public int size() {
            return this.map.size();
        }
    }

    private class FacetsMapEntrySetIterator
    implements Iterator {
        private FacetsMap map = null;
        private Iterator iterator = null;
        private Object last = null;

        public FacetsMapEntrySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = new FacetsMapEntrySetEntry(this.map, this.iterator.next());
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(((Map.Entry)this.last).getKey());
            this.last = null;
        }
    }

    private class FacetsMapEntrySetEntry
    implements Map.Entry {
        private FacetsMap map;
        private Object key;

        public FacetsMapEntrySetEntry(FacetsMap map, Object key) {
            this.map = map;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            Object v = this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.map.get(this.key);
        }

        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public Object setValue(Object value) {
            Object previous = this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    private class FacetsMapEntrySet
    extends AbstractSet {
        private FacetsMap map = null;

        public FacetsMapEntrySet(FacetsMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new FacetsMapEntrySetIterator(this.map);
        }

        public boolean remove(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            if (this.map.containsKey(k)) {
                this.map.remove(k);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator v = c.iterator();
            while (v.hasNext()) {
                if (!this.remove(v.next())) continue;
                result = true;
            }
            return result;
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        public int size() {
            return this.map.size();
        }
    }

    private class FacetsMap
    extends HashMap {
        private FacetsMap() {
        }

        public void clear() {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                keys.remove();
            }
            super.clear();
        }

        public Set entrySet() {
            return new FacetsMapEntrySet(this);
        }

        public Set keySet() {
            return new FacetsMapKeySet(this);
        }

        public Object put(Object key, Object value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (!(key instanceof String) || !(value instanceof UIComponent)) {
                throw new ClassCastException();
            }
            UIComponent previous = (UIComponent)super.get(key);
            if (previous != null) {
                previous.setParent(null);
            }
            UIComponent current = (UIComponent)value;
            UIComponentBase.this.eraseParent(current);
            current.setParent(UIComponentBase.this);
            return super.put(key, value);
        }

        public void putAll(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                this.put(key, map.get(key));
            }
        }

        public Object remove(Object key) {
            UIComponent previous = (UIComponent)this.get(key);
            if (previous != null) {
                previous.setParent(null);
            }
            super.remove(key);
            return previous;
        }

        public Collection values() {
            return new FacetsMapValues(this);
        }

        Iterator keySetIterator() {
            return new ArrayList(super.keySet()).iterator();
        }
    }

    private class FacetsAndChildrenIterator
    implements Iterator {
        private Iterator iterator;

        public FacetsAndChildrenIterator(List list) {
            this.iterator = list.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChildrenListIterator
    implements ListIterator {
        private ChildrenList list;
        private int index;
        private int last = -1;

        public ChildrenListIterator(ChildrenList list) {
            this.list = list;
            this.index = 0;
        }

        public ChildrenListIterator(ChildrenList list, int index) {
            this.list = list;
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException("" + index);
            }
            this.index = index;
        }

        public boolean hasNext() {
            return this.index < this.list.size();
        }

        public Object next() {
            try {
                Object o = this.list.get(this.index);
                this.last = this.index++;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("" + this.index);
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }

        public void add(Object o) {
            this.last = -1;
            this.list.add(this.index++, o);
        }

        public boolean hasPrevious() {
            return this.index > 1;
        }

        public int nextIndex() {
            return this.index;
        }

        public Object previous() {
            try {
                int current = this.index - 1;
                Object o = this.list.get(current);
                this.last = current;
                this.index = current;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object o) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.last, o);
        }
    }

    private class ChildrenList
    extends ArrayList {
        private ChildrenList() {
        }

        public void add(int index, Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (!(element instanceof UIComponent)) {
                throw new ClassCastException();
            }
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponent child = (UIComponent)element;
            UIComponentBase.this.eraseParent(child);
            child.setParent(UIComponentBase.this);
            super.add(index, child);
        }

        public boolean add(Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (!(element instanceof UIComponent)) {
                throw new ClassCastException();
            }
            UIComponent child = (UIComponent)element;
            UIComponentBase.this.eraseParent(child);
            child.setParent(UIComponentBase.this);
            return super.add(element);
        }

        public boolean addAll(Collection collection) {
            Iterator elements = collection.iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UIComponent element = (UIComponent)elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(element);
                changed = true;
            }
            return changed;
        }

        public boolean addAll(int index, Collection collection) {
            Iterator elements = collection.iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UIComponent element = (UIComponent)elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(index++, element);
                changed = true;
            }
            return changed;
        }

        public void clear() {
            int n = this.size();
            if (n < 1) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                UIComponent child = (UIComponent)this.get(i);
                child.setParent(null);
            }
            super.clear();
        }

        public Iterator iterator() {
            return new ChildrenListIterator(this);
        }

        public ListIterator listIterator() {
            return new ChildrenListIterator(this);
        }

        public ListIterator listIterator(int index) {
            return new ChildrenListIterator(this, index);
        }

        public Object remove(int index) {
            UIComponent child = (UIComponent)this.get(index);
            super.remove(index);
            child.setParent(null);
            return child;
        }

        public boolean remove(Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (!(element instanceof UIComponent)) {
                return false;
            }
            if (super.remove(element)) {
                UIComponent child = (UIComponent)element;
                child.setParent(null);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean result = false;
            Iterator elements = collection.iterator();
            while (elements.hasNext()) {
                if (!this.remove(elements.next())) continue;
                result = true;
            }
            return result;
        }

        public boolean retainAll(Collection collection) {
            boolean modified = false;
            Iterator items = this.iterator();
            while (items.hasNext()) {
                if (collection.contains(items.next())) continue;
                items.remove();
                modified = true;
            }
            return modified;
        }

        public Object set(int index, Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (!(element instanceof UIComponent)) {
                throw new ClassCastException();
            }
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponent child = (UIComponent)element;
            UIComponentBase.this.eraseParent(child);
            UIComponent previous = (UIComponent)this.get(index);
            previous.setParent(null);
            child.setParent(UIComponentBase.this);
            super.set(index, element);
            return previous;
        }
    }

    private class AttributesMap
    extends HashMap {
        private AttributesMap() {
        }

        public boolean containsKey(Object key) {
            PropertyDescriptor pd = UIComponentBase.this.getPropertyDescriptor((String)key);
            if (pd == null) {
                return super.containsKey(key);
            }
            return false;
        }

        public Object get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            String name = (String)key;
            PropertyDescriptor pd = UIComponentBase.this.getPropertyDescriptor(name);
            if (pd != null) {
                try {
                    Method readMethod = pd.getReadMethod();
                    if (readMethod != null) {
                        return readMethod.invoke((Object)UIComponentBase.this, empty);
                    }
                    throw new IllegalArgumentException(name);
                }
                catch (IllegalAccessException e) {
                    throw new FacesException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FacesException(e.getTargetException());
                }
            }
            if (super.containsKey(name)) {
                return super.get(key);
            }
            ValueBinding vb = UIComponentBase.this.getValueBinding(name);
            if (vb != null) {
                return vb.getValue(UIComponentBase.this.getFacesContext());
            }
            return null;
        }

        public Object put(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException();
            }
            String name = (String)key;
            PropertyDescriptor pd = UIComponentBase.this.getPropertyDescriptor(name);
            if (pd != null) {
                try {
                    Method writeMethod;
                    Object result = null;
                    Method readMethod = pd.getReadMethod();
                    if (readMethod != null) {
                        result = readMethod.invoke((Object)UIComponentBase.this, empty);
                    }
                    if ((writeMethod = pd.getWriteMethod()) == null) {
                        throw new IllegalArgumentException();
                    }
                    writeMethod.invoke((Object)UIComponentBase.this, value);
                    return result;
                }
                catch (IllegalAccessException e) {
                    throw new FacesException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FacesException(e.getTargetException());
                }
            }
            if (value == null) {
                throw new NullPointerException();
            }
            return super.put(key, value);
        }

        public void putAll(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                this.put(key, map.get(key));
            }
        }

        public Object remove(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            String name = (String)key;
            PropertyDescriptor pd = UIComponentBase.this.getPropertyDescriptor(name);
            if (pd != null) {
                throw new IllegalArgumentException(name);
            }
            return super.remove(key);
        }
    }
}

