/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.component.MethodBindingAdapterBase;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

class MethodBindingValueChangeListener
extends MethodBindingAdapterBase
implements ValueChangeListener,
StateHolder {
    private MethodBinding methodBinding = null;
    private boolean tranzient = false;

    public MethodBindingValueChangeListener() {
    }

    public MethodBindingValueChangeListener(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodBinding getWrapped() {
        return this.methodBinding;
    }

    public void processValueChange(ValueChangeEvent actionEvent) throws AbortProcessingException {
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            this.methodBinding.invoke(context, new Object[]{actionEvent});
        }
        catch (EvaluationException ee) {
            Throwable cause = this.getExpectedCause(AbortProcessingException.class, ee);
            if (cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(ee.getMessage());
        }
    }

    public Object saveState(FacesContext context) {
        Object[] result = null;
        if (!this.tranzient) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.methodBinding)).saveState(context), this.methodBinding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.methodBinding;
            }
        }
        return result;
    }

    public void restoreState(FacesContext context, Object state) {
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodBinding result = null;
            Class toRestoreClass = null;
            if (null != className) {
                try {
                    toRestoreClass = MethodBindingValueChangeListener.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodBinding)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.methodBinding = result;
            }
        } else {
            this.methodBinding = (MethodBinding)state;
        }
    }

    public boolean isTransient() {
        return this.tranzient;
    }

    public void setTransient(boolean newTransientValue) {
        this.tranzient = newTransientValue;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader.loadClass(name);
    }
}

