/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.component.ContextCallback;
import javax.faces.component.TypedCollections;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.ViewMapCreatedEvent;
import javax.faces.event.ViewMapDestroyedEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static Lifecycle lifecycle;
    private static final Logger LOGGER;
    private static final String LOCATION_IDENTIFIER_PREFIX = "javax_faces_location_";
    private static final Map<String, String> LOCATION_IDENTIFIER_MAP;
    private static final String ORIGINAL_WRITER = "javax.faces.originalWriter";
    private int lastId = 0;
    private boolean skipPhase;
    private boolean beforeMethodException;
    private ListIterator<PhaseListener> phaseListenerIterator;
    private String renderKitId = null;
    private String viewId = null;
    private MethodExpression beforePhase = null;
    private MethodExpression afterPhase = null;
    private List<PhaseListener> phaseListeners = null;
    private List<List<FacesEvent>> events = null;
    private Locale locale = null;
    private Map<String, Object> viewScope = null;
    private Object[] values;

    public UIViewRoot() {
        this.setRendererType(null);
    }

    @Override
    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        String result;
        if (null != this.renderKitId) {
            result = this.renderKitId;
        } else {
            ValueExpression vb = this.getValueExpression("renderKitId");
            FacesContext context = this.getFacesContext();
            if (vb != null) {
                try {
                    result = (String)vb.getValue(context.getELContext());
                }
                catch (ELException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{vb.getExpressionString(), "renderKitId"});
                    }
                    result = null;
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    public void setRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public MethodExpression getBeforePhaseListener() {
        return this.beforePhase;
    }

    public void setBeforePhaseListener(MethodExpression newBeforePhase) {
        this.beforePhase = newBeforePhase;
    }

    public MethodExpression getAfterPhaseListener() {
        return this.afterPhase;
    }

    public void setAfterPhaseListener(MethodExpression newAfterPhase) {
        this.afterPhase = newAfterPhase;
    }

    public void removePhaseListener(PhaseListener toRemove) {
        if (null != this.phaseListeners) {
            this.phaseListeners.remove(toRemove);
        }
    }

    public void addPhaseListener(PhaseListener newPhaseListener) {
        if (null == this.phaseListeners) {
            this.phaseListeners = new ArrayList<PhaseListener>();
        }
        this.phaseListeners.add(newPhaseListener);
    }

    public List<PhaseListener> getPhaseListeners() {
        List<Object> result = null == this.phaseListeners ? Collections.unmodifiableList(Collections.emptyList()) : Collections.unmodifiableList(this.phaseListeners);
        return result;
    }

    public void addComponentResource(FacesContext context, UIComponent componentResource) {
        this.addComponentResource(context, componentResource, null);
    }

    public void addComponentResource(FacesContext context, UIComponent componentResource, String target) {
        Map<String, Object> attributes = componentResource.getAttributes();
        if (target == null) {
            target = (String)attributes.get("target");
        }
        if (target == null) {
            target = "head";
        }
        List<UIComponent> facetChildren = this.getComponentResources(context, target);
        facetChildren.add(componentResource);
    }

    public List<UIComponent> getComponentResources(FacesContext context, String target) {
        if (target == null) {
            throw new NullPointerException();
        }
        String location = UIViewRoot.getIdentifier(target);
        UIComponent facet = this.getFacet(location);
        if (facet == null) {
            facet = context.getApplication().createComponent("javax.faces.Panel");
            facet.setId(location);
            this.getFacets().put(location, facet);
        }
        return facet.getChildren();
    }

    public void removeComponentResource(FacesContext context, UIComponent componentResource) {
        this.removeComponentResource(context, componentResource, null);
    }

    public void removeComponentResource(FacesContext context, UIComponent componentResource, String target) {
        Map<String, Object> attributes = componentResource.getAttributes();
        if (target == null) {
            target = (String)attributes.get("target");
        }
        if (target == null) {
            target = "head";
        }
        List<UIComponent> facetChildren = this.getComponentResources(context, target);
        facetChildren.remove(componentResource);
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.events == null) {
            int len = PhaseId.VALUES.size();
            ArrayList<List<FacesEvent>> events = new ArrayList<List<FacesEvent>>(len);
            for (int i = 0; i < len; ++i) {
                events.add(new ArrayList(5));
            }
            this.events = events;
        }
        this.events.get(event.getPhaseId().getOrdinal()).add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastEvents(FacesContext context, PhaseId phaseId) {
        boolean hasMoreCurrentPhaseEvents;
        boolean hasMoreAnyPhaseEvents;
        if (null == this.events) {
            return;
        }
        List<FacesEvent> eventsForPhaseId = this.events.get(PhaseId.ANY_PHASE.getOrdinal());
        do {
            UIComponent source;
            FacesEvent event;
            if (null != eventsForPhaseId) {
                while (!eventsForPhaseId.isEmpty()) {
                    event = eventsForPhaseId.get(0);
                    source = event.getComponent();
                    try {
                        this.pushComponentToEL(context, source);
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            UIComponent component = event.getComponent();
                            String id = "";
                            if (component != null && (id = component.getId()) == null) {
                                id = component.getClientId(context);
                            }
                            LOGGER.log(Level.SEVERE, "error.component.abortprocessing_thrown", new Object[]{event.getClass().getName(), phaseId.toString(), id});
                            LOGGER.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                    finally {
                        this.popComponentFromEL(context);
                    }
                    eventsForPhaseId.remove(0);
                }
            }
            if (null != (eventsForPhaseId = this.events.get(phaseId.getOrdinal()))) {
                while (!eventsForPhaseId.isEmpty()) {
                    event = eventsForPhaseId.get(0);
                    source = event.getComponent();
                    try {
                        this.pushComponentToEL(context, source);
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException ignored) {
                    }
                    finally {
                        this.popComponentFromEL(context);
                    }
                    eventsForPhaseId.remove(0);
                }
            }
            hasMoreAnyPhaseEvents = null != (eventsForPhaseId = this.events.get(PhaseId.ANY_PHASE.getOrdinal())) && !eventsForPhaseId.isEmpty();
            boolean bl = hasMoreCurrentPhaseEvents = null != this.events.get(phaseId.getOrdinal()) && !this.events.get(phaseId.getOrdinal()).isEmpty();
        } while (hasMoreAnyPhaseEvents || hasMoreCurrentPhaseEvents);
    }

    private void initState() {
        this.skipPhase = false;
        this.beforeMethodException = false;
        this.phaseListenerIterator = this.phaseListeners != null ? this.phaseListeners.listIterator() : null;
    }

    private void notifyBefore(FacesContext context, PhaseId phaseId) {
        if (null != this.beforePhase || null != this.phaseListenerIterator) {
            this.notifyPhaseListeners(context, phaseId, true);
        }
    }

    private void notifyAfter(FacesContext context, PhaseId phaseId) {
        if (null != this.afterPhase || null != this.phaseListenerIterator) {
            this.notifyPhaseListeners(context, phaseId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRestoreState(FacesContext context, Object state) {
        this.initState();
        try {
            super.processRestoreState(context, state);
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.RESTORE_VIEW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDecodes(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.APPLY_REQUEST_VALUES);
        if (context.isAjaxRequest() && this.processPartialDecodes(context)) {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.APPLY_REQUEST_VALUES);
            return;
        }
        try {
            if (!this.skipPhase) {
                super.processDecodes(context);
                this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.APPLY_REQUEST_VALUES);
        }
    }

    private boolean processPartialDecodes(FacesContext context) {
        boolean invokedCallback = this.invokeContextCallbackOnSubtrees(context, PhaseId.APPLY_REQUEST_VALUES);
        ResponseWriter writer = context.getPartialResponseWriter();
        context.setResponseWriter(writer);
        if (!invokedCallback) {
            return false;
        }
        String preViewId = context.getViewRoot().getViewId();
        this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        String postViewId = context.getViewRoot().getViewId();
        if (!postViewId.equals(preViewId)) {
            context.setRenderAll(true);
        }
        return true;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this.initState();
        this.notifyBefore(context, PhaseId.RENDER_RESPONSE);
        if (context.isAjaxRequest() && this.encodePartialResponseBegin(context)) {
            return;
        }
        if (!this.skipPhase) {
            super.encodeBegin(context);
        }
    }

    private boolean encodePartialResponseBegin(FacesContext context) {
        try {
            context.enableResponseWriting(true);
            ResponseWriter writer = context.getPartialResponseWriter();
            ResponseWriter orig = context.getResponseWriter();
            context.getAttributes().put(ORIGINAL_WRITER, orig);
            context.setResponseWriter(writer);
            ExternalContext extContext = context.getExternalContext();
            if (!context.isRenderNone() && extContext.getResponse() instanceof HttpServletResponse) {
                HttpServletResponse servletResponse = (HttpServletResponse)extContext.getResponse();
                servletResponse.setContentType("text/xml");
                servletResponse.setHeader("Cache-Control", "no-cache");
                writer.startElement("partial-response", this);
                writer.startElement("components", this);
            }
            if (context.isRenderAll()) {
                writer.startElement("render", this);
                writer.writeAttribute("id", "javax.faces.ViewRoot", "id");
                writer.startElement("markup", this);
                writer.write("<![CDATA[");
            }
        }
        catch (IOException ex) {
            this.cleanupAfterView(context);
        }
        catch (RuntimeException ex) {
            this.cleanupAfterView(context);
            throw ex;
        }
        return true;
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (context.isAjaxRequest() && !context.isRenderAll() && this.encodePartialChildren(context)) {
            return;
        }
        super.encodeChildren(context);
    }

    private boolean encodePartialChildren(FacesContext context) {
        return context.isRenderNone() || this.invokeContextCallbackOnSubtrees(context, PhaseId.RENDER_RESPONSE);
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        if (!context.isAjaxRequest()) {
            super.encodeEnd(context);
            this.notifyAfter(context, PhaseId.RENDER_RESPONSE);
            return;
        }
        this.encodePartialResponseEnd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodePartialResponseEnd(FacesContext context) {
        try {
            ResponseWriter writer = context.getResponseWriter();
            if (context.isRenderAll()) {
                writer.write("]]>");
                writer.endElement("markup");
                writer.endElement("render");
            }
            if (!context.isRenderNone()) {
                writer.endElement("components");
            }
            writer.startElement("state", this);
            String state = context.getApplication().getStateManager().getViewState(context);
            writer.write("<![CDATA[" + state + "]]>");
            writer.endElement("state");
            writer.endElement("partial-response");
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(ioe.toString());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, ioe.toString(), ioe);
            }
        }
        finally {
            this.cleanupAfterView(context);
        }
    }

    @Override
    public boolean getRendersChildren() {
        boolean value = super.getRendersChildren();
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.isAjaxRequest() && !context.isRenderAll()) {
            value = true;
        }
        return value;
    }

    private void cleanupAfterView(FacesContext context) {
        ResponseWriter orig = (ResponseWriter)context.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        context.setResponseWriter(orig);
    }

    private void notifyPhaseListeners(FacesContext context, PhaseId phaseId, boolean isBefore) {
        MethodExpression expression;
        PhaseEvent event = UIViewRoot.createPhaseEvent(context, phaseId);
        boolean hasPhaseMethodExpression = isBefore && null != this.beforePhase || !isBefore && null != this.afterPhase && !this.beforeMethodException;
        MethodExpression methodExpression = expression = isBefore ? this.beforePhase : this.afterPhase;
        if (hasPhaseMethodExpression) {
            try {
                expression.invoke(context.getELContext(), new Object[]{event});
                this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
            }
            catch (Exception e) {
                if (isBefore) {
                    this.beforeMethodException = true;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{expression.getExpressionString(), isBefore ? "beforePhase" : "afterPhase"});
                }
                return;
            }
        }
        if (this.phaseListenerIterator != null && !this.beforeMethodException) {
            while (isBefore ? this.phaseListenerIterator.hasNext() : this.phaseListenerIterator.hasPrevious()) {
                PhaseListener curListener;
                PhaseListener phaseListener = curListener = isBefore ? this.phaseListenerIterator.next() : this.phaseListenerIterator.previous();
                if (phaseId != curListener.getPhaseId() && PhaseId.ANY_PHASE != curListener.getPhaseId()) continue;
                try {
                    if (isBefore) {
                        curListener.beforePhase(event);
                    } else {
                        curListener.afterPhase(event);
                    }
                    this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
                }
                catch (Exception e) {
                    if (isBefore && this.phaseListenerIterator.hasPrevious()) {
                        this.phaseListenerIterator.previous();
                    }
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.uiviewroot_error_invoking_phaselistener", curListener.getClass().getName());
                    }
                    return;
                }
            }
        }
    }

    private static PhaseEvent createPhaseEvent(FacesContext context, PhaseId phaseId) throws FacesException {
        if (lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = context.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        return new PhaseEvent(context, phaseId, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processValidators(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.PROCESS_VALIDATIONS);
        if (context.isAjaxRequest() && this.processPartialValidators(context)) {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.PROCESS_VALIDATIONS);
            return;
        }
        try {
            if (!this.skipPhase) {
                super.processValidators(context);
                this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.PROCESS_VALIDATIONS);
        }
    }

    private boolean processPartialValidators(FacesContext context) {
        boolean invokedCallback = this.invokeContextCallbackOnSubtrees(context, PhaseId.PROCESS_VALIDATIONS);
        if (!invokedCallback) {
            return false;
        }
        String preViewId = context.getViewRoot().getViewId();
        this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
        String postViewId = context.getViewRoot().getViewId();
        if (!postViewId.equals(preViewId)) {
            context.setRenderAll(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdates(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.UPDATE_MODEL_VALUES);
        if (context.isAjaxRequest() && this.processPartialUpdates(context)) {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.UPDATE_MODEL_VALUES);
            return;
        }
        try {
            if (!this.skipPhase) {
                super.processUpdates(context);
                this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    private boolean processPartialUpdates(FacesContext context) {
        boolean invokedCallback = this.invokeContextCallbackOnSubtrees(context, PhaseId.UPDATE_MODEL_VALUES);
        if (!invokedCallback) {
            return false;
        }
        String preViewId = context.getViewRoot().getViewId();
        this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
        String postViewId = context.getViewRoot().getViewId();
        if (!postViewId.equals(preViewId)) {
            context.setRenderAll(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.INVOKE_APPLICATION);
        try {
            if (!this.skipPhase) {
                this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.INVOKE_APPLICATION);
        }
    }

    private void clearFacesEvents(FacesContext context) {
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (List<FacesEvent> eventList : this.events) {
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public Locale getLocale() {
        Locale result = null;
        if (null != this.locale) {
            result = this.locale;
        } else {
            ValueExpression vb = this.getValueExpression("locale");
            FacesContext context = this.getFacesContext();
            if (vb != null) {
                Object resultLocale;
                block11: {
                    resultLocale = null;
                    try {
                        resultLocale = vb.getValue(context.getELContext());
                    }
                    catch (ELException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                        LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{vb.getExpressionString(), "locale"});
                    }
                }
                if (null == resultLocale) {
                    result = context.getApplication().getViewHandler().calculateLocale(context);
                } else if (resultLocale instanceof Locale) {
                    result = (Locale)resultLocale;
                } else if (resultLocale instanceof String) {
                    result = UIViewRoot.getLocaleFromString((String)resultLocale);
                }
            } else {
                result = context.getApplication().getViewHandler().calculateLocale(context);
            }
        }
        return result;
    }

    private static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int inputLength = localeStr.length();
        int i = 0;
        int j = 0;
        if (inputLength >= 2 && (i = UIViewRoot.indexOfSet(localeStr, seps, 0)) == -1) {
            if (2 != localeStr.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (i != -1) {
            lang = localeStr.substring(0, i);
            if (inputLength >= 5 && -1 == (j = UIViewRoot.indexOfSet(localeStr, seps, i + 1))) {
                if (inputLength != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (j != -1) {
                country = localeStr.substring(i + 1, j);
                if (inputLength >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (variant != null && country != null && lang != null) {
            result = new Locale(lang, country, variant);
        } else if (lang != null && country != null) {
            result = new Locale(lang, country);
        } else if (lang != null) {
            result = new Locale(lang, "");
        }
        return result;
    }

    private static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        FacesContext.getCurrentInstance().getELContext().setLocale(locale);
    }

    public Map<String, Object> getViewMap() {
        return this.getViewMap(true);
    }

    public Map<String, Object> getViewMap(boolean create) {
        if (create && this.viewScope == null) {
            this.viewScope = new ViewMap(this.getFacesContext().getApplication().getProjectStage());
            this.getFacesContext().getApplication().publishEvent(ViewMapCreatedEvent.class, this);
        }
        return this.viewScope;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[9];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.renderKitId;
        this.values[2] = this.viewId;
        this.values[3] = this.locale;
        this.values[4] = this.lastId;
        this.values[5] = UIViewRoot.saveAttachedState(context, this.beforePhase);
        this.values[6] = UIViewRoot.saveAttachedState(context, this.afterPhase);
        this.values[7] = UIViewRoot.saveAttachedState(context, this.phaseListeners);
        this.values[8] = UIViewRoot.saveAttachedState(context, this.viewScope);
        return this.values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.renderKitId = (String)this.values[1];
        this.viewId = (String)this.values[2];
        this.locale = (Locale)this.values[3];
        this.lastId = (Integer)this.values[4];
        this.beforePhase = (MethodExpression)UIViewRoot.restoreAttachedState(context, this.values[5]);
        this.afterPhase = (MethodExpression)UIViewRoot.restoreAttachedState(context, this.values[6]);
        this.phaseListeners = TypedCollections.dynamicallyCastList((List)UIViewRoot.restoreAttachedState(context, this.values[7]), PhaseListener.class);
        this.viewScope = (Map)UIViewRoot.restoreAttachedState(context, this.values[8]);
    }

    private static String getIdentifier(String target) {
        String id = LOCATION_IDENTIFIER_MAP.get(target);
        if (id == null) {
            id = LOCATION_IDENTIFIER_PREFIX + target;
            LOCATION_IDENTIFIER_MAP.put(target, id);
        }
        return id;
    }

    private boolean invokeContextCallbackOnSubtrees(FacesContext context, PhaseId phaseId) {
        List<String> subtrees;
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            subtrees = context.getRenderPhaseClientIds();
        } else {
            subtrees = context.getExecutePhaseClientIds();
            if (subtrees.isEmpty()) {
                subtrees = context.getRenderPhaseClientIds();
            }
        }
        boolean result = false;
        if (subtrees != null && !subtrees.isEmpty()) {
            PhaseAwareContextCallback cb = new PhaseAwareContextCallback(phaseId);
            for (String cur : subtrees) {
                if (!this.invokeOnComponent(context, cur, cb)) continue;
                result = true;
            }
        }
        return result;
    }

    static {
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
        LOCATION_IDENTIFIER_MAP = new HashMap<String, String>(6, 1.0f);
        LOCATION_IDENTIFIER_MAP.put("head", "javax_faces_location_HEAD");
        LOCATION_IDENTIFIER_MAP.put("form", "javax_faces_location_FORM");
        LOCATION_IDENTIFIER_MAP.put("body", "javax_faces_location_BODY");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ViewMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -1L;
        private ProjectStage stage;

        ViewMap(ProjectStage stage) {
            this.stage = stage;
        }

        @Override
        public void clear() {
            FacesContext context = FacesContext.getCurrentInstance();
            context.getApplication().publishEvent(ViewMapDestroyedEvent.class, context.getViewRoot());
            super.clear();
        }

        @Override
        public Object put(String key, Object value) {
            if (ProjectStage.Development.equals((Object)this.stage) && !(value instanceof Serializable)) {
                LOGGER.log(Level.WARNING, "warning.component.uiviewroot_non_serializable_attribute_viewmap", new Object[]{key, value.getClass().getName()});
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.put(k, v);
            }
        }
    }

    private static class PhaseAwareContextCallback
    implements ContextCallback {
        private PhaseId curPhase = null;

        private PhaseAwareContextCallback(PhaseId curPhase) {
            this.curPhase = curPhase;
        }

        public void invokeContextCallback(FacesContext facesContext, UIComponent comp) {
            block9: {
                try {
                    if (this.curPhase == PhaseId.APPLY_REQUEST_VALUES) {
                        comp.processDecodes(facesContext);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.PROCESS_VALIDATIONS) {
                        comp.processValidators(facesContext);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.UPDATE_MODEL_VALUES) {
                        comp.processUpdates(facesContext);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.RENDER_RESPONSE) {
                        ResponseWriter writer;
                        block10: {
                            if (!comp.isRendered()) break block9;
                            writer = facesContext.getResponseWriter();
                            writer.startElement("render", comp);
                            writer.writeAttribute("id", comp.getClientId(facesContext), "id");
                            try {
                                writer.startElement("markup", comp);
                                writer.write("<![CDATA[");
                                comp.encodeAll(facesContext);
                                writer.write("]]>");
                                writer.endElement("markup");
                            }
                            catch (Exception ce) {
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.severe(ce.toString());
                                }
                                if (!LOGGER.isLoggable(Level.FINE)) break block10;
                                LOGGER.log(Level.FINE, ce.toString(), ce);
                            }
                        }
                        writer.endElement("render");
                        break block9;
                    }
                    throw new IllegalStateException("I18N: Unexpected PhaseId passed to  PhaseAwareContextCallback: " + this.curPhase.toString());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

