/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.component.TypedCollections;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AfterRestoreStateEvent;
import javax.faces.event.ExceptionEvent;
import javax.faces.event.ExceptionEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.ViewMapCreatedEvent;
import javax.faces.event.ViewMapDestroyedEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static Lifecycle lifecycle;
    private static final Logger LOGGER;
    private static final String LOCATION_IDENTIFIER_PREFIX = "javax_faces_location_";
    private static final Map<String, String> LOCATION_IDENTIFIER_MAP;
    private int lastId = 0;
    private boolean skipPhase;
    private boolean beforeMethodException;
    private ListIterator<PhaseListener> phaseListenerIterator;
    private String renderKitId = null;
    private String viewId = null;
    private MethodExpression beforePhase = null;
    private MethodExpression afterPhase = null;
    private List<PhaseListener> phaseListeners = null;
    private List<List<FacesEvent>> events = null;
    private Locale locale = null;
    private Map<String, Object> viewScope = null;
    private Object[] values;

    public UIViewRoot() {
        this.setRendererType(null);
    }

    @Override
    public boolean isInView() {
        return true;
    }

    @Override
    public void setInView(boolean isInView) {
    }

    @Override
    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        String result;
        if (null != this.renderKitId) {
            result = this.renderKitId;
        } else {
            ValueExpression vb = this.getValueExpression("renderKitId");
            FacesContext context = this.getFacesContext();
            if (vb != null) {
                try {
                    result = (String)vb.getValue(context.getELContext());
                }
                catch (ELException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{vb.getExpressionString(), "renderKitId"});
                    }
                    result = null;
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    public void setRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public MethodExpression getBeforePhaseListener() {
        return this.beforePhase;
    }

    public void setBeforePhaseListener(MethodExpression newBeforePhase) {
        this.beforePhase = newBeforePhase;
    }

    public MethodExpression getAfterPhaseListener() {
        return this.afterPhase;
    }

    public void setAfterPhaseListener(MethodExpression newAfterPhase) {
        this.afterPhase = newAfterPhase;
    }

    public void removePhaseListener(PhaseListener toRemove) {
        if (null != this.phaseListeners) {
            this.phaseListeners.remove(toRemove);
        }
    }

    public void addPhaseListener(PhaseListener newPhaseListener) {
        if (null == this.phaseListeners) {
            this.phaseListeners = new ArrayList<PhaseListener>();
        }
        this.phaseListeners.add(newPhaseListener);
    }

    public List<PhaseListener> getPhaseListeners() {
        List<Object> result = null == this.phaseListeners ? Collections.unmodifiableList(Collections.emptyList()) : Collections.unmodifiableList(this.phaseListeners);
        return result;
    }

    public void addComponentResource(FacesContext context, UIComponent componentResource) {
        this.addComponentResource(context, componentResource, null);
    }

    public void addComponentResource(FacesContext context, UIComponent componentResource, String target) {
        Map<String, Object> attributes = componentResource.getAttributes();
        if (target == null) {
            target = (String)attributes.get("target");
        }
        if (target == null) {
            target = "head";
        }
        List<UIComponent> facetChildren = this.getComponentResources(context, target, true);
        facetChildren.add(componentResource);
    }

    public List<UIComponent> getComponentResources(FacesContext context, String target) {
        if (target == null) {
            throw new NullPointerException();
        }
        List<UIComponent> resources = this.getComponentResources(context, target, false);
        return resources != null ? resources : Collections.emptyList();
    }

    public void removeComponentResource(FacesContext context, UIComponent componentResource) {
        this.removeComponentResource(context, componentResource, null);
    }

    public void removeComponentResource(FacesContext context, UIComponent componentResource, String target) {
        List<UIComponent> facetChildren;
        Map<String, Object> attributes = componentResource.getAttributes();
        if (target == null) {
            target = (String)attributes.get("target");
        }
        if (target == null) {
            target = "head";
        }
        if ((facetChildren = this.getComponentResources(context, target, false)) != null) {
            facetChildren.remove(componentResource);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.events == null) {
            int len = PhaseId.VALUES.size();
            ArrayList<List<FacesEvent>> events = new ArrayList<List<FacesEvent>>(len);
            for (int i = 0; i < len; ++i) {
                events.add(new ArrayList(5));
            }
            this.events = events;
        }
        this.events.get(event.getPhaseId().getOrdinal()).add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastEvents(FacesContext context, PhaseId phaseId) {
        boolean hasMoreCurrentPhaseEvents;
        boolean hasMoreAnyPhaseEvents;
        if (null == this.events) {
            return;
        }
        List<FacesEvent> eventsForPhaseId = this.events.get(PhaseId.ANY_PHASE.getOrdinal());
        do {
            UIComponent source;
            FacesEvent event;
            if (null != eventsForPhaseId) {
                while (!eventsForPhaseId.isEmpty()) {
                    event = eventsForPhaseId.get(0);
                    source = event.getComponent();
                    try {
                        this.pushComponentToEL(context, source);
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        context.getApplication().publishEvent(ExceptionEvent.class, new ExceptionEventContext(context, e, source, phaseId));
                    }
                    finally {
                        this.popComponentFromEL(context);
                    }
                    eventsForPhaseId.remove(0);
                }
            }
            if (null != (eventsForPhaseId = this.events.get(phaseId.getOrdinal()))) {
                while (!eventsForPhaseId.isEmpty()) {
                    event = eventsForPhaseId.get(0);
                    source = event.getComponent();
                    try {
                        this.pushComponentToEL(context, source);
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException ape) {
                        context.getApplication().publishEvent(ExceptionEvent.class, new ExceptionEventContext(context, ape, source, phaseId));
                    }
                    finally {
                        this.popComponentFromEL(context);
                    }
                    eventsForPhaseId.remove(0);
                }
            }
            hasMoreAnyPhaseEvents = null != (eventsForPhaseId = this.events.get(PhaseId.ANY_PHASE.getOrdinal())) && !eventsForPhaseId.isEmpty();
            boolean bl = hasMoreCurrentPhaseEvents = null != this.events.get(phaseId.getOrdinal()) && !this.events.get(phaseId.getOrdinal()).isEmpty();
        } while (hasMoreAnyPhaseEvents || hasMoreCurrentPhaseEvents);
    }

    private void initState() {
        this.skipPhase = false;
        this.beforeMethodException = false;
        this.phaseListenerIterator = this.phaseListeners != null ? this.phaseListeners.listIterator() : null;
    }

    private void notifyBefore(FacesContext context, PhaseId phaseId) {
        if (null != this.beforePhase || null != this.phaseListenerIterator) {
            this.notifyPhaseListeners(context, phaseId, true);
        }
    }

    private void notifyAfter(FacesContext context, PhaseId phaseId) {
        if (null != this.afterPhase || null != this.phaseListenerIterator) {
            this.notifyPhaseListeners(context, phaseId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRestoreState(FacesContext context, Object state) {
        AfterRestoreStateEvent event;
        this.initState();
        try {
            super.processRestoreState(context, state);
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.RESTORE_VIEW);
            event = new AfterRestoreStateEvent(this);
        }
        catch (Throwable throwable) {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.RESTORE_VIEW);
            AfterRestoreStateEvent event2 = new AfterRestoreStateEvent(this);
            try {
                this.visitTree(VisitContext.createVisitContext(context), new VisitCallback(event2){
                    final /* synthetic */ AfterRestoreStateEvent val$event;
                    {
                        this.val$event = afterRestoreStateEvent;
                    }

                    public VisitResult visit(VisitContext context, UIComponent target) {
                        this.val$event.setComponent(target);
                        target.processEvent(this.val$event);
                        return VisitResult.ACCEPT;
                    }
                });
            }
            catch (AbortProcessingException e) {
                context.getApplication().publishEvent(ExceptionEvent.class, new ExceptionEventContext(context, e, null, PhaseId.RESTORE_VIEW));
            }
            throw throwable;
        }
        try {
            this.visitTree(VisitContext.createVisitContext(context), new /* invalid duplicate definition of identical inner class */);
        }
        catch (AbortProcessingException e) {
            context.getApplication().publishEvent(ExceptionEvent.class, new ExceptionEventContext(context, e, null, PhaseId.RESTORE_VIEW));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDecodes(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.APPLY_REQUEST_VALUES);
        try {
            if (!this.skipPhase) {
                if (context.getPartialViewContext().isPartialRequest()) {
                    context.getPartialViewContext().processPartial(PhaseId.APPLY_REQUEST_VALUES);
                } else {
                    super.processDecodes(context);
                }
                this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.APPLY_REQUEST_VALUES);
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this.initState();
        this.notifyBefore(context, PhaseId.RENDER_RESPONSE);
        if (!this.skipPhase) {
            super.encodeBegin(context);
        }
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (context.getPartialViewContext().isAjaxRequest()) {
            context.getPartialViewContext().processPartial(PhaseId.RENDER_RESPONSE);
        } else {
            super.encodeChildren(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.notifyAfter(context, PhaseId.RENDER_RESPONSE);
    }

    @Override
    public boolean getRendersChildren() {
        boolean value = super.getRendersChildren();
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext().isAjaxRequest()) {
            value = true;
        }
        return value;
    }

    private void notifyPhaseListeners(FacesContext context, PhaseId phaseId, boolean isBefore) {
        MethodExpression expression;
        PhaseEvent event = UIViewRoot.createPhaseEvent(context, phaseId);
        boolean hasPhaseMethodExpression = isBefore && null != this.beforePhase || !isBefore && null != this.afterPhase && !this.beforeMethodException;
        MethodExpression methodExpression = expression = isBefore ? this.beforePhase : this.afterPhase;
        if (hasPhaseMethodExpression) {
            try {
                expression.invoke(context.getELContext(), new Object[]{event});
                this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
            }
            catch (Exception e) {
                if (isBefore) {
                    this.beforeMethodException = true;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{expression.getExpressionString(), isBefore ? "beforePhase" : "afterPhase"});
                }
                return;
            }
        }
        if (this.phaseListenerIterator != null && !this.beforeMethodException) {
            while (isBefore ? this.phaseListenerIterator.hasNext() : this.phaseListenerIterator.hasPrevious()) {
                PhaseListener curListener;
                PhaseListener phaseListener = curListener = isBefore ? this.phaseListenerIterator.next() : this.phaseListenerIterator.previous();
                if (phaseId != curListener.getPhaseId() && PhaseId.ANY_PHASE != curListener.getPhaseId()) continue;
                try {
                    if (isBefore) {
                        curListener.beforePhase(event);
                    } else {
                        curListener.afterPhase(event);
                    }
                    this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
                }
                catch (Exception e) {
                    if (isBefore && this.phaseListenerIterator.hasPrevious()) {
                        this.phaseListenerIterator.previous();
                    }
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.uiviewroot_error_invoking_phaselistener", curListener.getClass().getName());
                    }
                    return;
                }
            }
        }
    }

    private static PhaseEvent createPhaseEvent(FacesContext context, PhaseId phaseId) throws FacesException {
        if (lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = context.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        return new PhaseEvent(context, phaseId, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processValidators(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.PROCESS_VALIDATIONS);
        try {
            if (!this.skipPhase) {
                if (context.getPartialViewContext().isPartialRequest()) {
                    context.getPartialViewContext().processPartial(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    super.processValidators(context);
                }
                this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.PROCESS_VALIDATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdates(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.UPDATE_MODEL_VALUES);
        try {
            if (!this.skipPhase) {
                if (context.getPartialViewContext().isPartialRequest()) {
                    context.getPartialViewContext().processPartial(PhaseId.UPDATE_MODEL_VALUES);
                } else {
                    super.processUpdates(context);
                }
                this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.INVOKE_APPLICATION);
        try {
            if (!this.skipPhase) {
                this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.INVOKE_APPLICATION);
        }
    }

    private void clearFacesEvents(FacesContext context) {
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (List<FacesEvent> eventList : this.events) {
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public Locale getLocale() {
        Locale result = null;
        if (null != this.locale) {
            result = this.locale;
        } else {
            ValueExpression vb = this.getValueExpression("locale");
            FacesContext context = this.getFacesContext();
            if (vb != null) {
                Object resultLocale;
                block11: {
                    resultLocale = null;
                    try {
                        resultLocale = vb.getValue(context.getELContext());
                    }
                    catch (ELException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                        LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{vb.getExpressionString(), "locale"});
                    }
                }
                if (null == resultLocale) {
                    result = context.getApplication().getViewHandler().calculateLocale(context);
                } else if (resultLocale instanceof Locale) {
                    result = (Locale)resultLocale;
                } else if (resultLocale instanceof String) {
                    result = UIViewRoot.getLocaleFromString((String)resultLocale);
                }
            } else {
                result = context.getApplication().getViewHandler().calculateLocale(context);
            }
        }
        return result;
    }

    private static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int inputLength = localeStr.length();
        int i = 0;
        int j = 0;
        if (inputLength >= 2 && (i = UIViewRoot.indexOfSet(localeStr, seps, 0)) == -1) {
            if (2 != localeStr.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (i != -1) {
            lang = localeStr.substring(0, i);
            if (inputLength >= 5 && -1 == (j = UIViewRoot.indexOfSet(localeStr, seps, i + 1))) {
                if (inputLength != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (j != -1) {
                country = localeStr.substring(i + 1, j);
                if (inputLength >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (variant != null && country != null && lang != null) {
            result = new Locale(lang, country, variant);
        } else if (lang != null && country != null) {
            result = new Locale(lang, country);
        } else if (lang != null) {
            result = new Locale(lang, "");
        }
        return result;
    }

    private static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        FacesContext.getCurrentInstance().getELContext().setLocale(locale);
    }

    public Map<String, Object> getViewMap() {
        return this.getViewMap(true);
    }

    public Map<String, Object> getViewMap(boolean create) {
        if (create && this.viewScope == null) {
            this.viewScope = new ViewMap(this.getFacesContext().getApplication().getProjectStage());
            this.getFacesContext().getApplication().publishEvent(ViewMapCreatedEvent.class, this);
        }
        return this.viewScope;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[9];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.renderKitId;
        this.values[2] = this.viewId;
        this.values[3] = this.locale;
        this.values[4] = this.lastId;
        this.values[5] = UIViewRoot.saveAttachedState(context, this.beforePhase);
        this.values[6] = UIViewRoot.saveAttachedState(context, this.afterPhase);
        this.values[7] = UIViewRoot.saveAttachedState(context, this.phaseListeners);
        this.values[8] = UIViewRoot.saveAttachedState(context, this.viewScope);
        return this.values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.renderKitId = (String)this.values[1];
        this.viewId = (String)this.values[2];
        this.locale = (Locale)this.values[3];
        this.lastId = (Integer)this.values[4];
        this.beforePhase = (MethodExpression)UIViewRoot.restoreAttachedState(context, this.values[5]);
        this.afterPhase = (MethodExpression)UIViewRoot.restoreAttachedState(context, this.values[6]);
        this.phaseListeners = TypedCollections.dynamicallyCastList((List)UIViewRoot.restoreAttachedState(context, this.values[7]), PhaseListener.class);
        this.viewScope = (Map)UIViewRoot.restoreAttachedState(context, this.values[8]);
    }

    private static String getIdentifier(String target) {
        String id = LOCATION_IDENTIFIER_MAP.get(target);
        if (id == null) {
            id = LOCATION_IDENTIFIER_PREFIX + target;
            LOCATION_IDENTIFIER_MAP.put(target, id);
        }
        return id;
    }

    private List<UIComponent> getComponentResources(FacesContext context, String target, boolean create) {
        String location = UIViewRoot.getIdentifier(target);
        UIComponent facet = this.getFacet(location);
        if (facet == null && create) {
            facet = context.getApplication().createComponent("javax.faces.Panel");
            facet.setId(location);
            this.getFacets().put(location, facet);
        }
        return facet != null ? facet.getChildren() : null;
    }

    static {
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
        LOCATION_IDENTIFIER_MAP = new HashMap<String, String>(6, 1.0f);
        LOCATION_IDENTIFIER_MAP.put("head", "javax_faces_location_HEAD");
        LOCATION_IDENTIFIER_MAP.put("form", "javax_faces_location_FORM");
        LOCATION_IDENTIFIER_MAP.put("body", "javax_faces_location_BODY");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ViewMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -1L;
        private ProjectStage stage;

        ViewMap(ProjectStage stage) {
            this.stage = stage;
        }

        @Override
        public void clear() {
            FacesContext context = FacesContext.getCurrentInstance();
            context.getApplication().publishEvent(ViewMapDestroyedEvent.class, context.getViewRoot());
            super.clear();
        }

        @Override
        public Object put(String key, Object value) {
            if (ProjectStage.Development.equals((Object)this.stage) && !(value instanceof Serializable)) {
                LOGGER.log(Level.WARNING, "warning.component.uiviewroot_non_serializable_attribute_viewmap", new Object[]{key, value.getClass().getName()});
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.put(k, v);
            }
        }
    }
}

