/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialResponseWriter
extends ResponseWriterWrapper {
    private boolean inChanges = false;
    private boolean inInsertBefore = false;
    private boolean inInsertAfter = false;
    ResponseWriter writer;
    public static final String RENDER_ALL_MARKER = "javax.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "javax.faces.ViewState";

    public PartialResponseWriter(ResponseWriter writer) {
        this.writer = writer;
    }

    @Override
    public ResponseWriter getWrapped() {
        return this.writer;
    }

    @Override
    public void startDocument() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        this.writer.startElement("partial-response", null);
    }

    @Override
    public void endDocument() throws IOException {
        this.endChangesIfNecessary();
        this.writer.endElement("partial-response");
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertBefore = true;
        this.writer.startElement("insert", null);
        this.writer.startElement("before", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.startElement("CDATA", null);
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertAfter = true;
        this.writer.startElement("insert", null);
        this.writer.startElement("after", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.startElement("CDATA", null);
    }

    public void endInsert() throws IOException {
        this.writer.endElement("CDATA");
        if (this.inInsertBefore) {
            this.writer.endElement("before");
            this.inInsertBefore = false;
        } else if (this.inInsertAfter) {
            this.writer.endElement("after");
            this.inInsertAfter = false;
        }
        this.writer.endElement("insert");
    }

    public void startUpdate(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("update", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.startElement("CDATA", null);
    }

    public void endUpdate() throws IOException {
        this.writer.endElement("CDATA");
        this.writer.endElement("update");
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("attributes", null);
        this.writer.writeAttribute("id", targetId, null);
        for (String name : attributes.keySet()) {
            this.writer.startElement("attribute", null);
            this.writer.writeAttribute("name", name, null);
            this.writer.writeAttribute("value", attributes.get(name), null);
            this.writer.endElement("attribute");
        }
        this.writer.endElement("attributes");
    }

    public void delete(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("delete", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.endElement("delete");
    }

    public void redirect(String url) throws IOException {
        this.endChangesIfNecessary();
        this.writer.startElement("redirect", null);
        this.writer.writeAttribute("url", url, null);
        this.writer.endElement("redirect");
    }

    public void startEval() throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("eval", null);
        this.writer.startElement("CDATA", null);
    }

    public void endEval() throws IOException {
        this.writer.endElement("CDATA");
        this.writer.endElement("eval");
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.endChangesIfNecessary();
        this.writer.startElement("extension", null);
        if (null != attributes) {
            for (String name : attributes.keySet()) {
                this.writer.writeAttribute(name, attributes.get(name), null);
            }
        }
    }

    public void endExtension() throws IOException {
        this.writer.endElement("extension");
    }

    public void startError(String errorName) throws IOException {
        this.endChangesIfNecessary();
        this.writer.startElement("error", null);
        this.writer.startElement("error-name", null);
        this.writer.write(errorName);
        this.writer.endElement("error-name");
        this.writer.startElement("error-message", null);
        this.writer.startElement("CDATA", null);
    }

    public void endError() throws IOException {
        this.writer.endElement("CDATA");
        this.writer.endElement("error-message");
        this.writer.endElement("error");
    }

    private void startChangesIfNecessary() throws IOException {
        if (!this.inChanges) {
            this.writer.startElement("changes", null);
            this.inChanges = true;
        }
    }

    private void endChangesIfNecessary() throws IOException {
        if (this.inChanges) {
            this.writer.endElement("changes");
            this.inChanges = false;
        }
    }
}

