/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateManagerImpl
extends StateManager {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$faces$application$StateManagerImpl == null ? (class$com$sun$faces$application$StateManagerImpl = StateManagerImpl.class$("com.sun.faces.application.StateManagerImpl")) : class$com$sun$faces$application$StateManagerImpl));
    private static final String NUMBER_OF_VIEWS_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 15;
    private static final String NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION = 15;
    int noOfViews = 0;
    int noOfViewsInLogicalView = 0;
    char requestIdSerial = '\u0000';
    static /* synthetic */ Class class$com$sun$faces$application$StateManagerImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        StateManager.SerializedView result = null;
        Object treeStructure = null;
        Object componentState = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return result;
        }
        this.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Begin creating serialized view for " + viewRoot.getViewId()));
        }
        treeStructure = this.getTreeStructureToSave(context);
        componentState = this.getComponentStateToSave(context);
        result = new StateManager.SerializedView((StateManager)this, treeStructure, componentState);
        Util.doAssert(treeStructure instanceof Serializable);
        Util.doAssert(componentState instanceof Serializable);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End creating serialized view " + viewRoot.getViewId()));
        }
        if (!this.isSavingStateInClient(context)) {
            String id = null;
            String idInActualMap = null;
            String idInLogicalMap = (String)context.getExternalContext().getRequestMap().get("com.sun.faces.logicalViewMap");
            LRUMap logicalMap = null;
            LRUMap actualMap = null;
            int logicalMapSize = this.getNumberOfViewsParameter(context);
            int actualMapSize = this.getNumberOfViewsInLogicalViewParameter(context);
            Object[] stateArray = new Object[]{treeStructure, componentState};
            Map sessionMap = Util.getSessionMap(context);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                logicalMap = (LRUMap)sessionMap.get("com.sun.faces.logicalViewMap");
                if (null == logicalMap) {
                    logicalMap = new LRUMap(logicalMapSize);
                    sessionMap.put("com.sun.faces.logicalViewMap", logicalMap);
                }
                Util.doAssert(null != logicalMap);
                if (null == idInLogicalMap) {
                    idInLogicalMap = this.createUniqueRequestId();
                }
                Util.doAssert(null != idInLogicalMap);
                idInActualMap = this.createUniqueRequestId();
                actualMap = (LRUMap)logicalMap.get((Object)idInLogicalMap);
                if (null == actualMap) {
                    actualMap = new LRUMap(actualMapSize);
                    logicalMap.put((Object)idInLogicalMap, (Object)actualMap);
                }
                id = idInLogicalMap + ':' + idInActualMap;
                result = new StateManager.SerializedView((StateManager)this, (Object)id, null);
                actualMap.put((Object)idInActualMap, (Object)stateArray);
            }
        }
        return result;
    }

    private String createUniqueRequestId() {
        char c = this.requestIdSerial;
        this.requestIdSerial = (char)(c + '\u0001');
        if (c == '\uffff') {
            this.requestIdSerial = '\u0000';
        }
        return "_id" + this.requestIdSerial;
    }

    protected void checkIdUniqueness(FacesContext context, UIComponent component, Set componentIds) throws IllegalStateException {
        String id;
        UIComponent kid;
        Iterator<Object> kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                String messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isErrorEnabled()) {
                    log.error((Object)messageString);
                }
                throw new IllegalStateException(messageString);
            }
            this.checkIdUniqueness(context, kid, componentIds);
        }
        kids = component.getFacets().values().iterator();
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                String messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isErrorEnabled()) {
                    log.error((Object)messageString);
                }
                throw new IllegalStateException(messageString);
            }
            this.checkIdUniqueness(context, kid, componentIds);
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        return context.getViewRoot().processSaveState(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        TreeStructure structRoot = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (!viewRoot.isTransient()) {
            structRoot = new TreeStructure((UIComponent)viewRoot);
            this.buildTreeStructureToSave(context, (UIComponent)viewRoot, structRoot, null);
        }
        return structRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIViewRoot viewRoot = null;
        if (this.isSavingStateInClient(context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Begin restoring view from response " + viewId));
            }
            if ((viewRoot = this.restoreTreeStructure(context, viewId, renderKitId)) != null) {
                this.restoreComponentState(context, viewRoot, renderKitId);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Possibly a new request. Tree structure could not  be restored for " + viewId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("End restoring view from response " + viewId));
            }
        } else {
            Object id = null;
            ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
            id = rsm.getTreeStructureToRestore(context, viewId);
            if (null != id) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Begin restoring view in session for viewId " + viewId));
                }
                String idString = (String)id;
                String idInLogicalMap = null;
                String idInActualMap = null;
                int sep = idString.indexOf(58);
                Util.doAssert(-1 != sep);
                Util.doAssert(sep < idString.length());
                idInLogicalMap = idString.substring(0, sep);
                idInActualMap = idString.substring(sep + 1);
                ExternalContext externalCtx = context.getExternalContext();
                Object sessionObj = externalCtx.getSession(false);
                if (sessionObj == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can't Restore Server View State, session expired for viewId: " + viewId));
                    }
                    return null;
                }
                Map logicalMap = null;
                Map actualMap = null;
                Map sessionMap = externalCtx.getSessionMap();
                TreeStructure structRoot = null;
                Object[] stateArray = null;
                Object object = sessionObj;
                synchronized (object) {
                    logicalMap = (Map)sessionMap.get("com.sun.faces.logicalViewMap");
                    if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                        context.getExternalContext().getRequestMap().put("com.sun.faces.logicalViewMap", idInLogicalMap);
                        stateArray = (Object[])actualMap.get(idInActualMap);
                    }
                }
                if (stateArray == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Session Available, but View State does not exist for viewId: " + viewId));
                    }
                    return null;
                }
                structRoot = (TreeStructure)stateArray[0];
                viewRoot = (UIViewRoot)structRoot.createComponent();
                this.restoreComponentTreeStructure(structRoot, (UIComponent)viewRoot);
                viewRoot.processRestoreState(context, stateArray[1]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("End restoring view in session for viewId " + viewId));
                }
            }
        }
        return viewRoot;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot root, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        Object state = null;
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        state = rsm.getComponentStateToRestore(context);
        root.processRestoreState(context, state);
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIComponent viewRoot = null;
        TreeStructure structRoot = null;
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        structRoot = (TreeStructure)rsm.getTreeStructureToRestore(context, viewId);
        if (structRoot == null) {
            return null;
        }
        viewRoot = structRoot.createComponent();
        this.restoreComponentTreeStructure(structRoot, viewRoot);
        return (UIViewRoot)viewRoot;
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        String renderKitId = context.getViewRoot().getRenderKitId();
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        rsm.writeState(context, state);
    }

    public void buildTreeStructureToSave(FacesContext context, UIComponent component, TreeStructure treeStructure, Set componentIds) {
        String id;
        if (null == componentIds) {
            componentIds = new HashSet<String>();
        }
        Iterator kids = component.getChildren().iterator();
        String messageString = null;
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isErrorEnabled()) {
                    log.error((Object)messageString);
                }
                throw new IllegalStateException(messageString);
            }
            if (kid.isTransient()) continue;
            TreeStructure treeStructureChild = new TreeStructure(kid);
            treeStructure.addChild(treeStructureChild);
            this.buildTreeStructureToSave(context, kid, treeStructureChild, componentIds);
        }
        Iterator facets = component.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            UIComponent facetComponent = (UIComponent)component.getFacets().get(facetName);
            id = facetComponent.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isErrorEnabled()) {
                    log.error((Object)messageString);
                }
                throw new IllegalStateException(messageString);
            }
            if (facetComponent.isTransient()) continue;
            TreeStructure treeStructureFacet = new TreeStructure(facetComponent);
            treeStructure.addFacet(facetName, treeStructureFacet);
            this.buildTreeStructureToSave(context, facetComponent, treeStructureFacet, componentIds);
        }
    }

    public void restoreComponentTreeStructure(TreeStructure treeStructure, UIComponent component) {
        Iterator kids = treeStructure.getChildren();
        while (kids.hasNext()) {
            TreeStructure kid = (TreeStructure)kids.next();
            UIComponent child = kid.createComponent();
            component.getChildren().add(child);
            this.restoreComponentTreeStructure(kid, child);
        }
        Iterator facets = treeStructure.getFacetNames();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            TreeStructure facetTreeStructure = treeStructure.getTreeStructureForFacet(facetName);
            UIComponent facetComponent = facetTreeStructure.createComponent();
            component.getFacets().put(facetName, facetComponent);
            this.restoreComponentTreeStructure(facetTreeStructure, facetComponent);
        }
    }

    protected UIViewRoot restoreSerializedView(FacesContext context, StateManager.SerializedView sv, String viewId) {
        if (sv == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Possibly a new request. Tree structure could not  be restored for " + viewId));
            }
            return null;
        }
        TreeStructure structRoot = (TreeStructure)sv.getStructure();
        if (structRoot == null) {
            return null;
        }
        UIComponent viewRoot = structRoot.createComponent();
        if (viewRoot != null) {
            this.restoreComponentTreeStructure(structRoot, viewRoot);
            Object state = sv.getState();
            viewRoot.processRestoreState(context, state);
        }
        return (UIViewRoot)viewRoot;
    }

    protected int getNumberOfViewsParameter(FacesContext context) {
        block4: {
            if (this.noOfViews != 0) {
                return this.noOfViews;
            }
            this.noOfViews = 15;
            String noOfViewsStr = context.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_SESSION);
            if (noOfViewsStr != null) {
                try {
                    this.noOfViews = Integer.valueOf(noOfViewsStr);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)("Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION. Using default " + this.noOfViews));
                }
            }
        }
        return this.noOfViews;
    }

    protected int getNumberOfViewsInLogicalViewParameter(FacesContext context) {
        block4: {
            if (this.noOfViewsInLogicalView != 0) {
                return this.noOfViewsInLogicalView;
            }
            this.noOfViewsInLogicalView = 15;
            String noOfViewsStr = context.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION);
            if (noOfViewsStr != null) {
                try {
                    this.noOfViewsInLogicalView = Integer.valueOf(noOfViewsStr);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)("Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION. Using default " + this.noOfViewsInLogicalView));
                }
            }
        }
        return this.noOfViewsInLogicalView;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

