/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ArithmeticOperator;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.EqualityOperator;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.PrimitiveObjects;
import com.sun.faces.el.impl.RelationalOperator;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Coercions {
    private static final Number ZERO = new Integer(0);
    private static Log log = LogFactory.getLog((Class)(class$com$sun$faces$el$impl$Coercions == null ? (class$com$sun$faces$el$impl$Coercions = Coercions.class$("com.sun.faces.el.impl.Coercions")) : class$com$sun$faces$el$impl$Coercions));
    static /* synthetic */ Class class$com$sun$faces$el$impl$Coercions;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    private Coercions() {
        throw new IllegalStateException();
    }

    public static Object coerce(Object pValue, Class pClass) throws ElException {
        if (pClass == (class$java$lang$String == null ? (class$java$lang$String = Coercions.class$("java.lang.String")) : class$java$lang$String)) {
            return Coercions.coerceToString(pValue);
        }
        if (Coercions.isNumberClass(pClass)) {
            return Coercions.coerceToPrimitiveNumber(pValue, pClass);
        }
        if (pClass == (class$java$lang$Character == null ? (class$java$lang$Character = Coercions.class$("java.lang.Character")) : class$java$lang$Character) || pClass == Character.TYPE) {
            return Coercions.coerceToCharacter(pValue);
        }
        if (pClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Coercions.class$("java.lang.Boolean")) : class$java$lang$Boolean) || pClass == Boolean.TYPE) {
            return Coercions.coerceToBoolean(pValue);
        }
        return Coercions.coerceToObject(pValue, pClass);
    }

    static boolean isNumberClass(Class pClass) {
        return pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == Byte.TYPE || pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == Short.TYPE || pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == Integer.TYPE || pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pClass == Long.TYPE || pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == Float.TYPE || pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pClass == Double.TYPE || pClass == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger) || pClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    public static String coerceToString(Object pValue) throws ElException {
        if (pValue == null) {
            return "";
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        try {
            return pValue.toString();
        }
        catch (Exception exc) {
            if (log.isErrorEnabled()) {
                String message = MessageUtil.getMessageWithArgs(Constants.TOSTRING_EXCEPTION, pValue.getClass().getName());
                log.error((Object)message, (Throwable)exc);
                throw new ElException(exc);
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object pValue, Class pClass) throws ElException {
        if (pValue == null || "".equals(pValue)) {
            return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue instanceof Character) {
            char val = ((Character)pValue).charValue();
            return Coercions.coerceToPrimitiveNumber(new Short((short)val), pClass);
        }
        if (pValue instanceof Boolean) {
            if (log.isErrorEnabled()) {
                String message = MessageUtil.getMessageWithArgs(Constants.BOOLEAN_TO_NUMBER, pValue, pClass.getName());
                log.error((Object)message);
                throw new ElException(message);
            }
            return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue.getClass() == pClass) {
            return (Number)pValue;
        }
        if (pValue instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)pValue, pClass);
        }
        if (pValue instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)pValue, pClass);
            }
            catch (Exception exc) {
                if (log.isErrorEnabled()) {
                    String message = MessageUtil.getMessageWithArgs(Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, pClass.getName());
                    log.error((Object)message);
                    throw new ElException(message);
                }
                return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
            }
        }
        if (log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), pClass.getName());
            log.error((Object)message);
            throw new ElException(message);
        }
        return Coercions.coerceToPrimitiveNumber(0L, pClass);
    }

    public static Integer coerceToInteger(Object pValue) throws ElException {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)pValue).charValue());
        }
        if (pValue instanceof Boolean) {
            if (log.isWarnEnabled()) {
                log.warn((Object)MessageUtil.getMessageWithArgs(Constants.BOOLEAN_TO_NUMBER, pValue, (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer).getName()));
            }
            return PrimitiveObjects.getInteger((Boolean)pValue != false ? 1 : 0);
        }
        if (pValue instanceof Integer) {
            return (Integer)pValue;
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)pValue).intValue());
        }
        if (pValue instanceof String) {
            try {
                return Integer.valueOf((String)pValue);
            }
            catch (Exception exc) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)MessageUtil.getMessageWithArgs(Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer).getName()));
                }
                return null;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)MessageUtil.getMessageWithArgs(Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer).getName()));
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long pValue, Class pClass) throws ElException {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue);
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue);
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double pValue, Class pClass) throws ElException {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong((long)pValue);
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)pValue);
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number pValue, Class pClass) throws ElException {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte(pValue.byteValue());
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort(pValue.shortValue());
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger(pValue.intValue());
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue.longValue());
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue.floatValue());
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue.doubleValue());
        }
        if (pClass == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            if (pValue instanceof BigDecimal) {
                return ((BigDecimal)pValue).toBigInteger();
            }
            return BigInteger.valueOf(pValue.longValue());
        }
        if (pClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            if (pValue instanceof BigInteger) {
                return new BigDecimal((BigInteger)pValue);
            }
            return new BigDecimal(pValue.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String pValue, Class pClass) throws ElException {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == Byte.TYPE) {
            return Byte.valueOf(pValue);
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == Short.TYPE) {
            return Short.valueOf(pValue);
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == Integer.TYPE) {
            return Integer.valueOf(pValue);
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pClass == Long.TYPE) {
            return Long.valueOf(pValue);
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == Float.TYPE) {
            return Float.valueOf(pValue);
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pClass == Double.TYPE) {
            return Double.valueOf(pValue);
        }
        if (pClass == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(pValue);
        }
        if (pClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object pValue) throws ElException {
        if (pValue == null || "".equals(pValue)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Character) {
            return (Character)pValue;
        }
        if (pValue instanceof Boolean) {
            if (log.isErrorEnabled()) {
                String message = MessageUtil.getMessageWithArgs(Constants.BOOLEAN_TO_CHARACTER, pValue);
                log.error((Object)message);
                throw new ElException(message);
            }
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)pValue).shortValue());
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            return PrimitiveObjects.getCharacter(str.charAt(0));
        }
        if (log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_CHARACTER, pValue.getClass().getName());
            log.error((Object)message);
            throw new ElException(message);
        }
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object pValue) throws ElException {
        if (pValue == null || "".equals(pValue)) {
            return Boolean.FALSE;
        }
        if (pValue instanceof Boolean) {
            return (Boolean)pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            try {
                return Boolean.valueOf(str);
            }
            catch (Exception exc) {
                if (log.isErrorEnabled()) {
                    String message = MessageUtil.getMessageWithArgs(Constants.STRING_TO_BOOLEAN, (String)pValue);
                    log.error((Object)message, (Throwable)exc);
                    throw new ElException(message, exc);
                }
                return Boolean.FALSE;
            }
        }
        if (log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_BOOLEAN, pValue.getClass().getName());
            log.error((Object)message);
            throw new ElException(message);
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object pValue, Class pClass) throws ElException {
        if (pValue == null) {
            return null;
        }
        if (pClass.isAssignableFrom(pValue.getClass())) {
            return pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            PropertyEditor pe = PropertyEditorManager.findEditor(pClass);
            if (pe == null) {
                if ("".equals(str)) {
                    return null;
                }
                if (log.isErrorEnabled()) {
                    String message = MessageUtil.getMessageWithArgs(Constants.NO_PROPERTY_EDITOR, str, pClass.getName());
                    log.error((Object)message);
                    throw new ElException(message);
                }
                return null;
            }
            try {
                pe.setAsText(str);
                return pe.getValue();
            }
            catch (IllegalArgumentException exc) {
                if ("".equals(str)) {
                    return null;
                }
                if (log.isErrorEnabled()) {
                    String message = MessageUtil.getMessageWithArgs(Constants.PROPERTY_EDITOR_ERROR, pValue, pClass.getName());
                    log.error((Object)message, (Throwable)exc);
                    throw new ElException(message, exc);
                }
                return null;
            }
        }
        if (log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_OBJECT, pValue.getClass().getName(), pClass.getName());
            log.error((Object)message);
            throw new ElException(message);
        }
        return null;
    }

    public static Object applyArithmeticOperator(Object pLeft, Object pRight, ArithmeticOperator pOperator) throws ElException {
        if (pLeft == null && pRight == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)MessageUtil.getMessageWithArgs(Constants.ARITH_OP_NULL, pOperator.getOperatorSymbol()));
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            return pOperator.apply(left, right);
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pLeft) || Coercions.isFloatingPointString(pRight)) {
            if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
                BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
                BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
                return pOperator.apply(left, right);
            }
            double left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double).doubleValue();
            return PrimitiveObjects.getDouble(pOperator.apply(left, right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            return pOperator.apply(left, right);
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long).longValue();
        long right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long).longValue();
        return PrimitiveObjects.getLong(pOperator.apply(left, right));
    }

    public static Object applyRelationalOperator(Object pLeft, Object pRight, RelationalOperator pOperator) throws ElException {
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long).longValue();
            long right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft);
            String right = Coercions.coerceToString(pRight);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (pLeft instanceof Comparable) {
            try {
                int result = ((Comparable)pLeft).compareTo(pRight);
                return PrimitiveObjects.getBoolean(pOperator.apply(result, -result));
            }
            catch (Exception exc) {
                if (log.isErrorEnabled()) {
                    String message = MessageUtil.getMessageWithArgs(Constants.COMPARABLE_ERROR, pLeft.getClass().getName(), pRight == null ? "null" : pRight.getClass().getName(), pOperator.getOperatorSymbol());
                    log.error((Object)message, (Throwable)exc);
                    throw new ElException(message, exc);
                }
                return Boolean.FALSE;
            }
        }
        if (pRight instanceof Comparable) {
            try {
                int result = ((Comparable)pRight).compareTo(pLeft);
                return PrimitiveObjects.getBoolean(pOperator.apply(-result, result));
            }
            catch (Exception exc) {
                if (log.isErrorEnabled()) {
                    String message = MessageUtil.getMessageWithArgs(Constants.COMPARABLE_ERROR, pRight.getClass().getName(), pLeft == null ? "null" : pLeft.getClass().getName(), pOperator.getOperatorSymbol());
                    log.error((Object)message, (Throwable)exc);
                    throw new ElException(message, exc);
                }
                return Boolean.FALSE;
            }
        }
        if (log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.ARITH_OP_BAD_TYPE, pOperator.getOperatorSymbol(), pLeft.getClass().getName(), pRight.getClass().getName());
            log.error((Object)message);
            throw new ElException(message);
        }
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object pLeft, Object pRight, EqualityOperator pOperator) throws ElException {
        if (pLeft == pRight) {
            return PrimitiveObjects.getBoolean(pOperator.apply(true));
        }
        if (pLeft == null || pRight == null) {
            return PrimitiveObjects.getBoolean(pOperator.apply(false));
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right)));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left == right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right)));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long).longValue();
            long right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left == right));
        }
        if (pLeft instanceof Boolean || pRight instanceof Boolean) {
            boolean right;
            boolean left = Coercions.coerceToBoolean(pLeft);
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToBoolean(pRight).booleanValue())));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft);
            String right = Coercions.coerceToString(pRight);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right)));
        }
        try {
            return PrimitiveObjects.getBoolean(pOperator.apply(pLeft.equals(pRight)));
        }
        catch (Exception exc) {
            if (log.isErrorEnabled()) {
                String message = MessageUtil.getMessageWithArgs(Constants.ERROR_IN_EQUALS, pLeft.getClass().getName(), pRight.getClass().getName(), pOperator.getOperatorSymbol());
                log.error((Object)message, (Throwable)exc);
                throw new ElException(message, exc);
            }
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object pObject) {
        return pObject != null && Coercions.isFloatingPointType(pObject.getClass());
    }

    public static boolean isFloatingPointType(Class pClass) {
        return pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == Float.TYPE || pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pClass == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object pObject) {
        if (pObject instanceof String) {
            String str = (String)pObject;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch != '.' && ch != 'e' && ch != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object pObject) {
        return pObject != null && Coercions.isIntegerType(pObject.getClass());
    }

    public static boolean isIntegerType(Class pClass) {
        return pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == Byte.TYPE || pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == Short.TYPE || pClass == (class$java$lang$Character == null ? (class$java$lang$Character = Coercions.class$("java.lang.Character")) : class$java$lang$Character) || pClass == Character.TYPE || pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == Integer.TYPE || pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pClass == Long.TYPE;
    }

    public static boolean isBigInteger(Object pObject) {
        return pObject != null && pObject instanceof BigInteger;
    }

    public static boolean isBigDecimal(Object pObject) {
        return pObject != null && pObject instanceof BigDecimal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

