/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.taglib.FacesValidator;
import com.sun.faces.taglib.TagParser;
import com.sun.faces.taglib.ValidatorInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.Attributes;

public class IdTagParserImpl
implements TagParser {
    private boolean siblingSatisfied = true;
    private int requiresIdCount = 0;
    private StringBuffer requiresIdList = new StringBuffer();
    private boolean failed = false;
    private ValidatorInfo validatorInfo;
    private boolean nestedInNamingContainer;

    public void setValidatorInfo(ValidatorInfo validatorInfo) {
        this.validatorInfo = validatorInfo;
    }

    public String getMessage() {
        Object[] obj = new Object[]{this.requiresIdList};
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.faces.resources.Resources");
        return MessageFormat.format(rb.getString("TLV_ID_ERROR"), obj);
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void parseStartElement() {
        String qn = this.validatorInfo.getQName();
        Attributes a = this.validatorInfo.getAttributes();
        FacesValidator validator = this.validatorInfo.getValidator();
        if (this.isJstlTag(validator, qn)) {
            ++this.requiresIdCount;
        } else if (this.isNamingContainerTag(validator, qn)) {
            this.nestedInNamingContainer = true;
        } else if (validator.getJSF_HTML_PRE() != null && qn.startsWith(validator.getJSF_HTML_PRE()) && this.requiresIdCount > 0) {
            if (!this.nestedInNamingContainer && !this.hasIdAttribute(a)) {
                this.failed = true;
                this.requiresIdList.append(qn).append(' ');
            }
        } else if (this.requiresIdCount == 0 && !this.siblingSatisfied) {
            if (validator.getJSF_HTML_PRE() != null && (qn.startsWith(validator.getJSF_HTML_PRE()) || qn.startsWith(validator.getJSF_CORE_PRE())) && !this.hasIdAttribute(a) && !this.nestedInNamingContainer) {
                this.failed = true;
                this.requiresIdList.append(qn).append(' ');
            }
            this.siblingSatisfied = true;
        } else if (this.requiresIdCount == 0) {
            this.siblingSatisfied = true;
        }
    }

    public void parseEndElement() {
        String qn = this.validatorInfo.getQName();
        FacesValidator validator = this.validatorInfo.getValidator();
        if (this.isJstlTag(validator, qn)) {
            --this.requiresIdCount;
            this.siblingSatisfied = false;
        } else if (this.isNamingContainerTag(validator, qn)) {
            this.nestedInNamingContainer = false;
        }
    }

    private boolean hasIdAttribute(Attributes a) {
        for (int i = 0; i < a.getLength(); ++i) {
            if (!a.getQName(i).equals("id")) continue;
            return true;
        }
        return false;
    }

    private boolean isJstlTag(FacesValidator validator, String qn) {
        return qn.equals(validator.getJSTL_IF_QN()) || qn.equals(validator.getJSTL_CHOOSE_QN()) || qn.equals(validator.getJSTL_FOREACH_QN()) || qn.equals(validator.getJSTL_FORTOKENS_QN());
    }

    private boolean isNamingContainerTag(FacesValidator validator, String qn) {
        return qn.equals(validator.getJSF_FORM_QN()) || qn.equals(validator.getJSF_SUBVIEW_QN());
    }
}

