/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.el.ELContextImpl;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

public class FacesContextImpl
extends FacesContext {
    private static final String FACESCONTEXT_IMPL_ATTR_NAME = "com.sun.faces.FacesContextImpl";
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.context");
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private ELContext elContext = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;
    private Map componentMessageLists;
    private boolean renderResponse = false;
    private boolean responseComplete = false;

    public FacesContextImpl() {
    }

    public FacesContextImpl(ExternalContext ec, Lifecycle lifecycle) {
        if (null == ec || null == lifecycle) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.externalContext = ec;
        FacesContextImpl.setCurrentInstance((FacesContext)this);
        this.externalContext.getRequestMap().put(FACESCONTEXT_IMPL_ATTR_NAME, this);
        this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = aFactory.getApplication();
        assert (null != this.application);
        return this.application;
    }

    public ELContext getELContext() {
        this.assertNotReleased();
        if (this.elContext == null) {
            this.elContext = new ELContextImpl(this.getApplication().getELResolver());
            this.elContext.putContext(FacesContext.class, (Object)this);
            UIViewRoot root = this.getViewRoot();
            if (null != root) {
                this.elContext.setLocale(root.getLocale());
            }
        }
        return this.elContext;
    }

    public Iterator getClientIdsWithMessages() {
        this.assertNotReleased();
        Iterator<Object> result = null;
        result = null == this.componentMessageLists ? Collections.EMPTY_LIST.iterator() : this.componentMessageLists.keySet().iterator();
        return result;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        int max = 0;
        FacesMessage.Severity result = null;
        if (null == this.componentMessageLists) {
            return null;
        }
        List messages = this.getMergedMessageLists();
        int size = this.getMergedMessageLists().size();
        for (int i = 0; i < size; ++i) {
            result = ((FacesMessage)messages.get(i)).getSeverity();
            if (result.getOrdinal() > max) {
                max = result.getOrdinal();
            }
            if (result == FacesMessage.SEVERITY_FATAL) break;
        }
        return result;
    }

    public Iterator getMessages() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.EMPTY_LIST.iterator();
        }
        List messages = this.getMergedMessageLists();
        if (messages.size() > 0) {
            return messages.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getMessages(String clientId) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.EMPTY_LIST.iterator();
        }
        List list = (List)this.componentMessageLists.get(clientId);
        if (list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot vr = this.getViewRoot();
        if (vr == null) {
            return null;
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId.equals(this.lastRkId)) {
            return this.lastRk;
        }
        this.lastRk = this.rkFactory.getRenderKit((FacesContext)this, renderKitId);
        this.lastRkId = renderKitId;
        return this.lastRk;
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream newResponseStream) {
        this.assertNotReleased();
        if (newResponseStream == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_STREAM_ERROR", new Object[0]));
        }
        this.responseStream = newResponseStream;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot root) {
        this.assertNotReleased();
        if (root == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.viewRoot = root;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter newResponseWriter) {
        this.assertNotReleased();
        if (newResponseWriter == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_WRITER_ERROR", new Object[0]));
        }
        this.responseWriter = newResponseWriter;
    }

    public void addMessage(String clientId, FacesMessage message) {
        ArrayList<FacesMessage> list;
        this.assertNotReleased();
        if (null == message) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new LinkedHashMap();
        }
        if ((list = (ArrayList<FacesMessage>)this.componentMessageLists.get(clientId)) == null) {
            list = new ArrayList<FacesMessage>();
            this.componentMessageLists.put(clientId, list);
        }
        list.add(message);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding Message[sourceId=" + (clientId != null ? clientId : "<<NONE>>") + ",summary=" + message.getSummary() + ")");
        }
    }

    public void release() {
        this.externalContext.getRequestMap().remove(FACESCONTEXT_IMPL_ATTR_NAME);
        this.released = true;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.viewRoot = null;
        FacesContextImpl.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private List getMergedMessageLists() {
        ArrayList mergedList = new ArrayList();
        if (this.componentMessageLists != null) {
            Iterator i = this.componentMessageLists.values().iterator();
            while (i.hasNext()) {
                Iterator ii = ((ArrayList)i.next()).iterator();
                while (ii.hasNext()) {
                    mergedList.add(ii.next());
                }
            }
        }
        return mergedList;
    }
}

