/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitUtils {
    private static final String PASSTHROUGH_LIST_ATTR = "javax.faces.component.PassThroughAttributes";
    private static final String RENDER_KIT_IMPL_REQ = "com.sun.faces.renderKitImplForRequest";
    private static final String XHTML_ATTR_PREFIX = "xml:";
    private static final String[] EMPTY_EXCLUDES = new String[0];
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled", "ismap", "readonly"};
    private static final String[] PASSTHROUGH_ATTRIBUTES = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rules", "shape", "size", "style", "summary", "tabindex", "target", "title", "usemap", "width"};
    private static final String[] XHTML_PREFIX_ATTRIBUTES;
    private static final int MAX_CONTENT_TYPES = 50;
    private static final int MAX_CONTENT_TYPE_PARTS = 4;
    private static final String CONTENT_TYPE_DELIMITER = ",";
    private static final String CONTENT_TYPE_SUBTYPE_DELIMITER = "/";

    private RenderKitUtils() {
    }

    public static RenderKit getCurrentRenderKit(FacesContext context) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext context, String renderKitId) throws FacesException {
        assert (null != renderKitId);
        assert (null != context);
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            RenderKitFactory factory = (RenderKitFactory)requestMap.get(RENDER_KIT_IMPL_REQ);
            if (factory != null) {
                renderKit = factory.getRenderKit(context, renderKitId);
            } else {
                factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                if (factory == null) {
                    throw new IllegalStateException();
                }
                requestMap.put(RENDER_KIT_IMPL_REQ, factory);
                renderKit = factory.getRenderKit(context, renderKitId);
            }
        }
        return renderKit.getResponseStateManager();
    }

    public static Iterator<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (UIComponent kid : component.getChildren()) {
            if (kid instanceof UISelectItem) {
                UISelectItem item = (UISelectItem)kid;
                Object value = item.getValue();
                if (value == null) {
                    list.add(new SelectItem(item.getItemValue(), item.getItemLabel(), item.getItemDescription(), item.isItemDisabled(), item.isItemEscaped()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.OPTION_NOT_SELECT_ITEM", component.getId(), value.getClass().getName()));
            }
            if (!(kid instanceof UISelectItems)) continue;
            Object value = ((UISelectItems)kid).getValue();
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items;
                for (SelectItem item : items = (SelectItem[])value) {
                    list.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    if (SelectItem.class.isInstance(element)) {
                        list.add((SelectItem)element);
                        continue;
                    }
                    throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.OPTION_NOT_SELECT_ITEM", component.getId(), value.getClass().getName()));
                }
                continue;
            }
            if (value instanceof Map) {
                Map optionMap = (Map)value;
                Iterator i$ = optionMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key == null || val == null) continue;
                    list.add(new SelectItem(val, key.toString()));
                }
                continue;
            }
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CHILD_NOT_OF_EXPECTED_TYPE", "UISelectItem/UISelectItems", component.getFamily(), component.getId()));
        }
        return list.iterator();
    }

    public static boolean hasPassThruAttributes(UIComponent component) {
        Map attrMap = component.getAttributes();
        boolean attrFound = false;
        for (String attr : PASSTHROUGH_ATTRIBUTES) {
            Object value = attrMap.get(attr);
            boolean bl = attrFound = value != null;
            if (attrFound) break;
        }
        return attrFound;
    }

    public static void renderPassThruAttributes(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThruAttributes(context, writer, component, EMPTY_EXCLUDES);
    }

    public static void renderPassThruAttributes(FacesContext context, ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        assert (null != writer);
        assert (null != component);
        if (excludes == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (RenderKitUtils.hasPassThruAttributes(component)) {
            Map attrMap = component.getAttributes();
            if (excludes.length > 0) {
                Arrays.sort(excludes);
            }
            for (String attrName : PASSTHROUGH_ATTRIBUTES) {
                boolean isXhtml;
                Object value;
                if (excludes.length > 0 && Arrays.binarySearch(excludes, attrName) > -1 || (value = attrMap.get(attrName)) == null || !RenderKitUtils.shouldRenderAttribute(value)) continue;
                if (context == null) {
                    context = FacesContext.getCurrentInstance();
                }
                boolean bl = isXhtml = context.getExternalContext().getRequestMap().get("com.sun.faces.ContentTypeIsXHTML") != null;
                if (isXhtml) {
                    String prefixName = attrName;
                    if (Arrays.binarySearch(XHTML_PREFIX_ATTRIBUTES, attrName) > -1) {
                        prefixName = XHTML_ATTR_PREFIX + attrName;
                    }
                    writer.writeAttribute(prefixName, value, attrName);
                    continue;
                }
                writer.writeAttribute(attrName, value, attrName);
            }
        }
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component, EMPTY_EXCLUDES);
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        assert (writer != null);
        assert (component != null);
        if (excludes == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (excludes.length > 0) {
            Arrays.sort(excludes);
        }
        Map attrMap = component.getAttributes();
        for (String attrName : BOOLEAN_ATTRIBUTES) {
            Boolean bool;
            Object val = attrMap.get(attrName);
            if (val == null || excludes.length > 0 && Arrays.binarySearch(excludes, attrName) > -1 || !(bool = !(val instanceof Boolean) ? Boolean.valueOf(val.toString()) : (Boolean)val).booleanValue()) continue;
            writer.writeAttribute(attrName, (Object)true, attrName);
        }
    }

    public static String determineContentType(String accept, String serverSupportedTypes) {
        String[][] serverContentTypes;
        String contentType = null;
        if (null == accept || null == serverSupportedTypes) {
            return contentType;
        }
        String[][] clientContentTypes = RenderKitUtils.buildTypeArrayFromString(accept);
        String[][] matchedInfo = RenderKitUtils.findMatch(clientContentTypes, serverContentTypes = RenderKitUtils.buildTypeArrayFromString(serverSupportedTypes));
        if (matchedInfo[0][1] != null && !matchedInfo[0][2].equals("*")) {
            contentType = matchedInfo[0][1] + CONTENT_TYPE_SUBTYPE_DELIMITER + matchedInfo[0][2];
        }
        return contentType;
    }

    private static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof Boolean && Boolean.FALSE.equals(attributeVal)) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }

    private static String[][] buildTypeArrayFromString(String accept) {
        String[][] arrayAccept = new String[50][4];
        if (accept == null || accept.length() == 0) {
            return arrayAccept;
        }
        String token = null;
        String typeSubType = null;
        String type = null;
        String subtype = null;
        String level = null;
        String quality = null;
        String[] types = accept.split(CONTENT_TYPE_DELIMITER);
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            token = types[i].trim();
            ++index;
            if (token.contains(";")) {
                String[] typeParts = token.split(";");
                typeSubType = typeParts[0].trim();
                for (int j = 1; j < typeParts.length; ++j) {
                    quality = "not set";
                    token = typeParts[j].trim();
                    if (token.contains("level")) {
                        typeSubType = typeSubType + ';' + token;
                        String[] levelParts = token.split("=");
                        level = levelParts[0].trim();
                        if (!level.equalsIgnoreCase("level")) continue;
                        level = levelParts[1].trim();
                        continue;
                    }
                    quality = token;
                    String[] qualityParts = quality.split("=");
                    if ((quality = qualityParts[0].trim()).equalsIgnoreCase("q")) {
                        quality = qualityParts[1].trim();
                        break;
                    }
                    quality = "not set";
                }
            } else {
                typeSubType = token;
                quality = "not set";
            }
            if (typeSubType.contains(CONTENT_TYPE_SUBTYPE_DELIMITER)) {
                String[] typeSubTypeParts = typeSubType.split(CONTENT_TYPE_SUBTYPE_DELIMITER);
                type = typeSubTypeParts[0].trim();
                subtype = typeSubTypeParts[1].trim();
            } else {
                type = typeSubType;
                subtype = "";
            }
            if (quality.equals("not set")) {
                quality = type.equals("*") && subtype.equals("*") ? "0.01" : (!type.equals("*") && subtype.equals("*") ? "0.02" : (type.equals("*") && subtype.length() == 0 ? "0.01" : "1"));
            }
            arrayAccept[index][0] = quality;
            arrayAccept[index][1] = type;
            arrayAccept[index][2] = subtype;
            arrayAccept[index][3] = level;
        }
        return arrayAccept;
    }

    private static String[][] findMatch(String[][] clientContentTypes, String[][] serverSupportedContentTypes) {
        int cidx = 0;
        int sidx = 0;
        String browserType = "";
        String serverType = "";
        String[][] results = new String[50][4];
        int resultidx = -1;
        double highestQFactor = 0.0;
        int idx = 0;
        for (sidx = 0; sidx < 50; ++sidx) {
            serverType = serverSupportedContentTypes[sidx][1];
            if (serverType == null) continue;
            for (cidx = 0; cidx < 50; ++cidx) {
                browserType = clientContentTypes[cidx][1];
                if (browserType == null || !browserType.equalsIgnoreCase(serverType) && !browserType.equals("*") || !clientContentTypes[cidx][2].equalsIgnoreCase(serverSupportedContentTypes[sidx][2]) && !clientContentTypes[cidx][2].equals("*")) continue;
                double cLevel = 0.0;
                double sLevel = 0.0;
                if (clientContentTypes[cidx][3] != null) {
                    cLevel = Double.parseDouble(clientContentTypes[cidx][3]) * 0.1;
                }
                if (serverSupportedContentTypes[sidx][3] != null) {
                    sLevel = Double.parseDouble(serverSupportedContentTypes[sidx][3]) * 0.1;
                }
                double cQfactor = Double.parseDouble(clientContentTypes[cidx][0]) + cLevel;
                double sQfactor = Double.parseDouble(serverSupportedContentTypes[sidx][0]) + sLevel;
                double resultQuality = cQfactor * sQfactor;
                results[++resultidx][0] = String.valueOf(resultQuality);
                if (clientContentTypes[cidx][2].equals("*")) {
                    results[resultidx][1] = clientContentTypes[cidx][1];
                    results[resultidx][2] = clientContentTypes[cidx][2];
                } else {
                    results[resultidx][1] = serverSupportedContentTypes[sidx][1];
                    results[resultidx][2] = serverSupportedContentTypes[sidx][2];
                    results[resultidx][3] = serverSupportedContentTypes[sidx][3];
                }
                if (!(resultQuality > highestQFactor)) continue;
                idx = resultidx;
                highestQFactor = resultQuality;
            }
        }
        String[][] match = new String[1][3];
        match[0][0] = results[idx][0];
        match[0][1] = results[idx][1];
        match[0][2] = results[idx][2];
        return match;
    }

    public static String createValidECMAIdentifier(String origIdentifier) {
        return origIdentifier.replace("-", "$_");
    }

    static {
        Arrays.sort(PASSTHROUGH_ATTRIBUTES);
        XHTML_PREFIX_ATTRIBUTES = new String[]{"lang"};
    }
}

