/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.beans.DescriptionBean;
import com.sun.faces.config.beans.ListEntriesBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.ManagedPropertyBean;
import com.sun.faces.config.beans.MapEntriesBean;
import com.sun.faces.config.beans.MapEntryBean;
import com.sun.faces.el.ELUtils;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.spi.ManagedBeanFactory;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import com.sun.org.apache.commons.beanutils.PropertyUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ReferenceSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanFactoryImpl
extends ManagedBeanFactory {
    private static final byte TYPE_IS_UNKNOWN = -1;
    private static final byte TYPE_IS_LIST = 0;
    private static final byte TYPE_IS_MAP = 1;
    private static final byte TYPE_IS_BEAN = 2;
    private static final byte TYPE_IS_UICOMPONENT = 3;
    private static final byte TYPE_IS_SIMPLE = 3;
    private static final String MANAGED_BEAN_CREATED_STACK = "com.sun.faces.managedBeanStack";
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.config");
    private boolean injectable;
    private ManagedBeanBean managedBean;
    private ManagedBeanFactory.Scope scope = ManagedBeanFactory.Scope.NONE;
    private Map<String, ManagedBeanFactory> managedBeanFactoryMap = null;

    public ManagedBeanFactoryImpl(ManagedBeanBean managedBean) {
        this.managedBean = managedBean;
        this.scope = this.getScopeFromString(managedBean.getManagedBeanScope());
        this.injectable = this.scanForAnnotations();
    }

    @Override
    public boolean isInjectable() {
        return this.injectable;
    }

    private ManagedBeanFactory.Scope getScopeFromString(String scopeString) {
        ManagedBeanFactory.Scope result = ManagedBeanFactory.Scope.NONE;
        if (null != scopeString) {
            if (scopeString.equalsIgnoreCase("request")) {
                result = ManagedBeanFactory.Scope.REQUEST;
            } else if (scopeString.equalsIgnoreCase("session")) {
                result = ManagedBeanFactory.Scope.SESSION;
            } else if (scopeString.equalsIgnoreCase("application")) {
                result = ManagedBeanFactory.Scope.APPLICATION;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManagedBeanBean(ManagedBeanBean newBean) {
        ManagedBeanFactoryImpl managedBeanFactoryImpl = this;
        synchronized (managedBeanFactoryImpl) {
            this.managedBean = newBean;
            this.scope = this.getScopeFromString(this.managedBean.getManagedBeanScope());
        }
    }

    @Override
    public ManagedBeanBean getManagedBeanBean() {
        return this.managedBean;
    }

    @Override
    public Map<String, ManagedBeanFactory> getManagedBeanFactoryMap() {
        if (null == this.managedBeanFactoryMap && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Contract violation: ManagedBeanFactory must be initialized with managedBeanFactoryMap after instantiation.");
        }
        return this.managedBeanFactoryMap;
    }

    @Override
    public void setManagedBeanFactoryMap(Map<String, ManagedBeanFactory> newManagedBeanFactoryMap) {
        this.managedBeanFactoryMap = newManagedBeanFactoryMap;
    }

    public String getBeanDescription(String lang) {
        DescriptionBean db = this.managedBean.getDescription(lang);
        if (db != null) {
            return db.getDescription();
        }
        return null;
    }

    public final Class getManagedBeanClass() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            return loader.loadClass(this.managedBean.getManagedBeanClass());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object newInstance(FacesContext context) throws FacesException {
        Object bean = null;
        int beanType = -1;
        Map requestMap = context.getExternalContext().getRequestMap();
        List<String> beanList = TypedCollections.dynamicallyCastList((List)requestMap.get(MANAGED_BEAN_CREATED_STACK), String.class);
        if (beanList == null) {
            beanList = new ArrayList<String>();
            requestMap.put(MANAGED_BEAN_CREATED_STACK, beanList);
        }
        if (beanList.contains(this.managedBean.getManagedBeanName())) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Possible cyclic reference to managedBean " + this.managedBean.getManagedBeanName() + " ");
            }
            Object[] obj = new Object[]{this.managedBean.getManagedBeanName()};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", obj));
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = FacesContext.getCurrentInstance().getClass().getClassLoader();
            }
            Class<?> mbClass = Class.forName(this.managedBean.getManagedBeanClass(), true, loader);
            bean = mbClass.newInstance();
        }
        catch (Exception ex) {
            Object[] obj = new Object[]{this.managedBean.getManagedBeanClass(), this.managedBean.getManagedBeanName()};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj) + ". " + ex.getMessage(), (Throwable)ex);
        }
        beanList.add(this.managedBean.getManagedBeanName());
        try {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(context.getExternalContext());
            InjectionProvider injectionProvider = associate.getInjectionProvider();
            if (this.injectable) {
                injectionProvider.inject(bean);
            }
            beanType = this.getBeanType(bean);
            switch (beanType) {
                case 0: {
                    this.copyListEntriesFromConfigToList(this.managedBean.getListEntries(), bean);
                    break;
                }
                case 1: {
                    this.copyMapEntriesFromConfigToMap(this.managedBean.getMapEntries(), bean);
                    break;
                }
                case 2: 
                case 3: {
                    this.setPropertiesIntoBean(bean, beanType, this.managedBean);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.injectable) {
                injectionProvider.invokePostConstruct(bean);
            }
        }
        catch (FacesException fe) {
            throw fe;
        }
        catch (ClassNotFoundException cnfe) {
            Object[] obj = new Object[]{this.managedBean.getManagedBeanClass()};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj), (Throwable)cnfe);
        }
        catch (InjectionProviderException ipe) {
            throw new FacesException(ipe.getCause());
        }
        finally {
            beanList.remove(this.managedBean.getManagedBeanName());
        }
        return bean;
    }

    protected int getBeanType(Object bean) {
        int result = -1;
        ListEntriesBean listEntries = this.managedBean.getListEntries();
        MapEntriesBean mapEntries = this.managedBean.getMapEntries();
        ManagedPropertyBean[] managedProperties = this.managedBean.getManagedProperties();
        if (listEntries != null) {
            if (mapEntries != null || managedProperties.length > 0) {
                Object[] obj = new Object[]{this.managedBean.getManagedBeanClass()};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 0;
        }
        if (mapEntries != null) {
            assert (-1 == result);
            if (this.managedBean.getManagedProperties().length > 0) {
                Object[] obj = new Object[]{this.managedBean.getManagedBeanClass()};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 1;
        }
        if (0 != result && 1 != result) {
            assert (-1 == result);
            result = bean instanceof UIComponent ? 3 : 2;
        }
        assert (-1 != result);
        return result;
    }

    protected int getPropertyType(ManagedPropertyBean bean) {
        int result = -1;
        ListEntriesBean listEntries = bean.getListEntries();
        MapEntriesBean mapEntries = bean.getMapEntries();
        if (listEntries != null) {
            if (mapEntries != null || null != bean.getValue() || bean.isNullValue()) {
                Object[] obj = new Object[]{bean.getPropertyName()};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 0;
        }
        if (mapEntries != null) {
            assert (-1 == result);
            if (null != bean.getValue() || bean.isNullValue()) {
                Object[] obj = new Object[]{bean.getPropertyName()};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 1;
        }
        if (0 != result && 1 != result) {
            assert (-1 == result);
            if (null != bean.getValue() || bean.isNullValue()) {
                result = 3;
            }
        }
        if (-1 == result && !bean.isNullValue()) {
            Object[] obj = new Object[]{bean.getPropertyName()};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
        }
        return result;
    }

    protected Class copyListEntriesFromConfigToList(ListEntriesBean listEntries, List<?> valuesForBean) throws ClassNotFoundException {
        String[] valuesFromConfig = listEntries.getValues();
        Class valueClass = String.class;
        Object value = null;
        String strValue = null;
        int len = 0;
        len = valuesFromConfig.length;
        if (0 == len) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("zero length array");
            }
            return null;
        }
        valueClass = this.getValueClassConsideringPrimitives(listEntries.getValueClass());
        for (int i = 0; i < len; ++i) {
            strValue = valuesFromConfig[i];
            value = ManagedBeanFactoryImpl.isVBExpression(strValue) ? this.evaluateValueExpressionGet(strValue) : (null == strValue ? null : strValue);
            value = this.getConvertedValueConsideringPrimitives(value, valueClass);
            TypedCollections.dynamicallyCastList(valuesForBean, valueClass).add(value);
        }
        return valueClass;
    }

    void copyMapEntriesFromConfigToMap(MapEntriesBean mapEntries, Map<?, ?> result) throws ClassNotFoundException {
        Object key = null;
        Object value = null;
        MapEntryBean[] valuesFromConfig = mapEntries.getMapEntries();
        MapEntryBean curEntry2 = null;
        Class keyClass = String.class;
        Class valueClass = String.class;
        String strKey = null;
        String strValue = null;
        if (valuesFromConfig.length == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("null or zero length array");
            }
            return;
        }
        keyClass = this.getValueClassConsideringPrimitives(mapEntries.getKeyClass());
        valueClass = this.getValueClassConsideringPrimitives(mapEntries.getValueClass());
        for (MapEntryBean curEntry2 : valuesFromConfig) {
            strKey = curEntry2.getKey();
            strValue = curEntry2.getValue();
            key = ManagedBeanFactoryImpl.isVBExpression(strKey) ? this.evaluateValueExpressionGet(strKey) : (null == strKey ? null : this.getConvertedValueConsideringPrimitives(strKey, keyClass));
            value = ManagedBeanFactoryImpl.isVBExpression(strValue) ? this.evaluateValueExpressionGet(strValue) : (null == strValue ? null : this.getConvertedValueConsideringPrimitives(strValue, valueClass));
            TypedCollections.dynamicallyCastMap(result, keyClass, valueClass).put(key, value);
        }
    }

    protected void setPropertiesIntoBean(Object bean, int beanType, ManagedBeanBean managedBean) {
        Object value = null;
        String propertyClass = null;
        String propertyName = null;
        String strValue = null;
        Class valueClass = null;
        ManagedPropertyBean[] properties = managedBean.getManagedProperties();
        if (null == properties) {
            return;
        }
        int len = properties.length;
        block8: for (int i = 0; i < len; ++i) {
            if (null == properties[i] || null == (propertyName = properties[i].getPropertyName())) continue;
            try {
                switch (this.getPropertyType(properties[i])) {
                    case 0: {
                        this.setArrayOrListPropertiesIntoBean(bean, properties[i]);
                        break;
                    }
                    case 1: {
                        this.setMapPropertiesIntoBean(bean, properties[i]);
                        break;
                    }
                    case 3: {
                        propertyClass = properties[i].getPropertyClass();
                        if (null == propertyClass) {
                            valueClass = PropertyUtils.getPropertyType(bean, propertyName);
                            if (null == valueClass) {
                                valueClass = String.class;
                            }
                        } else {
                            valueClass = this.getValueClassConsideringPrimitives(propertyClass);
                        }
                        value = ManagedBeanFactoryImpl.isVBExpression(strValue = properties[i].getValue()) ? this.evaluateValueExpressionGet(strValue) : (null == strValue && properties[i].isNullValue() ? null : strValue);
                        value = this.getConvertedValueConsideringPrimitives(value, valueClass);
                        PropertyUtils.setSimpleProperty(bean, propertyName, value);
                        break;
                    }
                    default: {
                        assert (false);
                        continue block8;
                    }
                }
                continue;
            }
            catch (FacesException fe) {
                throw fe;
            }
            catch (Exception ex) {
                if (3 == beanType) {
                    this.setComponentAttribute(bean, propertyName, value);
                    continue;
                }
                Object[] obj = new Object[]{propertyName};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.ERROR_SETTING_BEAN_PROPERTY", obj), (Throwable)ex);
            }
        }
    }

    private void setArrayOrListPropertiesIntoBean(Object bean, ManagedPropertyBean property) throws Exception {
        Object result = null;
        boolean getterIsNull = true;
        boolean getterIsArray = false;
        List valuesForBean = null;
        Class valueType = String.class;
        Class propertyType = null;
        String propertyName = property.getPropertyName();
        try {
            result = PropertyUtils.getProperty(bean, propertyName);
            getterIsNull = null == result;
            propertyType = PropertyUtils.getPropertyType(bean, propertyName);
            getterIsArray = propertyType.isArray();
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        if (!getterIsArray && null != propertyType && !List.class.isAssignableFrom(propertyType)) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CANNOT_SET_LIST_ARRAY_PROPERTY", propertyName, this.managedBean.getManagedBeanName()));
        }
        if (!getterIsNull) {
            if (getterIsArray) {
                ArrayList<Object> existingValuesForBean = new ArrayList<Object>();
                int len = Array.getLength(result);
                for (int i = 0; i < len; ++i) {
                    existingValuesForBean.add(Array.get(result, i));
                }
                valuesForBean = existingValuesForBean;
            } else {
                if (!(result instanceof List)) {
                    throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_EXISTING_VALUE_NOT_LIST", propertyName, this.managedBean.getManagedBeanName()));
                }
                valuesForBean = (List)result;
            }
        } else {
            valuesForBean = new ArrayList();
            result = valuesForBean;
        }
        valueType = this.copyListEntriesFromConfigToList(property.getListEntries(), valuesForBean);
        if (getterIsArray) {
            result = Array.newInstance(valueType, valuesForBean.size());
            int len = valuesForBean.size();
            for (int i = 0; i < len; ++i) {
                if (valueType == Boolean.TYPE) {
                    Array.setBoolean(result, i, (Boolean)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Byte.TYPE) {
                    Array.setByte(result, i, (Byte)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Double.TYPE) {
                    Array.setDouble(result, i, (Double)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Float.TYPE) {
                    Array.setFloat(result, i, ((Float)valuesForBean.get(i)).floatValue());
                    continue;
                }
                if (valueType == Integer.TYPE) {
                    Array.setInt(result, i, (Integer)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Character.TYPE) {
                    Array.setChar(result, i, ((Character)valuesForBean.get(i)).charValue());
                    continue;
                }
                if (valueType == Short.TYPE) {
                    Array.setShort(result, i, (Short)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Long.TYPE) {
                    Array.setLong(result, i, (Long)valuesForBean.get(i));
                    continue;
                }
                Array.set(result, i, valuesForBean.get(i));
            }
        } else {
            result = valuesForBean;
        }
        if (getterIsNull || getterIsArray) {
            PropertyUtils.setProperty(bean, propertyName, result);
        }
    }

    private void setMapPropertiesIntoBean(Object bean, ManagedPropertyBean property) throws Exception {
        HashMap result = null;
        boolean getterIsNull = true;
        Class propertyType = null;
        String propertyName = property.getPropertyName();
        try {
            result = (HashMap)PropertyUtils.getProperty(bean, propertyName);
            getterIsNull = null == result;
            propertyType = PropertyUtils.getPropertyType(bean, propertyName);
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        if (null != propertyType && !Map.class.isAssignableFrom(propertyType)) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CANNOT_SET_MAP_PROPERTY", propertyName, this.managedBean.getManagedBeanName()));
        }
        if (getterIsNull) {
            result = new HashMap();
        }
        this.copyMapEntriesFromConfigToMap(property.getMapEntries(), result);
        if (getterIsNull) {
            PropertyUtils.setProperty(bean, propertyName, result);
        }
    }

    private Class getValueClassConsideringPrimitives(String valueClass) throws ClassNotFoundException {
        Class<Serializable> valueType = String.class;
        if (null != valueClass && 0 < valueClass.length()) {
            valueType = valueClass.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (valueClass.equals(Byte.TYPE.getName()) ? Byte.TYPE : (valueClass.equals(Double.TYPE.getName()) ? Double.TYPE : (valueClass.equals(Float.TYPE.getName()) ? Float.TYPE : (valueClass.equals(Integer.TYPE.getName()) ? Integer.TYPE : (valueClass.equals(Character.TYPE.getName()) ? Character.TYPE : (valueClass.equals(Short.TYPE.getName()) ? Short.TYPE : (valueClass.equals(Long.TYPE.getName()) ? Long.TYPE : Util.loadClass(valueClass, this))))))));
        }
        return valueType;
    }

    private Object getConvertedValueConsideringPrimitives(Object value, Class<?> valueType) throws FacesException {
        if (null != value && null != valueType) {
            String valueString = value.toString();
            if (valueType.isEnum()) {
                value = Enum.valueOf(valueType, valueString);
            } else if (valueType == Boolean.TYPE || valueType == Boolean.class) {
                value = Boolean.valueOf(valueString);
            } else if (valueType == Byte.TYPE || valueType == Byte.class) {
                value = valueString.length() == 0 ? (byte)0 : Byte.valueOf(valueString);
            } else if (valueType == Double.TYPE || valueType == Double.class) {
                value = valueString.length() == 0 ? 0.0 : Double.valueOf(valueString);
            } else if (valueType == Float.TYPE || valueType == Float.class) {
                value = Float.valueOf(valueString.length() == 0 ? 0.0f : Float.valueOf(valueString).floatValue());
            } else if (valueType == Integer.TYPE || valueType == Integer.class) {
                value = valueString.length() == 0 ? 0 : Integer.valueOf(valueString);
            } else if (valueType == Character.TYPE || valueType == Character.class) {
                value = Character.valueOf(valueString.length() == 0 ? (char)'\u0000' : valueString.charAt(0));
            } else if (valueType == Short.TYPE || valueType == Short.class) {
                value = valueString.length() == 0 ? (short)0 : Short.valueOf(valueString);
            } else if (valueType == Long.TYPE || valueType == Long.class) {
                value = valueString.length() == 0 ? 0L : Long.valueOf(valueString);
            } else if (valueType != String.class && !valueType.isAssignableFrom(value.getClass())) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_TYPE_CONVERSION_ERROR", value.toString(), value.getClass(), valueType, this.managedBean.getManagedBeanName()));
            }
        }
        return value;
    }

    @Override
    public ManagedBeanFactory.Scope getScope() {
        return this.scope;
    }

    private Object evaluateValueExpressionGet(String value) throws FacesException {
        Object result = null;
        if (!this.hasValidLifespan(value)) {
            Object[] obj = new Object[]{value};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_SCOPE_LIFESPAN", obj));
        }
        ValueExpression ve = ELUtils.getValueExpression(value);
        if (ve != null) {
            try {
                result = ve.getValue(FacesContext.getCurrentInstance().getELContext());
            }
            catch (PropertyNotFoundException ex) {
                Object[] obj = new Object[]{value};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUEREF_VALUE", obj));
            }
        } else {
            Object[] obj = new Object[]{value};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUE_BINDING", obj));
        }
        return result;
    }

    private boolean hasValidLifespan(String value) throws EvaluationException, ReferenceSyntaxException {
        ManagedBeanFactory.Scope valueScope = null;
        valueScope = ManagedBeanFactoryImpl.isMixedVBExpression(value) ? this.getNarrowestScopeFromExpression(value) : this.getScopeForSingleExpression(value);
        if (this.scope == ManagedBeanFactory.Scope.NONE) {
            return valueScope == ManagedBeanFactory.Scope.NONE;
        }
        if (this.scope == ManagedBeanFactory.Scope.REQUEST) {
            return true;
        }
        if (this.scope == ManagedBeanFactory.Scope.SESSION) {
            return valueScope != ManagedBeanFactory.Scope.REQUEST;
        }
        if (this.scope == ManagedBeanFactory.Scope.APPLICATION) {
            return valueScope != ManagedBeanFactory.Scope.REQUEST && valueScope != ManagedBeanFactory.Scope.SESSION;
        }
        assert (false);
        return false;
    }

    private ManagedBeanFactory.Scope getScopeForSingleExpression(String value) throws ReferenceSyntaxException, EvaluationException {
        String[] firstSegment = new String[1];
        ManagedBeanFactory.Scope valueScope = ELUtils.getScope(value, firstSegment);
        if (null == valueScope) {
            ManagedBeanFactoryImpl otherFactory = null;
            valueScope = null != firstSegment[0] && null != (otherFactory = (ManagedBeanFactoryImpl)this.getManagedBeanFactoryMap().get(firstSegment[0])) ? otherFactory.getScope() : ManagedBeanFactory.Scope.APPLICATION;
        }
        return valueScope;
    }

    private ManagedBeanFactory.Scope getNarrowestScopeFromExpression(String expression) throws ReferenceSyntaxException {
        List expressions = ELUtils.getExpressionsFromString(expression);
        Iterator iter = expressions.iterator();
        int shortestScope = ManagedBeanFactory.Scope.NONE.ordinal();
        int currentScope = ManagedBeanFactory.Scope.NONE.ordinal();
        ManagedBeanFactory.Scope lScope = ManagedBeanFactory.Scope.NONE;
        ManagedBeanFactory.Scope result = ManagedBeanFactory.Scope.NONE;
        while (iter.hasNext()) {
            lScope = this.getScopeForSingleExpression((String)iter.next());
            if (null == lScope || lScope == ManagedBeanFactory.Scope.NONE) continue;
            currentScope = lScope.ordinal();
            if (ManagedBeanFactory.Scope.NONE.ordinal() == shortestScope) {
                shortestScope = currentScope;
                result = lScope;
                continue;
            }
            if (currentScope >= shortestScope) continue;
            shortestScope = currentScope;
            result = lScope;
        }
        return result;
    }

    private boolean scanForAnnotations() {
        Class clazz = this.getManagedBeanClass();
        if (clazz != null) {
            while (clazz != Object.class) {
                Method[] methods;
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (field.getAnnotations().length <= 0) continue;
                    return true;
                }
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (method.getDeclaredAnnotations().length <= 0) continue;
                    return true;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    public void setComponentAttribute(Object component, String propName, Object propValue) {
        ((UIComponent)component).getAttributes().put(propName, propValue);
    }

    public static boolean isVBExpression(String expression) {
        if (null == expression) {
            return false;
        }
        int start = expression.indexOf("#{");
        return expression.indexOf("#{") != -1 && start < expression.indexOf(125);
    }

    public static boolean isMixedVBExpression(String expression) {
        if (null == expression) {
            return false;
        }
        if (!expression.startsWith("#{") || !expression.endsWith("}")) {
            return ManagedBeanFactoryImpl.isVBExpression(expression);
        }
        return false;
    }
}

