/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.FaceletViewHandlingStrategy;
import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagementStrategyImpl
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private final FaceletViewHandlingStrategy pdl;
    private static final String CLIENTIDS_TO_REMOVE_NAME = "com.sun.faces.application.view.CLIENTIDS_TO_REMOVE";
    private static final String CLIENTIDS_TO_ADD_NAME = "com.sun.faces.application.view.CLIENTIDS_TO_ADD";
    private static final String IGNORE_REMOVE_EVENT_NAME = "com.sun.faces.application.view.IGNORE_REMOVE_EVENT";
    private static final String DYNAMIC_COMPONENT = "com.sun.faces.application.view.DYNAMIC_COMPONENT";

    public StateManagementStrategyImpl(FaceletViewHandlingStrategy pdl) {
        this.pdl = pdl;
    }

    public Object saveView(FacesContext context) {
        Map<String, ComponentStruct> addList;
        if (context == null) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        this.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        final HashMap<String, Object> stateMap = new HashMap<String, Object>();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context);
        final FacesContext finalContext = context;
        viewRoot.visitTree(visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                VisitResult result = VisitResult.ACCEPT;
                if (!target.isTransient()) {
                    Object stateObj = target.getAttributes().containsKey(StateManagementStrategyImpl.DYNAMIC_COMPONENT) ? new StateHolderSaver(finalContext, target) : target.saveState(context.getFacesContext());
                    if (null != stateObj) {
                        stateMap.put(target.getClientId(context.getFacesContext()), stateObj);
                    }
                } else {
                    return result;
                }
                return result;
            }
        });
        List<String> removeList = this.getClientIdsToRemove(context);
        if (null != removeList && !removeList.isEmpty()) {
            stateMap.put(CLIENTIDS_TO_REMOVE_NAME, removeList);
        }
        if (null != (addList = this.getClientIdsToAdd(context)) && !addList.isEmpty()) {
            ArrayList<Object> savedAddList = new ArrayList<Object>(addList.size());
            for (ComponentStruct s : addList.values()) {
                savedAddList.add(s.saveState(context));
            }
            stateMap.put(CLIENTIDS_TO_ADD_NAME, savedAddList.toArray());
        }
        return new Object[]{null, stateMap};
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        try {
            viewRoot = this.pdl.getViewMetadata(context, viewId).createMetadataView(context);
            context.setViewRoot(viewRoot);
            context.setProcessingEvents(true);
            this.pdl.buildView(context, viewRoot);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
        Object[] rawState = (Object[])rsm.getState(context, viewId);
        if (rawState == null) {
            return null;
        }
        final Map state = (Map)rawState[1];
        if (null != state) {
            Object[] restoredAddList;
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context);
            viewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    VisitResult result = VisitResult.ACCEPT;
                    Object stateObj = state.get(target.getClientId(context.getFacesContext()));
                    if (stateObj != null && !target.getAttributes().containsKey(StateManagementStrategyImpl.DYNAMIC_COMPONENT)) {
                        target.restoreState(context.getFacesContext(), stateObj);
                    }
                    return result;
                }
            });
            List removeList = (List)state.get(CLIENTIDS_TO_REMOVE_NAME);
            if (null != removeList && !removeList.isEmpty()) {
                for (String cur : removeList) {
                    this.setIgnoreRemoveEvent(context, true);
                    viewRoot.invokeOnComponent(context, cur, new ContextCallback(){

                        public void invokeContextCallback(FacesContext context, UIComponent target) {
                            UIComponent parent = target.getParent();
                            if (null != parent) {
                                parent.getChildren().remove(target);
                            }
                        }
                    });
                    this.setIgnoreRemoveEvent(context, false);
                }
            }
            if (null != (restoredAddList = (Object[])state.get(CLIENTIDS_TO_ADD_NAME)) && 0 < restoredAddList.length) {
                ArrayList<ComponentStruct> addList = new ArrayList<ComponentStruct>(restoredAddList.length);
                for (Object aRestoredAddList : restoredAddList) {
                    ComponentStruct cur = new ComponentStruct();
                    cur.restoreState(context, aRestoredAddList);
                    addList.add(cur);
                }
                Iterator i$ = addList.iterator();
                while (i$.hasNext()) {
                    ComponentStruct cur;
                    final ComponentStruct finalCur = cur = (ComponentStruct)i$.next();
                    viewRoot.invokeOnComponent(context, finalCur.parentClientId, new ContextCallback(){

                        public void invokeContextCallback(FacesContext context, UIComponent parent) {
                            StateHolderSaver saver = (StateHolderSaver)state.get(finalCur.clientId);
                            UIComponent toAdd = (UIComponent)saver.restore(context);
                            int idx = finalCur.indexOfChildInParent;
                            if (idx == -1) {
                                parent.getFacets().put(finalCur.facetName, toAdd);
                            } else {
                                try {
                                    parent.getChildren().add(finalCur.indexOfChildInParent, toAdd);
                                }
                                catch (IndexOutOfBoundsException ioobe) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.log(Level.FINE, "Unable to insert child with client ID {0} into parent with client ID {1} into list at index {2}.", new Object[]{finalCur.clientId, finalCur.parentClientId, finalCur.indexOfChildInParent});
                                    }
                                    parent.getChildren().add(toAdd);
                                }
                            }
                        }
                    });
                }
            }
        } else {
            viewRoot = null;
        }
        context.setProcessingEvents(false);
        return viewRoot;
    }

    public void notifyTrackChanges(UIViewRoot root) {
        AddRemoveListener listener = new AddRemoveListener(this);
        root.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)listener);
        root.subscribeToViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)listener);
    }

    protected void checkIdUniqueness(FacesContext context, UIComponent component, Set<String> componentIds) throws IllegalStateException {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            String id = kid.getClientId(context);
            if (componentIds.add(id)) {
                this.checkIdUniqueness(context, kid, componentIds);
                continue;
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
                FastStringWriter writer = new FastStringWriter(128);
                DebugUtil.simplePrintTree((UIComponent)context.getViewRoot(), id, writer);
                LOGGER.severe(writer.toString());
            }
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id);
            throw new IllegalStateException(message);
        }
    }

    private List<String> getClientIdsToRemove(FacesContext context) {
        return this.getClientIdsToRemove(context, false);
    }

    private List<String> getClientIdsToRemove(FacesContext context, boolean create) {
        ArrayList result = (ArrayList)context.getAttributes().get(CLIENTIDS_TO_REMOVE_NAME);
        if (null == result && create) {
            result = new ArrayList();
            context.getAttributes().put(CLIENTIDS_TO_REMOVE_NAME, result);
        }
        return result;
    }

    private Map<String, ComponentStruct> getClientIdsToAdd(FacesContext context) {
        return this.getClientIdsToAdd(context, false);
    }

    private Map<String, ComponentStruct> getClientIdsToAdd(FacesContext context, boolean create) {
        LinkedHashMap result = (LinkedHashMap)context.getAttributes().get(CLIENTIDS_TO_ADD_NAME);
        if (null == result && create) {
            result = new LinkedHashMap();
            context.getAttributes().put(CLIENTIDS_TO_ADD_NAME, result);
        }
        return result;
    }

    private void handleRemoveEvent(FacesContext context, PreRemoveFromViewEvent event) {
        UIComponent removed = event.getComponent();
        if (removed.isTransient()) {
            return;
        }
        List<String> idsToRemove = this.getClientIdsToRemove(context, true);
        Map<String, ComponentStruct> toAdd = this.getClientIdsToAdd(context, false);
        String clientId = event.getComponent().getClientId(context);
        if (toAdd != null && toAdd.containsKey(clientId)) {
            toAdd.remove(clientId);
        }
        idsToRemove.add(clientId);
    }

    private void handleAddEvent(PostAddToViewEvent event) {
        List<String> toRemove;
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent added = event.getComponent();
        if (added.isTransient()) {
            return;
        }
        Map<String, ComponentStruct> idsToAdd = this.getClientIdsToAdd(context, true);
        ComponentStruct toAdd = new ComponentStruct();
        UIComponent parent = added.getParent();
        toAdd.clientId = added.getClientId(context);
        toAdd.parentClientId = parent.getClientId(context);
        int idx = parent.getChildren().indexOf(added);
        if (idx == -1) {
            for (Map.Entry facet : parent.getFacets().entrySet()) {
                if (facet.getValue() != added) continue;
                toAdd.facetName = (String)facet.getKey();
                break;
            }
        } else {
            toAdd.indexOfChildInParent = parent.getChildren().indexOf(added);
        }
        if ((toRemove = this.getClientIdsToRemove(context, false)) != null && toRemove.contains(toAdd.clientId)) {
            toRemove.remove(toAdd.clientId);
        }
        added.getAttributes().put(DYNAMIC_COMPONENT, Boolean.TRUE);
        idsToAdd.put(toAdd.clientId, toAdd);
    }

    private boolean isIgnoreRemoveEvent(FacesContext context) {
        return context.getAttributes().containsKey(IGNORE_REMOVE_EVENT_NAME);
    }

    private void setIgnoreRemoveEvent(FacesContext context, boolean ignoreRemoveEvent) {
        if (!ignoreRemoveEvent) {
            context.getAttributes().remove(IGNORE_REMOVE_EVENT_NAME);
        } else {
            context.getAttributes().put(IGNORE_REMOVE_EVENT_NAME, Boolean.TRUE);
        }
    }

    public static class AddRemoveListener
    implements SystemEventListener {
        private StateManagementStrategyImpl owner;

        public AddRemoveListener(StateManagementStrategyImpl owner) {
            this.owner = owner;
        }

        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext context = FacesContext.getCurrentInstance();
            if (event instanceof PreRemoveFromViewEvent) {
                if (!this.owner.isIgnoreRemoveEvent(context)) {
                    this.owner.handleRemoveEvent(context, (PreRemoveFromViewEvent)event);
                }
            } else {
                this.owner.handleAddEvent((PostAddToViewEvent)event);
            }
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent;
        }
    }

    private static class ComponentStruct
    implements StateHolder {
        String parentClientId;
        String clientId;
        int indexOfChildInParent = -1;
        String facetName;

        private ComponentStruct() {
        }

        public boolean isTransient() {
            return false;
        }

        public void restoreState(FacesContext ctx, Object state) {
            Object[] s = (Object[])state;
            this.parentClientId = s[0].toString();
            this.clientId = s[1].toString();
            this.indexOfChildInParent = (Integer)s[2];
            this.facetName = (String)s[3];
        }

        public Object saveState(FacesContext arg0) {
            Object[] state = new Object[]{this.parentClientId, this.clientId, this.indexOfChildInParent, this.facetName};
            return state;
        }

        public void setTransient(boolean arg0) {
        }
    }
}

