/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ViewHandlerResponseWrapper;
import com.sun.faces.application.view.MultiViewHandler;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.RequestStateManager;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;

public class JspViewHandlingStrategy
extends ViewHandlingStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public boolean handlesViewId(String viewId) {
        return true;
    }

    public void renderView(FacesContext ctx, MultiViewHandler vh, UIViewRoot viewToRender) throws IOException {
        ViewHandlerResponseWrapper wrapper;
        if (!viewToRender.isRendered()) {
            return;
        }
        ExternalContext extContext = ctx.getExternalContext();
        ServletRequest request = (ServletRequest)extContext.getRequest();
        ServletResponse response = (ServletResponse)extContext.getResponse();
        try {
            if (this.executePageToBuildView(ctx, viewToRender)) {
                response.flushBuffer();
                if (this.associate != null) {
                    this.associate.responseRendered();
                }
                return;
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Completed building view for : \n" + viewToRender.getViewId());
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(ctx, viewToRender.getRenderKitId());
        ResponseWriter oldWriter = ctx.getResponseWriter();
        WriteBehindStateWriter stateWriter = new WriteBehindStateWriter(response.getWriter(), ctx, this.responseBufferSize);
        ResponseWriter newWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)stateWriter) : renderKit.createResponseWriter((Writer)stateWriter, null, request.getCharacterEncoding());
        ctx.setResponseWriter(newWriter);
        newWriter.startDocument();
        this.doRenderView(ctx, viewToRender);
        newWriter.endDocument();
        if (stateWriter.stateWritten()) {
            stateWriter.flushToWriter();
        }
        stateWriter.release();
        if (null != oldWriter) {
            ctx.setResponseWriter(oldWriter);
        }
        if (null != (wrapper = (ViewHandlerResponseWrapper)((Object)RequestStateManager.remove(ctx, "com.sun.faces.AFTER_VIEW_CONTENT")))) {
            wrapper.flushToWriter(response.getWriter(), response.getCharacterEncoding());
        }
        response.flushBuffer();
    }

    private boolean executePageToBuildView(FacesContext context, UIViewRoot viewToExecute) throws IOException {
        if (null == context) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (null == viewToExecute) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "viewToExecute");
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        if ("/*".equals(RequestStateManager.get(context, "com.sun.faces.INVOCATION_PATH"))) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.FACES_SERVLET_MAPPING_INCORRECT", new Object[0]));
        }
        String requestURI = viewToExecute.getViewId();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to execute view " + requestURI);
        }
        if (extContext.getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)extContext.getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Before dispacthMessage to viewId " + requestURI);
        }
        Object originalResponse = extContext.getResponse();
        ViewHandlerResponseWrapper wrapped = JspViewHandlingStrategy.getWrapper(extContext);
        extContext.setResponse((Object)wrapped);
        extContext.dispatch(requestURI);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("After dispacthMessage to viewId " + requestURI);
        }
        extContext.setResponse(originalResponse);
        if (wrapped.getStatus() < 200 || wrapped.getStatus() > 299) {
            wrapped.flushContentToWrappedResponse();
            return true;
        }
        RequestStateManager.set(context, "com.sun.faces.AFTER_VIEW_CONTENT", (Object)wrapped);
        return false;
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        if (null != this.associate) {
            this.associate.responseRendered();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "About to render view " + viewToRender.getViewId());
        }
        viewToRender.encodeAll(context);
    }

    private static ViewHandlerResponseWrapper getWrapper(ExternalContext extContext) {
        Object response = extContext.getResponse();
        if (response instanceof HttpServletResponse) {
            return new ViewHandlerResponseWrapper((HttpServletResponse)response);
        }
        throw new IllegalArgumentException();
    }
}

