/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.FacesContextImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;

public class InjectionFacesContextFactory
extends FacesContextFactory {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private FacesContextFactory delegate;
    private Field defaultFacesContext;
    private Field defaultExternalContext;

    public InjectionFacesContextFactory(FacesContextFactory delegate) {
        Util.notNull("facesContextFactory", delegate);
        this.delegate = delegate;
        try {
            this.defaultFacesContext = FacesContext.class.getDeclaredField("defaultFacesContext");
            this.defaultFacesContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultFacesContext' in javax.faces.context.FacesContext.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultFacesContext = null;
        }
        try {
            this.defaultExternalContext = ExternalContext.class.getDeclaredField("defaultExternalContext");
            this.defaultExternalContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultExternalContext' in javax.faces.context.ExternalContext.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultExternalContext = null;
        }
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        FacesContext ctx = this.delegate.getFacesContext(context, request, response, lifecycle);
        if (ctx == null) {
            String message = MessageFormat.format("Delegate FacesContextFactory, {0}, returned null when calling getFacesContext().", this.delegate.getClass().getName());
            throw new IllegalStateException(message);
        }
        this.injectDefaults(ctx);
        return ctx;
    }

    public FacesContextFactory getWrapped() {
        return this.delegate;
    }

    private void injectDefaults(FacesContext target) {
        block3: {
            FacesContext defaultFC;
            if (this.defaultFacesContext != null && this.defaultExternalContext != null && (defaultFC = FacesContextImpl.getDefaultFacesContext()) != null) {
                try {
                    this.defaultFacesContext.set(target, defaultFC);
                    this.defaultExternalContext.set(target.getExternalContext(), defaultFC.getExternalContext());
                }
                catch (IllegalAccessException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }
}

