/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ClientSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ByteArrayGuard guard;
    private boolean stateTimeoutEnabled;
    private long stateTimeout;
    private int csBuffSize;

    public ClientSideStateHelper() {
        this.init();
    }

    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        if (stateCapture != null) {
            this.doWriteState(state, new StringBuilderWriter(stateCapture));
        } else {
            ResponseWriter writer = ctx.getResponseWriter();
            writer.write(this.stateFieldStart);
            this.doWriteState(state, (Writer)writer);
            writer.write(STATE_FIELD_END);
            this.writeRenderKitIdField(ctx, writer);
        }
    }

    public Object getState(FacesContext ctx, String viewId) throws IOException {
        String stateString = ClientSideStateHelper.getStateParamValue(ctx);
        if (stateString == null) {
            return null;
        }
        return this.doGetState(stateString);
    }

    protected Object doGetState(String stateString) {
        Object[] objectArray;
        ObjectInputStream ois = null;
        try {
            ois = this.initInputStream(stateString);
            long stateTime = 0L;
            if (this.stateTimeoutEnabled) {
                try {
                    stateTime = ois.readLong();
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                    }
                    Object var6_9 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    return var6_9;
                }
            }
            Object structure = ois.readObject();
            Object state = ois.readObject();
            if (stateTime != 0L && this.hasStateExpired(stateTime)) {
                Object var7_12 = null;
                return var7_12;
            }
            objectArray = new Object[]{structure, state};
        }
        catch (OptionalDataException ode) {
            LOGGER.log(Level.SEVERE, ode.getMessage(), ode);
            throw new FacesException((Throwable)ode);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.log(Level.SEVERE, cnfe.getMessage(), cnfe);
            throw new FacesException((Throwable)cnfe);
        }
        catch (IOException iox) {
            LOGGER.log(Level.SEVERE, iox.getMessage(), iox);
            throw new FacesException((Throwable)iox);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ioe) {}
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteState(Object state, Writer writer) throws IOException {
        Object[] stateToWrite = (Object[])state;
        ObjectOutputStream oos = null;
        try {
            Base64OutputStreamWriter bos = new Base64OutputStreamWriter(this.csBuffSize, writer);
            oos = this.initOutputStream(bos);
            if (this.stateTimeoutEnabled) {
                oos.writeLong(System.currentTimeMillis());
            }
            oos.writeObject(stateToWrite[0]);
            oos.writeObject(stateToWrite[1]);
            oos.flush();
            oos.close();
            bos.finish();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Client State: total number of characters written: {0}", bos.getTotalCharsWritten());
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private ObjectInputStream initInputStream(String stateString) throws IOException {
        InputStream bis = this.compressViewState ? new GZIPInputStream(new Base64InputStream(stateString)) : new Base64InputStream(stateString);
        ObjectInputStream ois = this.guard != null ? this.serialProvider.createObjectInputStream(new CipherInputStream(bis, this.guard.getDecryptionCipher())) : this.serialProvider.createObjectInputStream(bis);
        return ois;
    }

    protected ObjectOutputStream initOutputStream(Base64OutputStreamWriter bos) throws IOException {
        OutputStream base = this.compressViewState ? new GZIPOutputStream((OutputStream)bos, 1024) : bos;
        ObjectOutputStream oos = this.guard != null ? this.serialProvider.createObjectOutputStream(new BufferedOutputStream(new CipherOutputStream(base, this.guard.getEncryptionCipher()))) : this.serialProvider.createObjectOutputStream(new BufferedOutputStream(base, 1024));
        return oos;
    }

    protected boolean hasStateExpired(long stateTime) {
        if (this.stateTimeoutEnabled) {
            long elapsed = (System.currentTimeMillis() - stateTime) / 60000L;
            return elapsed > this.stateTimeout;
        }
        return false;
    }

    protected void init() {
        String pass = this.webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ClientStateSavingPassword);
        if (pass != null) {
            this.guard = new ByteArrayGuard(pass);
        }
        this.stateTimeoutEnabled = this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
        if (this.stateTimeoutEnabled) {
            String timeout = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
            try {
                this.stateTimeout = Long.parseLong(timeout);
            }
            catch (NumberFormatException nfe) {
                this.stateTimeout = Long.parseLong(WebConfiguration.WebContextInitParameter.ClientStateTimeout.getDefaultValue());
            }
        }
        String size = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String defaultSize = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(size);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
                }
                this.csBuffSize = Integer.parseInt(defaultSize);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
            }
            this.csBuffSize = Integer.parseInt(defaultSize);
        }
    }

    protected static final class StringBuilderWriter
    extends Writer {
        private StringBuilder sb;

        protected StringBuilderWriter(StringBuilder sb) {
            this.sb = sb;
        }

        public void write(int c) throws IOException {
            this.sb.append(c);
        }

        public void write(char[] cbuf) throws IOException {
            this.sb.append(cbuf);
        }

        public void write(String str) throws IOException {
            this.sb.append(str);
        }

        public void write(String str, int off, int len) throws IOException {
            this.sb.append(str.toCharArray(), off, len);
        }

        public Writer append(CharSequence csq) throws IOException {
            this.sb.append(csq);
            return this;
        }

        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.sb.append(csq, start, end);
            return this;
        }

        public Writer append(char c) throws IOException {
            this.sb.append(c);
            return this;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

