/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.SelectItemsIterator;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.AjaxBehavior;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitUtils {
    private static final String XHTML_ATTR_PREFIX = "xml:";
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled", "ismap", "readonly"};
    private static final String[] XHTML_PREFIX_ATTRIBUTES = new String[]{"lang"};
    private static final int MAX_CONTENT_TYPES = 50;
    private static final int MAX_CONTENT_TYPE_PARTS = 4;
    private static final String CONTENT_TYPE_DELIMITER = ",";
    private static final String CONTENT_TYPE_SUBTYPE_DELIMITER = "/";
    private static final String SUN_JSF_JS = "com.sun.faces.sunJsfJs";
    private static final String OPTIMIZED_PACKAGE = "javax.faces.component.";
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
    protected static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final HtmlBasicRenderer.Param[] EMPTY_PARAMS = new HtmlBasicRenderer.Param[0];

    private RenderKitUtils() {
    }

    public static RenderKit getCurrentRenderKit(FacesContext context) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext context, String renderKitId) throws FacesException {
        assert (null != renderKitId);
        assert (null != context);
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            RenderKitFactory factory = (RenderKitFactory)RequestStateManager.get(context, "com.sun.faces.renderKitImplForRequest");
            if (factory != null) {
                renderKit = factory.getRenderKit(context, renderKitId);
            } else {
                factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                if (factory == null) {
                    throw new IllegalStateException();
                }
                RequestStateManager.set(context, "com.sun.faces.renderKitImplForRequest", factory);
                renderKit = factory.getRenderKit(context, renderKitId);
            }
        }
        return renderKit.getResponseStateManager();
    }

    public static Iterator<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        Util.notNull("context", context);
        Util.notNull("component", component);
        return new SelectItemsIterator(context, component);
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        assert (null != writer);
        assert (null != component);
        Map attrMap = component.getAttributes();
        if (RenderKitUtils.canBeOptimized(component)) {
            List setAttributes = (List)component.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
            if (setAttributes != null) {
                RenderKitUtils.renderPassThruAttributesOptimized(writer, component, attributes, setAttributes);
            }
        } else {
            boolean isXhtml = "application/xhtml+xml".equals(writer.getContentType());
            for (String attrName : attributes) {
                Object value = attrMap.get(attrName);
                if (value == null || !RenderKitUtils.shouldRenderAttribute(value)) continue;
                writer.writeAttribute(RenderKitUtils.prefixAttribute(attrName, isXhtml), value, attrName);
            }
        }
    }

    public static String buildAjaxCommand(FacesContext context, UIComponent component, AjaxBehavior ajaxBehavior) {
        UIComponent resolvedComponent;
        boolean first;
        String AJAX_REQUEST = "jsf.ajax.request";
        boolean already = false;
        StringBuilder ajaxCommand = new StringBuilder(256);
        Collection execute = ajaxBehavior.getExecute(context);
        Collection render = ajaxBehavior.getRender(context);
        String onevent = ajaxBehavior.getOnEvent(context);
        String onerror = ajaxBehavior.getOnError(context);
        ajaxCommand.append("jsf.ajax.request");
        ajaxCommand.append("(this, event");
        if (execute != null || render != null) {
            ajaxCommand.append(", {");
        }
        if (execute != null) {
            already = true;
            first = true;
            ajaxCommand.append("execute:'");
            for (String exe : execute) {
                if (!first) {
                    ajaxCommand.append(' ');
                } else {
                    first = false;
                }
                resolvedComponent = RenderKitUtils.findComponent(component, exe);
                if (resolvedComponent == null) {
                    throw new FacesException("'execute' attribute contains unknown id '" + exe + "'");
                }
                ajaxCommand.append(resolvedComponent.getClientId());
            }
            ajaxCommand.append('\'');
        }
        if (render != null) {
            if (already) {
                ajaxCommand.append(',');
            } else {
                already = true;
            }
            first = true;
            ajaxCommand.append("render:'");
            for (String rend : render) {
                if (!first) {
                    ajaxCommand.append(' ');
                } else {
                    first = false;
                }
                resolvedComponent = RenderKitUtils.findComponent(component, rend);
                if (resolvedComponent == null) {
                    throw new FacesException("'render' attribute contains unknown id '" + rend + "'");
                }
                ajaxCommand.append(resolvedComponent.getClientId());
            }
            ajaxCommand.append('\'');
        }
        if (onevent != null) {
            if (already) {
                ajaxCommand.append(',');
            } else {
                already = true;
            }
            ajaxCommand.append("onevent:");
            ajaxCommand.append(onevent);
        }
        if (onerror != null) {
            if (already) {
                ajaxCommand.append(',');
            } else {
                already = true;
            }
            ajaxCommand.append("onerror:");
            ajaxCommand.append(onerror);
        }
        if (already) {
            ajaxCommand.append('}');
        }
        ajaxCommand.append(");");
        return ajaxCommand.toString();
    }

    public static void renderOnchange(FacesContext context, UIComponent component) throws IOException {
        boolean isCommand = false;
        String event = "onchange";
        boolean userSpecifiedOnchange = false;
        boolean renderAjax = false;
        String ajaxCommand = "";
        ResponseWriter writer = context.getResponseWriter();
        String userOnchange = (String)component.getAttributes().get("onchange");
        userSpecifiedOnchange = userOnchange != null && !"".equals(userOnchange);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)component.getAttributes().get("javax.faces.component.AjaxBehavior");
        boolean bl = renderAjax = ajaxBehavior != null && ajaxBehavior.isDisabled(context) == false;
        if (!userSpecifiedOnchange && !renderAjax) {
            return;
        }
        if (renderAjax) {
            ajaxCommand = RenderKitUtils.buildAjaxCommand(context, component, ajaxBehavior);
        }
        StringBuffer sb = new StringBuffer(256);
        if (userSpecifiedOnchange && renderAjax) {
            sb.append("var a=function(event){");
            userOnchange = userOnchange.trim();
            sb.append(userOnchange);
            if (userOnchange.charAt(userOnchange.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append("};var b=function(event){");
            sb.append(ajaxCommand);
            sb.append("};return mojarra.jsfcbk(a,this,event) ? mojarra.jsfcbk(b,this,event) : false;");
        } else if (userSpecifiedOnchange) {
            sb.append(userOnchange);
        } else if (renderAjax) {
            sb.append(ajaxCommand);
        }
        if (userSpecifiedOnchange || renderAjax) {
            writer.writeAttribute("onchange", (Object)sb.toString(), "onchange");
        }
    }

    public static void renderOnclick(FacesContext context, UIComponent component, HtmlBasicRenderer.Param[] params, AjaxBehavior ajaxBehavior) throws IOException {
        boolean isCommand = true;
        String event = "onclick";
        boolean userSpecifiedOnclick = false;
        boolean renderAjax = ajaxBehavior != null && ajaxBehavior.isDisabled(context) == false;
        boolean renderParams = !Arrays.equals(params, EMPTY_PARAMS);
        String ajaxCommand = "";
        String formClientId = "";
        String componentClientId = "";
        if (renderParams) {
            formClientId = RenderKitUtils.getFormClientId(component, context);
            componentClientId = component.getClientId(context);
        }
        ResponseWriter writer = context.getResponseWriter();
        String userOnclick = (String)component.getAttributes().get("onclick");
        boolean bl = userSpecifiedOnclick = userOnclick != null && !"".equals(userOnclick);
        if (userSpecifiedOnclick) {
            userOnclick = userOnclick.trim();
        }
        if (!(userSpecifiedOnclick || renderAjax || renderParams)) {
            return;
        }
        if (renderAjax) {
            ajaxCommand = RenderKitUtils.buildAjaxCommand(context, component, ajaxBehavior);
        }
        StringBuffer sb = new StringBuffer(256);
        if (userSpecifiedOnclick && renderAjax && renderParams) {
            sb.append("var a=function(event){");
            sb.append(userOnclick);
            if (userOnclick.charAt(userOnclick.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append("};var b=function(event){");
            sb.append(ajaxCommand);
            sb.append("};if (mojarra.jsfcbk(a,this,event)===false) { return false;}else{");
            sb.append("mojarra.apf(document.getElementById('");
            sb.append(formClientId);
            sb.append("'),");
            sb.append(RenderKitUtils.renderParams(componentClientId, params));
            sb.append(");mojarra.jsfcbk(b,this,event); mojarra.dpf(document.getElementById('");
            sb.append(formClientId);
            sb.append("'));return false}");
        } else if (userSpecifiedOnclick && renderAjax) {
            sb.append("var a=function(event){");
            sb.append(userOnclick);
            if (userOnclick.charAt(userOnclick.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append("};var b=function(event){");
            sb.append(ajaxCommand);
            sb.append("return false;");
            sb.append("};return (mojarra.jsfcbk(a,this,event)===false) ? false : mojarra.jsfcbk(b,this,event);");
        } else if (userSpecifiedOnclick && renderParams) {
            sb.append("var a=function(event){");
            sb.append(userOnclick);
            if (userOnclick.charAt(userOnclick.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append("};var b=function(event){");
            sb.append(RenderKitUtils.getCommandOnClickScript(formClientId, componentClientId, "", params, renderAjax));
            sb.append("};return (mojarra.jsfcbk(a,this,event)===false) ? false : mojarra.jsfcbk(b,this,event);");
        } else if (renderAjax && renderParams) {
            sb.append("var a=function(event){");
            sb.append(ajaxCommand);
            sb.append("};mojarra.apf(document.getElementById('");
            sb.append(formClientId);
            sb.append("'),");
            sb.append(RenderKitUtils.renderParams(componentClientId, params));
            sb.append(");mojarra.jsfcbk(a,this,event); mojarra.dpf(document.getElementById('");
            sb.append(formClientId);
            sb.append("')); return false;");
        } else if (userSpecifiedOnclick) {
            sb.append(userOnclick);
            if (userOnclick.charAt(userOnclick.length() - 1) != ';') {
                sb.append(';');
            }
        } else if (renderAjax) {
            sb.append(ajaxCommand);
            sb.append("return false;");
        } else if (renderParams) {
            sb.append(RenderKitUtils.getCommandOnClickScript(formClientId, componentClientId, "", params, renderAjax));
        }
        if (userSpecifiedOnclick || renderAjax || renderParams) {
            writer.writeAttribute("onclick", (Object)sb.toString(), "onclick");
        }
    }

    public static String prefixAttribute(String attrName, ResponseWriter writer) {
        return RenderKitUtils.prefixAttribute(attrName, "application/xhtml+xml".equals(writer.getContentType()));
    }

    public static String prefixAttribute(String attrName, boolean isXhtml) {
        if (isXhtml) {
            if (Arrays.binarySearch(XHTML_PREFIX_ATTRIBUTES, attrName) > -1) {
                return XHTML_ATTR_PREFIX + attrName;
            }
            return attrName;
        }
        return attrName;
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        assert (writer != null);
        assert (component != null);
        Map attrMap = component.getAttributes();
        for (String attrName : BOOLEAN_ATTRIBUTES) {
            Object val = attrMap.get(attrName);
            if (val == null || !Boolean.valueOf(val.toString()).booleanValue()) continue;
            writer.writeAttribute(attrName, (Object)true, attrName);
        }
    }

    public static String determineContentType(String accept, String serverSupportedTypes, String preferredType) {
        String[][] preferredContentType;
        String[][] serverContentTypes;
        String contentType = null;
        if (null == accept || null == serverSupportedTypes) {
            return contentType;
        }
        String[][] clientContentTypes = RenderKitUtils.buildTypeArrayFromString(accept);
        String[][] matchedInfo = RenderKitUtils.findMatch(clientContentTypes, serverContentTypes = RenderKitUtils.buildTypeArrayFromString(serverSupportedTypes), preferredContentType = RenderKitUtils.buildTypeArrayFromString(preferredType));
        if (matchedInfo[0][1] != null && !matchedInfo[0][2].equals("*")) {
            contentType = matchedInfo[0][1] + CONTENT_TYPE_SUBTYPE_DELIMITER + matchedInfo[0][2];
        }
        return contentType;
    }

    public static boolean isXml(String contentType) {
        return "application/xhtml+xml".equals(contentType) || "application/xml".equals(contentType) || "text/xml".equals(contentType);
    }

    private static UIComponent findComponent(UIComponent component, String exe) {
        UIComponent resolvedComponent = component.findComponent(exe);
        if (resolvedComponent == null) {
            resolvedComponent = component.findComponent(':' + exe);
        }
        return resolvedComponent;
    }

    private static boolean canBeOptimized(UIComponent component) {
        String name = component.getClass().getName();
        return name != null && name.startsWith(OPTIMIZED_PACKAGE);
    }

    private static void renderPassThruAttributesOptimized(ResponseWriter writer, UIComponent component, String[] knownAttributes, List<String> setAttributes) throws IOException {
        Object[] attributes = setAttributes.toArray(new String[setAttributes.size()]);
        Arrays.sort(attributes);
        boolean isXhtml = "application/xhtml+xml".equals(writer.getContentType());
        Map attrMap = component.getAttributes();
        for (Object name : attributes) {
            Object value;
            if (Arrays.binarySearch(knownAttributes, name) < 0 || (value = attrMap.get(name)) == null || !RenderKitUtils.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(RenderKitUtils.prefixAttribute((String)name, isXhtml), value, (String)name);
        }
    }

    private static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof String) {
            return true;
        }
        if (attributeVal instanceof Boolean && Boolean.FALSE.equals(attributeVal)) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }

    private static String[][] buildTypeArrayFromString(String accept) {
        String[][] arrayAccept = new String[50][4];
        if (accept == null || accept.length() == 0) {
            return arrayAccept;
        }
        String level = null;
        String quality = null;
        String[] types = Util.split(accept, CONTENT_TYPE_DELIMITER);
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            String subtype;
            String type;
            StringBuilder typeSubType;
            String token = types[i].trim();
            ++index;
            if (token.contains(";")) {
                String[] typeParts = Util.split(token, ";");
                typeSubType = new StringBuilder(typeParts[0].trim());
                for (int j = 1; j < typeParts.length; ++j) {
                    quality = "not set";
                    token = typeParts[j].trim();
                    if (token.contains("level")) {
                        typeSubType.append(';').append(token);
                        String[] levelParts = Util.split(token, "=");
                        level = levelParts[0].trim();
                        if (!level.equalsIgnoreCase("level")) continue;
                        level = levelParts[1].trim();
                        continue;
                    }
                    quality = token;
                    String[] qualityParts = Util.split(quality, "=");
                    if ((quality = qualityParts[0].trim()).equalsIgnoreCase("q")) {
                        quality = qualityParts[1].trim();
                        break;
                    }
                    quality = "not set";
                }
            } else {
                typeSubType = new StringBuilder(token);
                quality = "not set";
            }
            if (typeSubType.indexOf(CONTENT_TYPE_SUBTYPE_DELIMITER) >= 0) {
                String[] typeSubTypeParts = Util.split(typeSubType.toString(), CONTENT_TYPE_SUBTYPE_DELIMITER);
                if (typeSubTypeParts.length == 1) {
                    type = typeSubTypeParts[0].trim();
                    subtype = "*";
                } else {
                    type = typeSubTypeParts[0].trim();
                    subtype = typeSubTypeParts[1].trim();
                }
            } else {
                type = typeSubType.toString();
                subtype = "";
            }
            if ("not set".equals(quality)) {
                quality = type.equals("*") && subtype.equals("*") ? "0.01" : (!type.equals("*") && subtype.equals("*") ? "0.02" : (type.equals("*") && subtype.length() == 0 ? "0.01" : "1"));
            }
            arrayAccept[index][0] = quality;
            arrayAccept[index][1] = type;
            arrayAccept[index][2] = subtype;
            arrayAccept[index][3] = level;
        }
        return arrayAccept;
    }

    private static String[][] findMatch(String[][] clientContentTypes, String[][] serverSupportedContentTypes, String[][] preferredContentType) {
        String[][] results = new String[50][4];
        int resultidx = -1;
        double highestQFactor = 0.0;
        int idx = 0;
        for (int sidx = 0; sidx < 50; ++sidx) {
            String serverType = serverSupportedContentTypes[sidx][1];
            if (serverType == null) continue;
            for (int cidx = 0; cidx < 50; ++cidx) {
                String browserType = clientContentTypes[cidx][1];
                if (browserType == null || !browserType.equalsIgnoreCase(serverType) && !browserType.equals("*") || !clientContentTypes[cidx][2].equalsIgnoreCase(serverSupportedContentTypes[sidx][2]) && !clientContentTypes[cidx][2].equals("*")) continue;
                double cLevel = 0.0;
                double sLevel = 0.0;
                if (clientContentTypes[cidx][3] != null) {
                    cLevel = Double.parseDouble(clientContentTypes[cidx][3]) * 0.1;
                }
                if (serverSupportedContentTypes[sidx][3] != null) {
                    sLevel = Double.parseDouble(serverSupportedContentTypes[sidx][3]) * 0.1;
                }
                double cQfactor = Double.parseDouble(clientContentTypes[cidx][0]) + cLevel;
                double sQfactor = Double.parseDouble(serverSupportedContentTypes[sidx][0]) + sLevel;
                double resultQuality = cQfactor * sQfactor;
                results[++resultidx][0] = String.valueOf(resultQuality);
                if (clientContentTypes[cidx][2].equals("*")) {
                    results[resultidx][1] = clientContentTypes[cidx][1];
                    results[resultidx][2] = clientContentTypes[cidx][2];
                } else {
                    results[resultidx][1] = serverSupportedContentTypes[sidx][1];
                    results[resultidx][2] = serverSupportedContentTypes[sidx][2];
                    results[resultidx][3] = serverSupportedContentTypes[sidx][3];
                }
                if (!(resultQuality > highestQFactor)) continue;
                idx = resultidx;
                highestQFactor = resultQuality;
            }
        }
        String[][] match = new String[1][3];
        if (preferredContentType[0][0] != null) {
            BigDecimal highestQual = BigDecimal.valueOf(highestQFactor);
            for (int i = 0; i <= resultidx; ++i) {
                if (BigDecimal.valueOf(Double.parseDouble(results[i][0])).compareTo(highestQual) != 0 || !results[i][1].equals(preferredContentType[0][1]) || !results[i][2].equals(preferredContentType[0][2])) continue;
                match[0][0] = results[i][0];
                match[0][1] = results[i][1];
                match[0][2] = results[i][2];
                return match;
            }
        }
        match[0][0] = results[idx][0];
        match[0][1] = results[idx][1];
        match[0][2] = results[idx][2];
        return match;
    }

    public static String createValidECMAIdentifier(String origIdentifier) {
        return origIdentifier.replace("-", "$_");
    }

    public static void renderJsfJs(FacesContext context) throws IOException {
        String rlibrary;
        String rname;
        UIComponent resource;
        String name = "jsf.js";
        String library = "javax.faces";
        if (context.getAttributes().get("com.sun.faces.jsfjsState") != null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "head").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        iter = viewRoot.getComponentResources(context, "body").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        iter = viewRoot.getComponentResources(context, "form").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        ResourceHandler handler = context.getApplication().getResourceHandler();
        Resource resource2 = handler.createResource("jsf.js", "javax.faces");
        writer.write(10);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)(resource2 != null ? resource2.getRequestPath() : ""), null);
        writer.endElement("script");
        writer.append('\r');
        writer.append('\n');
        context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
    }

    public static String getCommandOnClickScript(String formClientId, String commandClientId, String target, HtmlBasicRenderer.Param[] params, boolean isAjax) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("mojarra.jsfcljs(document.getElementById('");
        sb.append(formClientId);
        sb.append("'),");
        sb.append(RenderKitUtils.renderParams(commandClientId, params));
        sb.append(",'");
        sb.append(target);
        sb.append("');return false");
        return sb.toString();
    }

    private static String renderParams(String commandClientId, HtmlBasicRenderer.Param[] params) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{'");
        sb.append(commandClientId).append("':'").append(commandClientId);
        for (HtmlBasicRenderer.Param param : params) {
            String pn = param.name;
            if (pn == null || pn.length() == 0) continue;
            String pv = param.value;
            sb.append("','");
            sb.append(pn.replace("'", "\\'"));
            sb.append("':'");
            if (pv == null || pv.length() == 0) continue;
            sb.append(pv.replace("'", "\\'"));
        }
        sb.append("'}");
        return sb.toString();
    }

    public static char[] compressJS(String JSString) {
        BufferedReader reader = new BufferedReader(new StringReader(JSString));
        StringWriter writer = new StringWriter(1024);
        try {
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                writer.write(line);
                line = reader.readLine();
            }
            return writer.toString().toCharArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void writeSunJS(FacesContext context, Writer writer) throws IOException {
        writer.write((char[])context.getExternalContext().getApplicationMap().get(SUN_JSF_JS));
    }

    public static void renderUnhandledMessages(FacesContext ctx) {
        Application app = ctx.getApplication();
        if (ProjectStage.Development.equals((Object)app.getProjectStage())) {
            HtmlMessages messages = (HtmlMessages)app.createComponent("javax.faces.HtmlMessages");
            Renderer messagesRenderer = ctx.getRenderKit().getRenderer("javax.faces.Messages", "javax.faces.Messages");
            messages.setErrorStyle("Color: red");
            messages.setWarnStyle("Color: orange");
            messages.setInfoStyle("Color: blue");
            messages.setFatalStyle("Color: red");
            messages.setTooltip(true);
            messages.setTitle("Project Stage[Development]: Unhandled Messages");
            messages.setRedisplay(false);
            try {
                messagesRenderer.encodeBegin(ctx, (UIComponent)messages);
                messagesRenderer.encodeEnd(ctx, (UIComponent)messages);
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        } else {
            Iterator clientIds = ctx.getClientIdsWithMessages();
            if (clientIds.hasNext()) {
                StringBuilder builder = new StringBuilder();
                while (clientIds.hasNext()) {
                    String clientId = (String)clientIds.next();
                    Iterator messages = ctx.getMessages(clientId);
                    while (messages.hasNext()) {
                        FacesMessage message = (FacesMessage)messages.next();
                        if (message.isRendered()) continue;
                        builder.append("\n");
                        builder.append("sourceId=").append(clientId);
                        builder.append("[severity=(").append(message.getSeverity());
                        builder.append("), summary=(").append(message.getSummary());
                        builder.append("), detail=(").append(message.getDetail()).append(")]");
                    }
                }
                LOGGER.log(Level.INFO, "jsf.non_displayed_message", builder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadSunJsfJs(ExternalContext extContext) {
        Map appMap = extContext.getApplicationMap();
        BufferedReader reader = null;
        try {
            URL url = RenderKitUtils.class.getClassLoader().getResource("com/sun/faces/sunjsf.js");
            if (url == null) {
                LOGGER.severe("jsf.renderkit.util.cannot_load_js");
                return;
            }
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            InputStream input = conn.getInputStream();
            reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder builder = new StringBuilder(128);
            String line = reader.readLine();
            while (line != null) {
                String temp = line.trim();
                if (!(temp.length() == 0 || temp.startsWith("/*") || temp.startsWith("*") || temp.startsWith("*/") || temp.startsWith("//"))) {
                    builder.append(line).append('\n');
                }
                line = reader.readLine();
            }
            builder.deleteCharAt(builder.length() - 1);
            char[] sunJsfJs = WebConfiguration.getInstance(extContext).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressJavaScript) ? RenderKitUtils.compressJS(builder.toString()) : builder.toString().toCharArray();
            appMap.put(SUN_JSF_JS, sunJsfJs);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "jsf.renderkit.util.cannot_load_js", ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static String getFormClientId(UIComponent component, FacesContext context) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm form = (UIForm)parent;
        if (form != null) {
            return form.getClientId(context);
        }
        return null;
    }

    private static boolean hasScriptBeenRendered(FacesContext context) {
        return context.getAttributes().get("com.sun.faces.jsfjsState") != null;
    }

    private static void setScriptAsRendered(FacesContext context) {
        context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
    }
}

