/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.FaceletConfigResourceProvider;
import com.sun.faces.spi.FacesConfigResourceProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationResourceProviderFactory {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public static ConfigurationResourceProvider[] createProviders(ProviderType providerType) {
        String[] serviceEntries = ConfigurationResourceProviderFactory.getServiceEntries(providerType.servicesKey);
        ArrayList<ConfigurationResourceProvider> providers = new ArrayList<ConfigurationResourceProvider>();
        if (serviceEntries.length > 0) {
            for (String serviceEntry : serviceEntries) {
                ConfigurationResourceProvider provider = ConfigurationResourceProviderFactory.getProviderFromEntry(serviceEntry);
                if (provider == null) continue;
                if (ProviderType.FacesConfig == providerType) {
                    if (!(provider instanceof FacesConfigResourceProvider)) {
                        throw new IllegalStateException("Expected ConfigurationResourceProvider type to be an instance of FacesConfigResourceProvider");
                    }
                } else if (!(provider instanceof FaceletConfigResourceProvider)) {
                    throw new IllegalStateException("Expected ConfigurationResourceProvider type to be an instance of FaceletConfigResourceProvider");
                }
                providers.add(provider);
            }
            return providers.toArray(new ConfigurationResourceProvider[providers.size()]);
        }
        return new ConfigurationResourceProvider[0];
    }

    private static ConfigurationResourceProvider getProviderFromEntry(String entry) {
        if (entry == null) {
            return null;
        }
        try {
            Class clazz = Util.loadClass(entry, null);
            return (ConfigurationResourceProvider)clazz.newInstance();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getServiceEntries(String key) {
        String serviceName;
        Enumeration<URL> urls;
        ArrayList<String> results;
        block27: {
            results = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return EMPTY_ARRAY;
            }
            urls = null;
            serviceName = "META-INF/services/" + key;
            try {
                urls = loader.getResources(serviceName);
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block27;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        if (urls != null) {
            InputStream input = null;
            BufferedReader reader = null;
            while (urls.hasMoreElements()) {
                try {
                    if (results == null) {
                        results = new ArrayList<String>();
                    }
                    URL url = urls.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    input = conn.getInputStream();
                    if (input == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                    }
                    catch (Exception e) {
                        reader = new BufferedReader(new InputStreamReader(input));
                    }
                    String line = reader.readLine();
                    while (line != null) {
                        results.add(line.trim());
                        line = reader.readLine();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "jsf.spi.provider.cannot_read_service", new Object[]{serviceName});
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception ignored) {}
                    }
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
        return results != null && !results.isEmpty() ? results.toArray(new String[results.size()]) : EMPTY_ARRAY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProviderType {
        FacesConfig("com.sun.faces.spi.FacesConfigResourceProvider"),
        FaceletConfig("com.sun.faces.spi.FaceletConfigResourceProvider");

        String servicesKey;

        private ProviderType(String servicesKey) {
            this.servicesKey = servicesKey;
        }
    }
}

