/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ServerSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String STATEMANAGED_SERIAL_ID_KEY = ServerSideStateHelper.class.getName() + ".SerialId";
    public static final String LOGICAL_VIEW_MAP = ServerSideStateHelper.class.getName() + ".LogicalViewMap";
    protected final Integer numberOfLogicalViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
    protected final Integer numberOfViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfViews);
    protected boolean generateUniqueStateIds;
    protected final Random random;

    public ServerSideStateHelper() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.generateUniqueStateIds = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.GenerateUniqueServerStateIds);
        this.random = this.generateUniqueStateIds ? new Random(System.nanoTime() + (long)webConfig.getServletContext().hashCode()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        Util.notNull("context", ctx);
        Util.notNull("state", state);
        Object[] stateToWrite = (Object[])state;
        ExternalContext externalContext = ctx.getExternalContext();
        Object sessionObj = externalContext.getSession(true);
        Map sessionMap = externalContext.getSessionMap();
        Object object = sessionObj;
        synchronized (object) {
            Map<String, Map> logicalMap = TypedCollections.dynamicallyCastMap((Map)sessionMap.get(LOGICAL_VIEW_MAP), String.class, Map.class);
            if (logicalMap == null) {
                logicalMap = new LRUMap<String, Map>(this.numberOfLogicalViews);
                sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
            }
            Object structure = stateToWrite[0];
            Object savedState = this.handleSaveState(stateToWrite[1]);
            String idInLogicalMap = (String)RequestStateManager.get(ctx, "com.sun.faces.logicalViewMap");
            if (idInLogicalMap == null) {
                idInLogicalMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
            }
            String idInActualMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
            Map<String, Object[]> actualMap = TypedCollections.dynamicallyCastMap(logicalMap.get(idInLogicalMap), String.class, Object[].class);
            if (actualMap == null) {
                actualMap = new LRUMap<String, Object[]>(this.numberOfViews);
                logicalMap.put(idInLogicalMap, actualMap);
            }
            String id = idInLogicalMap + ':' + idInActualMap;
            Object[] stateArray = actualMap.get(idInActualMap);
            if (stateArray != null) {
                stateArray[0] = structure;
                stateArray[1] = savedState;
            } else {
                actualMap.put(idInActualMap, new Object[]{structure, savedState});
            }
            sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
            if (stateCapture != null) {
                stateCapture.append(id);
            } else {
                ResponseWriter writer = ctx.getResponseWriter();
                writer.write(this.stateFieldStart);
                writer.write(id);
                writer.write(STATE_FIELD_END);
                this.writeRenderKitIdField(ctx, writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getState(FacesContext ctx, String viewId) {
        String compoundId = ServerSideStateHelper.getStateParamValue(ctx);
        if (compoundId == null) {
            return null;
        }
        int sep = compoundId.indexOf(58);
        assert (sep != -1);
        assert (sep < compoundId.length());
        String idInLogicalMap = compoundId.substring(0, sep);
        String idInActualMap = compoundId.substring(sep + 1);
        ExternalContext externalCtx = ctx.getExternalContext();
        Object sessionObj = externalCtx.getSession(false);
        if (sessionObj == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to restore server side state for view ID {0} as no session is available", viewId);
            }
            return null;
        }
        Object object = sessionObj;
        synchronized (object) {
            Map actualMap;
            Map logicalMap = (Map)externalCtx.getSessionMap().get(LOGICAL_VIEW_MAP);
            if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                RequestStateManager.set(ctx, "com.sun.faces.logicalViewMap", idInLogicalMap);
                Object[] state = (Object[])actualMap.get(idInActualMap);
                state[1] = this.handleRestoreState(state[1]);
                return state;
            }
        }
        return null;
    }

    protected Integer getIntegerConfigValue(WebConfiguration.WebContextInitParameter param) {
        String noOfViewsStr = this.webConfig.getOptionValue(param);
        Integer value = null;
        try {
            value = Integer.valueOf(noOfViewsStr);
        }
        catch (NumberFormatException nfe) {
            String defaultValue = param.getDefaultValue();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error parsing the context init parameter {0}.  Using default value {1} instead.", new Object[]{param.getQualifiedName(), defaultValue});
            }
            try {
                value = Integer.valueOf(defaultValue);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        return value;
    }

    protected Object handleSaveState(Object state) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oas = null;
            try {
                oas = this.serialProvider.createObjectOutputStream(this.compressViewState ? new GZIPOutputStream((OutputStream)baos, 1024) : baos);
                oas.writeObject(state);
                oas.flush();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (oas != null) {
                    try {
                        oas.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return baos.toByteArray();
        }
        return state;
    }

    protected Object handleRestoreState(Object state) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])state);
            ObjectInputStream ois = null;
            try {
                ois = this.serialProvider.createObjectInputStream(this.compressViewState ? new GZIPInputStream((InputStream)bais, 1024) : bais);
                Object object = ois.readObject();
                return object;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return state;
    }

    private String createIncrementalRequestId(FacesContext ctx) {
        Map sm = ctx.getExternalContext().getSessionMap();
        AtomicInteger idgen = (AtomicInteger)sm.get(STATEMANAGED_SERIAL_ID_KEY);
        if (idgen == null) {
            idgen = new AtomicInteger(1);
        }
        sm.put(STATEMANAGED_SERIAL_ID_KEY, idgen);
        return "j_id" + idgen.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }
}

