/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.component.behavior.AjaxBehaviors;
import com.sun.faces.component.validator.ComponentValidators;
import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.jsf.ActionSourceRule;
import com.sun.faces.facelets.tag.jsf.ComponentRule;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.faces.facelets.tag.jsf.RenderPropertyRule;
import com.sun.faces.facelets.tag.jsf.ValueHolderRule;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandlerDelegate;

public class ComponentTagHandlerDelegateImpl
extends TagHandlerDelegate {
    private ComponentHandler owner;
    private static final Logger log = FacesLogger.FACELETS_COMPONENT.getLogger();
    private final TagAttribute binding;
    protected String componentType;
    protected final TagAttribute id;
    private final String rendererType;
    private CreateComponentDelegate createComponentDelegate;

    public ComponentTagHandlerDelegateImpl(ComponentHandler owner) {
        this.owner = owner;
        ComponentConfig config = owner.getComponentConfig();
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = owner.getTagAttribute("id");
        this.binding = owner.getTagAttribute("binding");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null) {
            throw new TagException(this.owner.getTag(), "Parent UIComponent was null");
        }
        String id = ctx.generateUniqueId(this.owner.getTagId());
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.owner.getTag() + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.owner.getTag() + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this.owner.setAttributes(ctx, (Object)c);
            c.getAttributes().put("com.sun.faces.facelets.MARK_ID", id);
            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development)) {
                c.getAttributes().put("javax.faces.component.VIEW_LOCATION_KEY", this.owner.getTag().getLocation());
            }
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
                if (root != null) {
                    UIComponent ancestorNamingContainer = parent.getNamingContainer();
                    String uid = null != ancestorNamingContainer && ancestorNamingContainer instanceof UniqueIdVendor ? ((UniqueIdVendor)ancestorNamingContainer).createUniqueId(ctx.getFacesContext(), id) : root.createUniqueId(ctx.getFacesContext(), id);
                    c.setId(uid);
                }
            }
            if (this.rendererType != null) {
                c.setRendererType(this.rendererType);
            }
            this.owner.onComponentCreated(ctx, c, parent);
        }
        c.pushComponentToEL(ctx.getFacesContext(), c);
        this.owner.applyNextHandler(ctx, c);
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            if (this.getFacetName(ctx, parent) == null) {
                parent.getChildren().remove(c);
            }
        }
        this.privateOnComponentPopulated(ctx, c, parent);
        this.owner.onComponentPopulated(ctx, c, parent);
        ComponentSupport.addComponent(ctx, parent, c);
        c.popComponentFromEL(ctx.getFacesContext());
        if (Boolean.TRUE.equals(ctx.getFacesContext().getAttributes().get("partialStateSaving")) && UIComponent.getCurrentCompositeComponent((FacesContext)ctx.getFacesContext()) == null) {
            c.markInitialState();
        }
    }

    public MetaRuleset createMetaRuleset(Class type) {
        Util.notNull("type", type);
        MetaRulesetImpl m = new MetaRulesetImpl(this.owner.getTag(), type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        if (UISelectOne.class.isAssignableFrom(type) || UISelectMany.class.isAssignableFrom(type)) {
            m.addRule(RenderPropertyRule.Instance);
        }
        return m;
    }

    void setCreateComponentDelegate(CreateComponentDelegate createComponentDelegate) {
        this.createComponentDelegate = createComponentDelegate;
    }

    private UIComponent createComponent(FaceletContext ctx) {
        UIComponent c;
        if (null != this.createComponentDelegate) {
            return this.createComponentDelegate.createComponent(ctx);
        }
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, Object.class);
            c = app.createComponent(ve, faces, this.componentType, this.rendererType);
            if (c != null) {
                c.setValueExpression("binding", ve);
            }
        } else {
            c = app.createComponent(faces, this.componentType, this.rendererType);
        }
        return c;
    }

    private void privateOnComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        FacesContext context;
        AjaxBehaviors ajaxBehaviors;
        if (c instanceof ClientBehaviorHolder && (ajaxBehaviors = AjaxBehaviors.getAjaxBehaviors(context = ctx.getFacesContext(), false)) != null) {
            ajaxBehaviors.addBehaviors(context, (ClientBehaviorHolder)c);
        }
        if (c instanceof EditableValueHolder) {
            this.processValidators(ctx.getFacesContext(), (EditableValueHolder)c);
        }
    }

    private void processValidators(FacesContext ctx, EditableValueHolder editableValueHolder) {
        ComponentValidators componentValidators = ComponentValidators.getValidators(ctx, false);
        if (componentValidators != null) {
            componentValidators.addValidators(ctx, editableValueHolder);
        } else {
            ComponentValidators.addDefaultValidatorsToComponent(ctx, editableValueHolder);
        }
    }

    private final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    static interface CreateComponentDelegate {
        public UIComponent createComponent(FaceletContext var1);
    }
}

