/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;

public class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private final Compiler compiler;
    private Map<String, DefaultFacelet> facelets;
    private Map<String, DefaultFacelet> metadataFacelets;
    private Map<String, URL> relativeLocations;
    private final ResourceResolver resolver;
    private final URL baseUrl;
    private final long refreshPeriod;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resolver);
        this.compiler = compiler;
        this.facelets = new HashMap<String, DefaultFacelet>();
        this.metadataFacelets = new HashMap<String, DefaultFacelet>();
        this.relativeLocations = new HashMap<String, URL>();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        long l = this.refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using ResourceResolver: " + resolver);
            log.fine("Using Refresh Period: " + this.refreshPeriod);
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getFacelet(String uri) throws IOException {
        return this.getFacelet(this.resolveURL(uri));
    }

    public Facelet getMetadataFacelet(String uri) throws IOException {
        return this.getMetadataFacelet(this.resolveURL(uri));
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(URL url) throws IOException {
        Util.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this.facelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this.createFacelet(url);
            if (this.refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this.facelets);
                newLoc.put(key, f);
                this.facelets = newLoc;
            }
        }
        return f;
    }

    public Facelet getMetadataFacelet(URL url) throws IOException {
        Util.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this.metadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this.createMetadataFacelet(url);
            if (this.refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this.metadataFacelets);
                newLoc.put(key, f);
                this.metadataFacelets = newLoc;
            }
        }
        return f;
    }

    public boolean needsToBeRefreshed(URL url) {
        boolean result = false;
        Util.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this.facelets.get(key);
        result = f == null || this.needsToBeRefreshed(f);
        return result;
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this.refreshPeriod == 0L) {
            return true;
        }
        if (this.refreshPeriod == -1L) {
            return false;
        }
        long ttl = facelet.getCreateTime() + this.refreshPeriod;
        URL url = facelet.getSource();
        InputStream is = null;
        if (System.currentTimeMillis() > ttl) {
            try {
                URLConnection conn = url.openConnection();
                is = conn.getInputStream();
                long atl = conn.getLastModified();
                boolean bl = atl > ttl;
                return bl;
            }
            catch (Exception e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return false;
    }

    private URL resolveURL(String uri) throws IOException {
        URL url = this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this.baseUrl, uri);
            if (url != null) {
                HashMap<String, URL> newLoc = new HashMap<String, URL>(this.relativeLocations);
                newLoc.put(uri, url);
                this.relativeLocations = newLoc;
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return url;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Metadata Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.metadataCompile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }
}

