/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.faces;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.Processor;
import org.apache.shale.remoting.faces.MappingsHelper;

public class RemotingPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 9188955342844983587L;
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.shale.remoting.Bundle");
    private MappingsHelper helper = new MappingsHelper();
    private transient Log log = null;

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (!this.isRemotingEnabled(context)) {
            return;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Checking view identifier '" + context.getViewRoot().getViewId() + "'"));
        }
        Iterator mappings = this.helper.getMappings(context).getMappings().iterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            String resourceId = mapping.mapViewId(context);
            if (resourceId == null) continue;
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)("View identifier '" + context.getViewRoot().getViewId() + "' matched pattern '" + mapping.getPattern() + "' with resource id '" + resourceId + "'"));
            }
            try {
                Processor processor = mapping.getProcessor();
                processor.process(context, resourceId);
                break;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)RemotingPhaseListener.class);
        }
        return this.log;
    }

    private boolean isRemotingEnabled(FacesContext context) {
        boolean result = false;
        ExternalContext extContext = context.getExternalContext();
        Map appMap = extContext.getApplicationMap();
        String ENABLED_KEY = "org.apache.shale.remoting.faces.RemotingPhaseListener.ENABLED";
        String DISABLED_KEY = "org.apache.shale.remoting.faces.RemotingPhaseListener.DISABLED";
        if (appMap.containsKey("org.apache.shale.remoting.faces.RemotingPhaseListener.DISABLED")) {
            result = false;
        } else if (appMap.containsKey("org.apache.shale.remoting.faces.RemotingPhaseListener.ENABLED")) {
            result = true;
        } else if (this.checkRemotingEnabled(extContext)) {
            appMap.put("org.apache.shale.remoting.faces.RemotingPhaseListener.ENABLED", Boolean.TRUE);
        } else {
            appMap.put("org.apache.shale.remoting.faces.RemotingPhaseListener.DISABLED", Boolean.TRUE);
        }
        return result;
    }

    private boolean checkRemotingEnabled(ExternalContext extContext) {
        boolean result;
        block11: {
            result = false;
            if (extContext.getInitParameterMap().containsKey("org.apache.shale.remoting.ENABLE")) {
                result = true;
            } else {
                LifecycleFactory lifecycleFactory = null;
                String DYNAFACES_LIFECYCLE = "com.sun.faces.lifecycle.PARTIAL";
                try {
                    lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
                    if (null != lifecycleFactory.getLifecycle("com.sun.faces.lifecycle.PARTIAL")) {
                        result = true;
                    }
                }
                catch (FacesException fe) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("FacesException while getting lifecycleFactory: " + fe.getMessage()));
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("IllegalArgumentException while looking for lifecycle: com.sun.faces.lifecycle.PARTIAL: " + iae.getMessage()));
                    }
                }
                catch (NullPointerException npe) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("NullPointerException while looking for lifecycle: com.sun.faces.lifecycle.PARTIAL: " + npe.getMessage()));
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isWarnEnabled()) break block11;
                    this.log.warn((Object)("Exception while looking for lifecycle: com.sun.faces.lifecycle.PARTIAL: " + t.getMessage()));
                }
            }
        }
        return result;
    }
}

