/*
 * @(#) GlossaryView.java 1.1 - last change made 07/19/01
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import java.awt.Component;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.HelpModel;
import javax.help.IndexView;

/**
 * View information for a Glossary Navigator
 *
 * @author	Roger Brinkley
 * @version   1.1     07/19/01
 */

public class GlossaryView extends IndexView {
    /**
     * Construct a GlossaryView with some given data.  Locale defaults
     * to that of the HelpSet
     *
     * @param hs The HelpSet that provides context information
     * @param name The name of the View
     * @param label The label (to show the user) of the View
     * @param params A Hashtable providing different key/values for this type
     */
    public GlossaryView(HelpSet hs,
			String name,
			String label,
			Hashtable params) {
	super(hs, name, label, hs.getLocale(), params);
    }

    /**
     * Construct a GlossaryViewer VIew with some given data.
     *
     * @param hs The HelpSet that provides context information
     * @param name The name of the View
     * @param label The label (to show the user) of the View
     * @param locale The default locale to interpret data in this View
     * @param params A Hashtable providing different key/values for this type
     */
    public GlossaryView(HelpSet hs,
			String name,
			String label,
			Locale locale,
			Hashtable params) {
	super(hs, name, label, locale, params);
    }

    /**
     * create a navigator for a given model
     */
    public Component createNavigator(HelpModel model) {
	return new JHelpGlossaryNavigator(this, model);
    }
}




