/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonNumberImpl
implements JsonNumber {
    private final BigDecimal bigDecimal;

    public JsonNumberImpl(int value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(long value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(BigInteger value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(double value) {
        this.bigDecimal = BigDecimal.valueOf(value);
    }

    public JsonNumberImpl(BigDecimal value) {
        this.bigDecimal = value;
    }

    @Override
    public JsonNumber.NumberType getNumberType() {
        return this.bigDecimal.scale() == 0 ? JsonNumber.NumberType.INTEGER : JsonNumber.NumberType.DECIMAL;
    }

    @Override
    public int getIntValue() {
        return this.bigDecimal.intValue();
    }

    @Override
    public int getIntValueExact() {
        return this.bigDecimal.intValueExact();
    }

    @Override
    public long getLongValue() {
        return this.bigDecimal.longValue();
    }

    @Override
    public long getLongValueExact() {
        return this.bigDecimal.longValueExact();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.bigDecimal.toBigInteger();
    }

    @Override
    public BigInteger getBigIntegerValueExact() {
        return this.bigDecimal.toBigIntegerExact();
    }

    @Override
    public double getDoubleValue() {
        return this.bigDecimal.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return this.bigDecimal;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public int hashCode() {
        return this.getBigDecimalValue().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JsonNumber)) {
            return false;
        }
        JsonNumber other = (JsonNumber)obj;
        return this.getBigDecimalValue().equals(other.getBigDecimalValue());
    }

    @Override
    public String toString() {
        return this.bigDecimal.toString();
    }
}

