/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonConfiguration;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;

public class JsonWriter
implements Closeable {
    private final JsonGenerator generator;
    private boolean writeDone;

    public JsonWriter(Writer writer) {
        this.generator = Json.createGenerator(writer);
    }

    public JsonWriter(Writer writer, JsonConfiguration config) {
        this.generator = Json.createGeneratorFactory(config).createGenerator(writer);
    }

    public JsonWriter(OutputStream out) {
        this.generator = Json.createGenerator(out);
    }

    public JsonWriter(OutputStream out, JsonConfiguration config) {
        this.generator = Json.createGeneratorFactory(config).createGenerator(out);
    }

    public JsonWriter(OutputStream out, Charset charset) {
        this.generator = Json.createGeneratorFactory().createGenerator(out, charset);
    }

    public JsonWriter(OutputStream out, Charset charset, JsonConfiguration config) {
        this.generator = Json.createGeneratorFactory(config).createGenerator(out, charset);
    }

    public void writeArray(JsonArray array) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        this.generator.writeStartArray();
        for (JsonValue value : array) {
            this.generator.write(value);
        }
        this.generator.writeEnd().close();
    }

    public void writeObject(JsonObject object) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        this.generator.writeStartObject();
        for (Map.Entry e : object.entrySet()) {
            this.generator.write((String)e.getKey(), (JsonValue)e.getValue());
        }
        this.generator.writeEnd().close();
    }

    public void write(JsonStructure value) {
        if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else {
            this.writeObject((JsonObject)value);
        }
    }

    @Override
    public void close() {
        this.writeDone = true;
        this.generator.close();
    }
}

