/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Measure;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;

public abstract class MeasureFormat
extends Format {
    private static final NumberSpaceUnit DEFAULT = new NumberSpaceUnit(NumberFormat.getInstance(), UnitFormat.getInstance());
    private static final Standard STANDARD = new Standard();
    private static final long serialVersionUID = 1L;

    public static MeasureFormat getInstance() {
        return DEFAULT;
    }

    public static MeasureFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new NumberSpaceUnit(numberFormat, unitFormat);
    }

    public static MeasureFormat getStandard() {
        return STANDARD;
    }

    public abstract Appendable format(Measure var1, Appendable var2) throws IOException;

    public abstract Measure parse(CharSequence var1, ParsePosition var2) throws IllegalArgumentException;

    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof Measure)) {
            throw new IllegalArgumentException("obj: Not an instance of Measure");
        }
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        try {
            return (StringBuffer)this.format((Measure)obj, toAppendTo);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public final Measure parseObject(String source, ParsePosition pos) {
        try {
            return this.parse(source, pos);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public final StringBuilder format(Measure measure, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(measure, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class NumberSpaceUnit
    extends MeasureFormat {
        private final NumberFormat _numberFormat;
        private final UnitFormat _unitFormat;

        private NumberSpaceUnit(NumberFormat numberFormat, UnitFormat unitFormat) {
            this._numberFormat = numberFormat;
            this._unitFormat = unitFormat;
        }

        public Appendable format(Measure measure, Appendable dest) throws IOException {
            Unit unit = measure.getUnit();
            if (unit instanceof CompoundUnit) {
                return this.formatCompound(measure.doubleValue(unit), unit, dest);
            }
            dest.append(this._numberFormat.format(measure.getValue()));
            dest.append(' ');
            return this._unitFormat.format(measure.getUnit(), dest);
        }

        private Appendable formatCompound(double value, Unit unit, Appendable dest) throws IOException {
            if (!(unit instanceof CompoundUnit)) {
                dest.append(String.valueOf((long)value) + " ");
                return this._unitFormat.format(unit, dest);
            }
            Unit high = ((CompoundUnit)unit).getHigh();
            Unit low = ((CompoundUnit)unit).getLow();
            long highValue = (long)low.getConverterTo(high).convert(value);
            double lowValue = value - high.getConverterTo(low).convert(highValue);
            this.formatCompound(highValue, high, dest);
            dest.append(' ');
            return this.formatCompound(lowValue, low, dest);
        }

        public Measure parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            String str = csq.toString();
            Number number = this._numberFormat.parse(str, cursor);
            if (number == null) {
                throw new IllegalArgumentException("Number cannot be parsed");
            }
            Unit unit = this._unitFormat.parse(csq, cursor);
            if (number instanceof BigDecimal) {
                return Measure.valueOf((BigDecimal)number, unit);
            }
            if (number instanceof Long) {
                return Measure.valueOf((Long)number, unit);
            }
            if (number instanceof Double) {
                return Measure.valueOf((Double)number, unit);
            }
            throw new UnsupportedOperationException("Number of type " + number.getClass() + " are not supported");
        }
    }

    private static final class Standard
    extends MeasureFormat {
        private Standard() {
        }

        public Appendable format(Measure measure, Appendable dest) throws IOException {
            Unit unit = measure.getUnit();
            if (unit instanceof CompoundUnit) {
                return this.formatCompound(measure.doubleValue(unit), unit, dest);
            }
            BigDecimal decimal = measure.decimalValue(unit, MathContext.UNLIMITED);
            dest.append(decimal.toString());
            dest.append(' ');
            return UnitFormat.getStandard().format(unit, dest);
        }

        private Appendable formatCompound(double value, Unit unit, Appendable dest) throws IOException {
            if (!(unit instanceof CompoundUnit)) {
                dest.append(String.valueOf((long)value) + " ");
                return UnitFormat.getStandard().format(unit, dest);
            }
            Unit high = ((CompoundUnit)unit).getHigh();
            Unit low = ((CompoundUnit)unit).getLow();
            long highValue = (long)low.getConverterTo(high).convert(value);
            double lowValue = value - high.getConverterTo(low).convert(highValue);
            this.formatCompound(highValue, high, dest);
            dest.append(' ');
            return this.formatCompound(lowValue, low, dest);
        }

        public Measure parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            int startDecimal = cursor.getIndex();
            while (startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal))) {
                ++startDecimal;
            }
            int endDecimal = startDecimal + 1;
            while (endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal))) {
                ++endDecimal;
            }
            BigDecimal decimal = new BigDecimal(csq.subSequence(startDecimal, endDecimal).toString());
            cursor.setIndex(endDecimal + 1);
            Unit unit = UnitFormat.getStandard().parse(csq, cursor);
            return Measure.valueOf(decimal, unit);
        }
    }
}

