/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;

public final class AddConverter
extends UnitConverter {
    private final BigDecimal _offset;
    private static final long serialVersionUID = 1L;

    public AddConverter(BigDecimal offset) {
        if (offset.equals(BigDecimal.ZERO)) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this._offset = offset;
    }

    public BigDecimal getOffset() {
        return this._offset;
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof AddConverter) {
            BigDecimal offset = this._offset.add(((AddConverter)converter)._offset);
            return offset.equals(BigDecimal.ZERO) ? IDENTITY : new AddConverter(offset);
        }
        return super.concatenate(converter);
    }

    public AddConverter inverse() {
        return new AddConverter(this._offset.negate());
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.add(this._offset, ctx);
    }

    public final String toString() {
        return "AddConverter(" + this._offset + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddConverter)) {
            return false;
        }
        AddConverter that = (AddConverter)obj;
        return this._offset.equals(that._offset);
    }

    public int hashCode() {
        return this._offset.hashCode();
    }
}

