/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;

public final class MultiplyConverter
extends LinearConverter {
    private final BigDecimal _factor;
    private static final long serialVersionUID = 1L;

    public MultiplyConverter(BigDecimal factor) {
        if (factor.equals(BigDecimal.ONE)) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this._factor = factor;
    }

    public BigDecimal getFactor() {
        return this._factor;
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof MultiplyConverter) {
            BigDecimal factor = this._factor.multiply(((MultiplyConverter)converter)._factor);
            return factor.equals(BigDecimal.ONE) ? IDENTITY : new MultiplyConverter(factor);
        }
        return super.concatenate(converter);
    }

    public MultiplyConverter inverse() {
        return new MultiplyConverter(BigDecimal.ONE.divide(this._factor));
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.multiply(this._factor, ctx);
    }

    public final String toString() {
        return "MultiplyConverter(" + this._factor + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiplyConverter)) {
            return false;
        }
        MultiplyConverter that = (MultiplyConverter)obj;
        return this._factor.equals(that._factor);
    }

    public int hashCode() {
        return this._factor.hashCode();
    }
}

