/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;

public final class RationalConverter
extends LinearConverter {
    private final BigDecimal _dividend;
    private final BigDecimal _divisor;
    private static final long serialVersionUID = 1L;

    public RationalConverter(long dividend, long divisor) {
        this(BigInteger.valueOf(dividend), BigInteger.valueOf(divisor));
    }

    public RationalConverter(BigInteger dividend, BigInteger divisor) {
        if (divisor.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Negative or zero divisor");
        }
        if (dividend.equals(divisor)) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this._dividend = new BigDecimal(dividend);
        this._divisor = new BigDecimal(divisor);
    }

    public BigInteger getDividend() {
        return this._dividend.toBigInteger();
    }

    public BigInteger getDivisor() {
        return this._divisor.toBigInteger();
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.multiply(this._dividend, ctx).divide(this._divisor, ctx);
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)converter;
            BigInteger dividend = this.getDividend().multiply(that.getDividend());
            BigInteger divisor = this.getDivisor().multiply(that.getDivisor());
            BigInteger gcd = dividend.gcd(divisor);
            dividend = dividend.divide(gcd);
            divisor = divisor.divide(gcd);
            return dividend.equals(BigInteger.ONE) && divisor.equals(BigInteger.ONE) ? IDENTITY : new RationalConverter(dividend, divisor);
        }
        return super.concatenate(converter);
    }

    public RationalConverter inverse() {
        return this._dividend.signum() == -1 ? new RationalConverter(this.getDivisor().negate(), this.getDividend().negate()) : new RationalConverter(this.getDivisor(), this.getDividend());
    }

    public final String toString() {
        return "RationalConverter(" + this._dividend + "," + this._divisor + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RationalConverter)) {
            return false;
        }
        RationalConverter that = (RationalConverter)obj;
        return this._dividend.equals(that._dividend) && this._divisor.equals(that._divisor);
    }

    public int hashCode() {
        return this._dividend.hashCode() + this._divisor.hashCode();
    }
}

