/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.LinearConverter;

public abstract class UnitConverter
implements Serializable {
    public static final UnitConverter IDENTITY = new Identity();

    protected UnitConverter() {
    }

    public abstract UnitConverter inverse();

    public double convert(double value) {
        BigDecimal decimal = BigDecimal.valueOf(value);
        BigDecimal result = this.convert(decimal, MathContext.DECIMAL64);
        return result.doubleValue();
    }

    public abstract BigDecimal convert(BigDecimal var1, MathContext var2) throws ArithmeticException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public UnitConverter concatenate(UnitConverter converter) {
        return converter == IDENTITY ? this : new Compound(converter, this);
    }

    private static final class Compound
    extends UnitConverter {
        private final UnitConverter _first;
        private final UnitConverter _second;
        private static final long serialVersionUID = 1L;

        private Compound(UnitConverter first, UnitConverter second) {
            this._first = first;
            this._second = second;
        }

        public UnitConverter inverse() {
            return new Compound(this._second.inverse(), this._first.inverse());
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return this._second.convert(this._first.convert(value, ctx), ctx);
        }

        public boolean equals(Object cvtr) {
            if (this == cvtr) {
                return true;
            }
            if (!(cvtr instanceof Compound)) {
                return false;
            }
            Compound that = (Compound)cvtr;
            return this._first.equals(that._first) && this._second.equals(that._second);
        }

        public int hashCode() {
            return this._first.hashCode() + this._second.hashCode();
        }
    }

    private static final class Identity
    extends LinearConverter {
        private static final long serialVersionUID = 1L;

        private Identity() {
        }

        public Identity inverse() {
            return this;
        }

        public double convert(double value) {
            return value;
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return value;
        }

        public UnitConverter concatenate(UnitConverter converter) {
            return converter;
        }

        public boolean equals(Object cvtr) {
            return this == cvtr;
        }

        public int hashCode() {
            return 0;
        }
    }
}

