/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dimension
implements Serializable {
    private static Model CurrentModel = Model.STANDARD;
    public static final Dimension NONE = new Dimension(Unit.ONE);
    public static final Dimension LENGTH = new Dimension('L');
    public static final Dimension MASS = new Dimension('M');
    public static final Dimension TIME = new Dimension('T');
    public static final Dimension ELECTRIC_CURRENT = new Dimension('I');
    public static final Dimension TEMPERATURE = new Dimension('Q');
    public static final Dimension AMOUNT_OF_SUBSTANCE = new Dimension('N');
    public static final Dimension LUMINOUS_INTENSITY = new Dimension('J');
    private final Unit<?> _pseudoUnit;
    private static final long serialVersionUID = 1L;

    public Dimension(char symbol) {
        this._pseudoUnit = new BaseUnit("[" + symbol + "]");
    }

    private Dimension(Unit<?> pseudoUnit) {
        this._pseudoUnit = pseudoUnit;
    }

    public final Dimension times(Dimension that) {
        return new Dimension(this._pseudoUnit.times(that._pseudoUnit));
    }

    public final Dimension divide(Dimension that) {
        return new Dimension(this._pseudoUnit.divide(that._pseudoUnit));
    }

    public final Dimension pow(int n) {
        return new Dimension(this._pseudoUnit.pow(n));
    }

    public final Dimension root(int n) {
        return new Dimension(this._pseudoUnit.root(n));
    }

    public String toString() {
        return this._pseudoUnit.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof Dimension && this._pseudoUnit.equals(((Dimension)that)._pseudoUnit);
    }

    public int hashCode() {
        return this._pseudoUnit.hashCode();
    }

    public static void setModel(Model model) {
        CurrentModel = model;
    }

    public static Model getModel() {
        return CurrentModel;
    }

    /* synthetic */ Dimension(Unit unit, Dimension dimension) {
        this(unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Model {
        public static final Model STANDARD = new Model(){

            @Override
            public Dimension getDimension(BaseUnit<?> unit) {
                if (unit.equals(SI.METRE)) {
                    return LENGTH;
                }
                if (unit.equals(SI.KILOGRAM)) {
                    return MASS;
                }
                if (unit.equals(SI.KELVIN)) {
                    return TEMPERATURE;
                }
                if (unit.equals(SI.SECOND)) {
                    return TIME;
                }
                if (unit.equals(SI.AMPERE)) {
                    return ELECTRIC_CURRENT;
                }
                if (unit.equals(SI.MOLE)) {
                    return AMOUNT_OF_SUBSTANCE;
                }
                if (unit.equals(SI.CANDELA)) {
                    return LUMINOUS_INTENSITY;
                }
                return new Dimension(new BaseUnit("[" + unit.getSymbol() + "]"), null);
            }

            @Override
            public UnitConverter getTransform(BaseUnit<?> unit) {
                return UnitConverter.IDENTITY;
            }
        };

        public Dimension getDimension(BaseUnit<?> var1);

        public UnitConverter getTransform(BaseUnit<?> var1);
    }
}

