/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.measure.converter.LogConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.DataAmount;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.quantity.DynamicViscosity;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.KinematicViscosity;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.RadioactiveActivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Velocity;
import javax.measure.quantity.Volume;
import javax.measure.unit.SI;
import javax.measure.unit.SystemOfUnits;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonSI
extends SystemOfUnits {
    private static HashSet<Unit<?>> UNITS = new HashSet();
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    private static final int INTERNATIONAL_FOOT_DIVIDEND = 3048;
    private static final int INTERNATIONAL_FOOT_DIViSOR = 10000;
    private static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    private static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    private static final NonSI INSTANCE = new NonSI();
    public static final Unit<Dimensionless> PERCENT = NonSI.nonSI(Unit.ONE.divide(100L));
    public static final Unit<Dimensionless> DECIBEL = NonSI.nonSI(Unit.ONE.transform(new LogConverter(10.0).inverse().concatenate(new RationalConverter(1L, 10L))));
    public static final Unit<AmountOfSubstance> ATOM = NonSI.nonSI(SI.MOLE.divide(6.02214199E23));
    public static final Unit<Length> FOOT = NonSI.nonSI(SI.METRE.times(3048L).divide(10000L));
    public static final Unit<Length> FOOT_SURVEY_US = NonSI.nonSI(SI.METRE.times(1200L).divide(3937L));
    public static final Unit<Length> YARD = NonSI.nonSI(FOOT.times(3L));
    public static final Unit<Length> INCH = NonSI.nonSI(FOOT.divide(12L));
    public static final Unit<Length> MILE = NonSI.nonSI(SI.METRE.times(1609344L).divide(1000L));
    public static final Unit<Length> NAUTICAL_MILE = NonSI.nonSI(SI.METRE.times(1852L));
    public static final Unit<Length> ANGSTROM = NonSI.nonSI(SI.METRE.divide(10000000000L));
    public static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.nonSI(SI.METRE.times(1.49597870691E11));
    public static final Unit<Length> LIGHT_YEAR = NonSI.nonSI(SI.METRE.times(9.460528405E15));
    public static final Unit<Length> PARSEC = NonSI.nonSI(SI.METRE.times(3.085677E16));
    public static final Unit<Length> POINT = NonSI.nonSI(INCH.times(13837L).divide(1000000L));
    public static final Unit<Length> PIXEL = NonSI.nonSI(INCH.divide(72L));
    public static final Unit<Length> COMPUTER_POINT = PIXEL;
    public static final Unit<Duration> MINUTE = NonSI.nonSI(SI.SECOND.times(60L));
    public static final Unit<Duration> HOUR = NonSI.nonSI(MINUTE.times(60L));
    public static final Unit<Duration> DAY = NonSI.nonSI(HOUR.times(24L));
    public static final Unit<Duration> DAY_SIDEREAL = NonSI.nonSI(SI.SECOND.times(86164.09));
    public static final Unit<Duration> WEEK = NonSI.nonSI(DAY.times(7L));
    public static final Unit<Duration> YEAR_CALENDAR = NonSI.nonSI(DAY.times(365L));
    public static final Unit<Duration> YEAR_SIDEREAL = NonSI.nonSI(SI.SECOND.times(3.155814954E7));
    public static final Unit<Duration> YEAR_JULIEN = NonSI.nonSI(SI.SECOND.times(31557600L));
    public static final Unit<Mass> ATOMIC_MASS = NonSI.nonSI(SI.KILOGRAM.times(1.6605387280149467E-27));
    public static final Unit<Mass> ELECTRON_MASS = NonSI.nonSI(SI.KILOGRAM.times(9.10938188E-31));
    public static final Unit<Mass> POUND = NonSI.nonSI(SI.KILOGRAM.times(45359237L).divide(100000000L));
    public static final Unit<Mass> OUNCE = NonSI.nonSI(POUND.divide(16L));
    public static final Unit<Mass> TON_US = NonSI.nonSI(POUND.times(2000L));
    public static final Unit<Mass> TON_UK = NonSI.nonSI(POUND.times(2240L));
    public static final Unit<Mass> METRIC_TON = NonSI.nonSI(SI.KILOGRAM.times(1000L));
    public static final Unit<ElectricCharge> E = NonSI.nonSI(SI.COULOMB.times(1.602176462E-19));
    public static final Unit<ElectricCharge> FARADAY = NonSI.nonSI(SI.COULOMB.times(96485.3414719984));
    public static final Unit<ElectricCharge> FRANKLIN = NonSI.nonSI(SI.COULOMB.times(3.3356E-10));
    public static final Unit<Temperature> RANKINE = NonSI.nonSI(SI.KELVIN.times(5L).divide(9L));
    public static final Unit<Temperature> FAHRENHEIT = NonSI.nonSI(RANKINE.plus(459.67));
    public static final Unit<Angle> REVOLUTION = NonSI.nonSI(SI.RADIAN.times(Math.PI * 2));
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.nonSI(REVOLUTION.divide(360L));
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.nonSI(DEGREE_ANGLE.divide(60L));
    public static final Unit<Angle> SECOND_ANGLE = NonSI.nonSI(MINUTE_ANGLE.divide(60L));
    public static final Unit<Angle> CENTIRADIAN = NonSI.nonSI(SI.RADIAN.divide(100L));
    public static final Unit<Angle> GRADE = NonSI.nonSI(REVOLUTION.divide(400L));
    public static final Unit<Velocity> FOOT_PER_SECOND = NonSI.nonSI(FOOT.divide(SI.SECOND)).asType(Velocity.class);
    public static final Unit<Velocity> MILES_PER_HOUR = NonSI.nonSI(MILE.divide(HOUR)).asType(Velocity.class);
    public static final Unit<Velocity> KILOMETRES_PER_HOUR = NonSI.nonSI(SI.KILOMETRE.divide(HOUR)).asType(Velocity.class);
    public static final Unit<Velocity> KILOMETERS_PER_HOUR = KILOMETRES_PER_HOUR;
    public static final Unit<Velocity> KNOT = NonSI.nonSI(NAUTICAL_MILE.divide(HOUR)).asType(Velocity.class);
    public static final Unit<Velocity> C = NonSI.nonSI(SI.METRES_PER_SECOND.times(299792458L));
    public static final Unit<Acceleration> G = NonSI.nonSI(SI.METRES_PER_SQUARE_SECOND.times(980665L).divide(100000L));
    public static final Unit<Area> ARE = NonSI.nonSI(SI.SQUARE_METRE.times(100L));
    public static final Unit<Area> HECTARE = NonSI.nonSI(ARE.times(100L));
    public static final Unit<DataAmount> BYTE = NonSI.nonSI(SI.BIT.times(8L));
    public static final Unit<DataAmount> OCTET = BYTE;
    public static final Unit<ElectricCurrent> GILBERT = NonSI.nonSI(SI.AMPERE.times(0.7957747154594768));
    public static final Unit<Energy> ERG = NonSI.nonSI(SI.JOULE.divide(10000000L));
    public static final Unit<Energy> ELECTRON_VOLT = NonSI.nonSI(SI.JOULE.times(1.602176462E-19));
    public static final Unit<Illuminance> LAMBERT = NonSI.nonSI(SI.LUX.times(10000L));
    public static final Unit<MagneticFlux> MAXWELL = NonSI.nonSI(SI.WEBER.divide(100000000L));
    public static final Unit<MagneticFluxDensity> GAUSS = NonSI.nonSI(SI.TESLA.divide(10000L));
    public static final Unit<Force> DYNE = NonSI.nonSI(SI.NEWTON.divide(100000L));
    public static final Unit<Force> KILOGRAM_FORCE = NonSI.nonSI(SI.NEWTON.times(980665L).divide(100000L));
    public static final Unit<Force> POUND_FORCE = NonSI.nonSI(SI.NEWTON.times(44482216152605L).divide(10000000000000L));
    public static final Unit<Power> HORSEPOWER = NonSI.nonSI(SI.WATT.times(735.499));
    public static final Unit<Pressure> ATMOSPHERE = NonSI.nonSI(SI.PASCAL.times(101325L));
    public static final Unit<Pressure> BAR = NonSI.nonSI(SI.PASCAL.times(100000L));
    public static final Unit<Pressure> MILLIMETER_OF_MERCURY = NonSI.nonSI(SI.PASCAL.times(133.322));
    public static final Unit<Pressure> INCH_OF_MERCURY = NonSI.nonSI(SI.PASCAL.times(3386.388));
    public static final Unit<RadiationDoseAbsorbed> RAD = NonSI.nonSI(SI.GRAY.divide(100L));
    public static final Unit<RadiationDoseEffective> REM = NonSI.nonSI(SI.SIEVERT.divide(100L));
    public static final Unit<RadioactiveActivity> CURIE = NonSI.nonSI(SI.BECQUEREL.times(37000000000L));
    public static final Unit<RadioactiveActivity> RUTHERFORD = NonSI.nonSI(SI.BECQUEREL.times(1000000L));
    public static final Unit<SolidAngle> SPHERE = NonSI.nonSI(SI.STERADIAN.times(Math.PI * 4));
    public static final Unit<Volume> LITRE = NonSI.nonSI(SI.CUBIC_METRE.divide(1000L));
    public static final Unit<Volume> LITER = LITRE;
    public static final Unit<Volume> CUBIC_INCH = NonSI.nonSI(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> GALLON_LIQUID_US = NonSI.nonSI(CUBIC_INCH.times(231L));
    public static final Unit<Volume> OUNCE_LIQUID_US = NonSI.nonSI(GALLON_LIQUID_US.divide(128L));
    public static final Unit<Volume> GALLON_DRY_US = NonSI.nonSI(CUBIC_INCH.times(2688025L).divide(10000L));
    public static final Unit<Volume> GALLON_UK = NonSI.nonSI(LITRE.times(454609L).divide(100000L));
    public static final Unit<Volume> OUNCE_LIQUID_UK = NonSI.nonSI(GALLON_UK.divide(160L));
    public static final Unit<DynamicViscosity> POISE = NonSI.nonSI(SI.GRAM.divide(SI.CENTI(SI.METRE).times(SI.SECOND)));
    public static final Unit<KinematicViscosity> STOKE = NonSI.nonSI(SI.CENTI(SI.METRE).pow(2).divide(SI.SECOND));
    public static final Unit<?> ROENTGEN = NonSI.nonSI(SI.COULOMB.divide(SI.KILOGRAM).times(2.58E-4));

    private NonSI() {
    }

    public static NonSI getInstance() {
        return INSTANCE;
    }

    @Override
    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(UNITS);
    }

    private static <U extends Unit<?>> U nonSI(U unit) {
        UNITS.add(unit);
        return unit;
    }
}

