/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.measure.converter.RationalConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.DataAmount;
import javax.measure.quantity.Duration;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Quantity;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.RadioactiveActivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Velocity;
import javax.measure.quantity.Volume;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.Numbering;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.SystemOfUnits;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SI
extends SystemOfUnits
implements Numbering {
    private static HashSet<Unit<?>> UNITS = new HashSet();
    private static final SI INSTANCE = new SI();
    public static final BaseUnit<ElectricCurrent> AMPERE = SI.si(new BaseUnit("A"));
    public static final BaseUnit<LuminousIntensity> CANDELA = SI.si(new BaseUnit("cd"));
    public static final BaseUnit<Temperature> KELVIN = SI.si(new BaseUnit("K"));
    public static final BaseUnit<Mass> KILOGRAM = SI.si(new BaseUnit("kg"));
    public static final BaseUnit<Length> METRE = SI.si(new BaseUnit("m"));
    public static final Unit<Length> METER = METRE;
    public static final BaseUnit<AmountOfSubstance> MOLE = SI.si(new BaseUnit("mol"));
    public static final BaseUnit<Duration> SECOND = SI.si(new BaseUnit("s"));
    public static final Unit<Mass> GRAM = KILOGRAM.divide(1000L);
    public static final AlternateUnit<Angle> RADIAN = SI.si(new AlternateUnit("rad", Unit.ONE));
    public static final AlternateUnit<SolidAngle> STERADIAN = SI.si(new AlternateUnit("sr", Unit.ONE));
    public static final AlternateUnit<DataAmount> BIT = SI.si(new AlternateUnit("bit", Unit.ONE));
    public static final AlternateUnit<Frequency> HERTZ = SI.si(new AlternateUnit("Hz", Unit.ONE.divide(SECOND)));
    public static final AlternateUnit<Force> NEWTON = SI.si(new AlternateUnit("N", METRE.times(KILOGRAM).divide(SECOND.pow(2))));
    public static final AlternateUnit<Pressure> PASCAL = SI.si(new AlternateUnit("Pa", NEWTON.divide(METRE.pow(2))));
    public static final AlternateUnit<Energy> JOULE = SI.si(new AlternateUnit("J", NEWTON.times(METRE)));
    public static final AlternateUnit<Power> WATT = SI.si(new AlternateUnit("W", JOULE.divide(SECOND)));
    public static final AlternateUnit<ElectricCharge> COULOMB = SI.si(new AlternateUnit("C", SECOND.times(AMPERE)));
    public static final AlternateUnit<ElectricPotential> VOLT = SI.si(new AlternateUnit("V", WATT.divide(AMPERE)));
    public static final AlternateUnit<ElectricCapacitance> FARAD = SI.si(new AlternateUnit("F", COULOMB.divide(VOLT)));
    public static final AlternateUnit<ElectricResistance> OHM = SI.si(new AlternateUnit("\u03a9", VOLT.divide(AMPERE)));
    public static final AlternateUnit<ElectricConductance> SIEMENS = SI.si(new AlternateUnit("S", AMPERE.divide(VOLT)));
    public static final AlternateUnit<MagneticFlux> WEBER = SI.si(new AlternateUnit("Wb", VOLT.times(SECOND)));
    public static final AlternateUnit<MagneticFluxDensity> TESLA = SI.si(new AlternateUnit("T", WEBER.divide(METRE.pow(2))));
    public static final AlternateUnit<ElectricInductance> HENRY = SI.si(new AlternateUnit("H", WEBER.divide(AMPERE)));
    public static final Unit<Temperature> CELSIUS = SI.si(KELVIN.plus(273.15));
    public static final AlternateUnit<LuminousFlux> LUMEN = SI.si(new AlternateUnit("lm", CANDELA.times(STERADIAN)));
    public static final AlternateUnit<Illuminance> LUX = SI.si(new AlternateUnit("lx", LUMEN.divide(METRE.pow(2))));
    public static final AlternateUnit<RadioactiveActivity> BECQUEREL = SI.si(new AlternateUnit("Bq", Unit.ONE.divide(SECOND)));
    public static final AlternateUnit<RadiationDoseAbsorbed> GRAY = SI.si(new AlternateUnit("Gy", JOULE.divide(KILOGRAM)));
    public static final AlternateUnit<RadiationDoseEffective> SIEVERT = SI.si(new AlternateUnit("Sv", JOULE.divide(KILOGRAM)));
    public static final AlternateUnit<CatalyticActivity> KATAL = SI.si(new AlternateUnit("kat", MOLE.divide(SECOND)));
    public static final Unit<Velocity> METRES_PER_SECOND = SI.si(new ProductUnit(METRE.divide(SECOND)));
    public static final Unit<Velocity> METERS_PER_SECOND = METRES_PER_SECOND;
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = SI.si(new ProductUnit(METRES_PER_SECOND.divide(SECOND)));
    public static final Unit<Acceleration> METERS_PER_SQUARE_SECOND = METRES_PER_SQUARE_SECOND;
    public static final Unit<Area> SQUARE_METRE = SI.si(new ProductUnit(METRE.times(METRE)));
    public static final Unit<Area> SQUARE_METER = SQUARE_METRE;
    public static final Unit<Volume> CUBIC_METRE = SI.si(new ProductUnit(SQUARE_METRE.times(METRE)));
    public static final Unit<Volume> CUBIC_METER = CUBIC_METRE;
    public static final Unit<Length> KILOMETRE = METER.times(1000L);
    public static final Unit<Length> KILOMETER = KILOMETRE;
    public static final Unit<Length> CENTIMETRE = METRE.divide(100L);
    public static final Unit<Length> CENTIMETER = CENTIMETRE;
    public static final Unit<Length> MILLIMETRE = METRE.divide(1000L);
    public static final Unit<Length> MILLIMETER = MILLIMETRE;
    static final RationalConverter E24 = new RationalConverter(BigInteger.TEN.pow(24), BigInteger.ONE);
    static final RationalConverter E21 = new RationalConverter(BigInteger.TEN.pow(21), BigInteger.ONE);
    static final RationalConverter E18 = new RationalConverter(BigInteger.TEN.pow(18), BigInteger.ONE);
    static final RationalConverter E15 = new RationalConverter(BigInteger.TEN.pow(15), BigInteger.ONE);
    static final RationalConverter E12 = new RationalConverter(BigInteger.TEN.pow(12), BigInteger.ONE);
    static final RationalConverter E9 = new RationalConverter(BigInteger.TEN.pow(9), BigInteger.ONE);
    static final RationalConverter E6 = new RationalConverter(BigInteger.TEN.pow(6), BigInteger.ONE);
    static final RationalConverter E3 = new RationalConverter(BigInteger.TEN.pow(3), BigInteger.ONE);
    static final RationalConverter E2 = new RationalConverter(BigInteger.TEN.pow(2), BigInteger.ONE);
    static final RationalConverter E1 = new RationalConverter(BigInteger.TEN.pow(1), BigInteger.ONE);
    static final RationalConverter Em1 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(1));
    static final RationalConverter Em2 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(2));
    static final RationalConverter Em3 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(3));
    static final RationalConverter Em6 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(6));
    static final RationalConverter Em9 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(9));
    static final RationalConverter Em12 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(12));
    static final RationalConverter Em15 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(15));
    static final RationalConverter Em18 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(18));
    static final RationalConverter Em21 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(21));
    static final RationalConverter Em24 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(24));

    private SI() {
    }

    public static SI getInstance() {
        return INSTANCE;
    }

    public static <Q extends Quantity> Unit<Q> YOTTA(Unit<Q> unit) {
        return unit.transform(E24);
    }

    public static <Q extends Quantity> Unit<Q> ZETTA(Unit<Q> unit) {
        return unit.transform(E21);
    }

    public static <Q extends Quantity> Unit<Q> EXA(Unit<Q> unit) {
        return unit.transform(E18);
    }

    public static <Q extends Quantity> Unit<Q> PETA(Unit<Q> unit) {
        return unit.transform(E15);
    }

    public static <Q extends Quantity> Unit<Q> TERA(Unit<Q> unit) {
        return unit.transform(E12);
    }

    public static <Q extends Quantity> Unit<Q> GIGA(Unit<Q> unit) {
        return unit.transform(E9);
    }

    public static <Q extends Quantity> Unit<Q> MEGA(Unit<Q> unit) {
        return unit.transform(E6);
    }

    public static <Q extends Quantity> Unit<Q> KILO(Unit<Q> unit) {
        return unit.transform(E3);
    }

    public static <Q extends Quantity> Unit<Q> HECTO(Unit<Q> unit) {
        return unit.transform(E2);
    }

    public static <Q extends Quantity> Unit<Q> DEKA(Unit<Q> unit) {
        return unit.transform(E1);
    }

    public static <Q extends Quantity> Unit<Q> DECI(Unit<Q> unit) {
        return unit.transform(Em1);
    }

    public static <Q extends Quantity> Unit<Q> CENTI(Unit<Q> unit) {
        return unit.transform(Em2);
    }

    public static <Q extends Quantity> Unit<Q> MILLI(Unit<Q> unit) {
        return unit.transform(Em3);
    }

    public static <Q extends Quantity> Unit<Q> MICRO(Unit<Q> unit) {
        return unit.transform(Em6);
    }

    public static <Q extends Quantity> Unit<Q> NANO(Unit<Q> unit) {
        return unit.transform(Em9);
    }

    public static <Q extends Quantity> Unit<Q> PICO(Unit<Q> unit) {
        return unit.transform(Em12);
    }

    public static <Q extends Quantity> Unit<Q> FEMTO(Unit<Q> unit) {
        return unit.transform(Em15);
    }

    public static <Q extends Quantity> Unit<Q> ATTO(Unit<Q> unit) {
        return unit.transform(Em18);
    }

    public static <Q extends Quantity> Unit<Q> ZEPTO(Unit<Q> unit) {
        return unit.transform(Em21);
    }

    public static <Q extends Quantity> Unit<Q> YOCTO(Unit<Q> unit) {
        return unit.transform(Em24);
    }

    @Override
    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(UNITS);
    }

    private static <U extends Unit<?>> U si(U unit) {
        UNITS.add(unit);
        return unit;
    }
}

