/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.measure.converter.AddConverter;
import javax.measure.converter.ConversionException;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Dimension;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.TransformedUnit;
import javax.measure.unit.UnitFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Unit<Q extends Quantity>
implements Serializable {
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    static final HashMap<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    Unit() {
    }

    public abstract Unit<Q> toSI();

    public abstract UnitConverter getConverterToSI();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean isSI() {
        return this.toSI().equals(this);
    }

    public final boolean isCompatible(Unit that) {
        return this == that || this.toSI().equals(that.toSI()) || this.getDimension().equals(that.getDimension());
    }

    public final <T extends Quantity> Unit<T> asType(Class<T> type) throws ClassCastException {
        Dimension dim1 = this.getDimension();
        Unit u = null;
        try {
            u = (Unit)type.getField("UNIT").get(null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("The quantity class " + type + " does not have a public static field UNIT holding the SI unit " + " for the quantity.");
        }
        Dimension dim2 = u.getDimension();
        if (!dim1.equals(dim2)) {
            throw new ClassCastException("Dimension of " + this + " is " + dim1 + ", but the dimension of quantity of type " + type.getName() + " is " + dim2);
        }
        return this;
    }

    public final Dimension getDimension() {
        Unit<Q> systemUnit = this.toSI();
        if (systemUnit instanceof BaseUnit) {
            return Dimension.getModel().getDimension((BaseUnit)systemUnit);
        }
        if (systemUnit instanceof AlternateUnit) {
            return ((AlternateUnit)systemUnit).getParent().getDimension();
        }
        ProductUnit productUnit = (ProductUnit)systemUnit;
        Dimension dimension = Dimension.NONE;
        int i = 0;
        while (i < productUnit.getUnitCount()) {
            Unit<Quantity> unit = productUnit.getUnit(i);
            Dimension d = unit.getDimension().pow(productUnit.getUnitPow(i)).root(productUnit.getUnitRoot(i));
            dimension = dimension.times(d);
            ++i;
        }
        return dimension;
    }

    public final UnitConverter getConverterTo(Unit<Q> that) throws ConversionException {
        return this == that || this.equals(that) ? UnitConverter.IDENTITY : this.searchConverterTo(that);
    }

    private UnitConverter searchConverterTo(Unit that) throws ConversionException {
        Unit<Q> thatSystemUnit;
        Unit<Q> thisSystemUnit = this.toSI();
        if (thisSystemUnit.equals(thatSystemUnit = that.toSI())) {
            return that.getConverterToSI().inverse().concatenate(this.getConverterToSI());
        }
        if (!thisSystemUnit.getDimension().equals(thatSystemUnit.getDimension())) {
            throw new ConversionException(this + " is not compatible with " + that);
        }
        UnitConverter thisTransform = this.getConverterToSI().concatenate(Unit.transformOf(this.toBaseUnits()));
        UnitConverter thatTransform = that.getConverterToSI().concatenate(Unit.transformOf(that.toBaseUnits()));
        return thatTransform.inverse().concatenate(thisTransform);
    }

    private Unit<?> toBaseUnits() {
        Unit<Q> systemUnit = this.toSI();
        if (systemUnit instanceof BaseUnit) {
            return systemUnit;
        }
        if (systemUnit instanceof AlternateUnit) {
            return super.toBaseUnits();
        }
        if (systemUnit instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)systemUnit;
            Unit<Quantity> baseUnits = ONE;
            int i = 0;
            while (i < productUnit.getUnitCount()) {
                Unit<Object> unit = super.toBaseUnits();
                unit = unit.pow(productUnit.getUnitPow(i));
                unit = unit.root(productUnit.getUnitRoot(i));
                baseUnits = baseUnits.times(unit);
                ++i;
            }
            return baseUnits;
        }
        throw new InternalError("System Unit cannot be an instance of " + this.getClass());
    }

    private static UnitConverter transformOf(Unit baseUnits) {
        if (baseUnits instanceof BaseUnit) {
            return Dimension.getModel().getTransform((BaseUnit)baseUnits);
        }
        ProductUnit productUnit = (ProductUnit)baseUnits;
        UnitConverter converter = UnitConverter.IDENTITY;
        int i = 0;
        while (i < productUnit.getUnitCount()) {
            Unit<Quantity> unit = productUnit.getUnit(i);
            UnitConverter cvtr = Unit.transformOf(unit);
            if (!(cvtr instanceof LinearConverter)) {
                throw new ConversionException(baseUnits + " is non-linear, cannot convert");
            }
            if (productUnit.getUnitRoot(i) != 1) {
                throw new ConversionException(productUnit + " holds a base unit with fractional exponent");
            }
            int pow = productUnit.getUnitPow(i);
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            int j = 0;
            while (j < pow) {
                converter = converter.concatenate(cvtr);
                ++j;
            }
            ++i;
        }
        return converter;
    }

    public final <A extends Quantity> AlternateUnit<A> alternate(String symbol) {
        return new AlternateUnit(symbol, this);
    }

    public final CompoundUnit<Q> compound(Unit<Q> subunit) {
        return new CompoundUnit<Q>(this, subunit);
    }

    public final Unit<Q> transform(UnitConverter operation) {
        if (this instanceof TransformedUnit) {
            TransformedUnit tf = (TransformedUnit)this;
            Unit parent = tf.getParentUnit();
            UnitConverter toParent = tf.toParentUnit().concatenate(operation);
            if (toParent == UnitConverter.IDENTITY) {
                return parent;
            }
            return new TransformedUnit(parent, toParent);
        }
        if (operation == UnitConverter.IDENTITY) {
            return this;
        }
        return new TransformedUnit(this, operation);
    }

    public final Unit<Q> plus(double offset) {
        return this.transform(new AddConverter(BigDecimal.valueOf(offset)));
    }

    public final Unit<Q> times(long factor) {
        return this.transform(new RationalConverter(factor, 1L));
    }

    public final Unit<Q> times(double factor) {
        return this.transform(new MultiplyConverter(BigDecimal.valueOf(factor)));
    }

    public final Unit<? extends Quantity> times(Unit that) {
        return ProductUnit.getProductInstance(this, that);
    }

    public final Unit<? extends Quantity> inverse() {
        return ProductUnit.getQuotientInstance(ONE, this);
    }

    public final Unit<Q> divide(long divisor) {
        return this.transform(new RationalConverter(1L, divisor));
    }

    public final Unit<Q> divide(double divisor) {
        return this.transform(new MultiplyConverter(BigDecimal.valueOf(1.0 / divisor)));
    }

    public final Unit<? extends Quantity> divide(Unit that) {
        return this.times(that.inverse());
    }

    public final Unit<? extends Quantity> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit<? extends Quantity> pow(int n) {
        if (n > 0) {
            return this.times(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public static Unit valueOf(CharSequence csq) {
        return UnitFormat.getStandard().parse(csq, new ParsePosition(0));
    }

    public static <Q extends Quantity> Unit<Q> valueOf(CharSequence csq, Class<Q> type) {
        return Unit.valueOf(csq).asType(type);
    }

    public String toString() {
        return UnitFormat.getStandard().format(this);
    }
}

