/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit.format;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Action;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.DataAmount;
import javax.measure.quantity.DataRate;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.quantity.DynamicViscosity;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPermittivity;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.IonizingRadiation;
import javax.measure.quantity.KinematicViscosity;
import javax.measure.quantity.Length;
import javax.measure.quantity.Luminance;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFieldStrength;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.MagneticPermeability;
import javax.measure.quantity.MagnetomotiveForce;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.RadioactiveActivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Velocity;
import javax.measure.quantity.Volume;
import javax.measure.quantity.Wavenumber;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.SystemOfUnits;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UCUM
extends SystemOfUnits {
    private static HashSet<Unit<?>> UNITS = new HashSet();
    private static final UCUM INSTANCE = new UCUM();
    public static final BaseUnit<Length> METER = UCUM.ucum(SI.METRE);
    public static final BaseUnit<Duration> SECOND = UCUM.ucum(SI.SECOND);
    public static final Unit<Mass> GRAM = UCUM.ucum(SI.GRAM);
    public static final AlternateUnit<Angle> RADIAN = UCUM.ucum(SI.RADIAN);
    public static final BaseUnit<Temperature> KELVIN = UCUM.ucum(SI.KELVIN);
    public static final AlternateUnit<ElectricCharge> COULOMB = UCUM.ucum(SI.COULOMB);
    public static final BaseUnit<LuminousIntensity> CANDELA = UCUM.ucum(SI.CANDELA);
    public static final Unit<Dimensionless> TRIILLIONS = UCUM.ucum(Unit.ONE.times(1000000000000L));
    public static final Unit<Dimensionless> BILLIONS = UCUM.ucum(Unit.ONE.times(1000000000L));
    public static final Unit<Dimensionless> MILLIONS = UCUM.ucum(Unit.ONE.times(1000000L));
    public static final Unit<Dimensionless> THOUSANDS = UCUM.ucum(Unit.ONE.times(1000L));
    public static final Unit<Dimensionless> HUNDREDS = UCUM.ucum(Unit.ONE.times(100L));
    public static final Unit<Dimensionless> PI = UCUM.ucum(Unit.ONE.times(Math.PI));
    public static final Unit<Dimensionless> PERCENT = UCUM.ucum(Unit.ONE.divide(100L));
    public static final Unit<Dimensionless> PER_THOUSAND = UCUM.ucum(Unit.ONE.divide(1000L));
    public static final Unit<Dimensionless> PER_MILLION = UCUM.ucum(Unit.ONE.divide(1000000L));
    public static final Unit<Dimensionless> PER_BILLION = UCUM.ucum(Unit.ONE.divide(1000000000L));
    public static final Unit<Dimensionless> PER_TRILLION = UCUM.ucum(Unit.ONE.divide(1000000000000L));
    public static final Unit<AmountOfSubstance> MOLE = UCUM.ucum(SI.MOLE);
    public static final Unit<SolidAngle> STERADIAN = UCUM.ucum(SI.STERADIAN);
    public static final Unit<Frequency> HERTZ = UCUM.ucum(Unit.ONE.divide(SECOND));
    public static final Unit<Force> NEWTON = UCUM.ucum(SI.NEWTON);
    public static final Unit<Pressure> PASCAL = UCUM.ucum(SI.PASCAL);
    public static final Unit<Energy> JOULE = UCUM.ucum(SI.JOULE);
    public static final Unit<Power> WATT = UCUM.ucum(SI.WATT);
    public static final Unit<ElectricCurrent> AMPERE = UCUM.ucum(SI.AMPERE);
    public static final Unit<ElectricPotential> VOLT = UCUM.ucum(SI.VOLT);
    public static final Unit<ElectricCapacitance> FARAD = UCUM.ucum(SI.FARAD);
    public static final Unit<ElectricResistance> OHM = UCUM.ucum(SI.OHM);
    public static final Unit<ElectricConductance> SIEMENS = UCUM.ucum(SI.SIEMENS);
    public static final Unit<MagneticFlux> WEBER = UCUM.ucum(SI.WEBER);
    public static final Unit<Temperature> CELSIUS = UCUM.ucum(SI.CELSIUS);
    public static final Unit<MagneticFluxDensity> TESLA = UCUM.ucum(SI.TESLA);
    public static final Unit<ElectricInductance> HENRY = UCUM.ucum(SI.HENRY);
    public static final Unit<LuminousFlux> LUMEN = UCUM.ucum(SI.LUMEN);
    public static final Unit<Illuminance> LUX = UCUM.ucum(SI.LUX);
    public static final Unit<RadioactiveActivity> BECQUEREL = UCUM.ucum(SI.BECQUEREL);
    public static final Unit<RadiationDoseAbsorbed> GRAY = UCUM.ucum(SI.GRAY);
    public static final Unit<RadiationDoseEffective> SIEVERT = UCUM.ucum(SI.SIEVERT);
    public static final Unit<Angle> DEGREE = UCUM.ucum(NonSI.DEGREE_ANGLE);
    public static final Unit<Angle> GRADE = UCUM.ucum(NonSI.GRADE);
    public static final Unit<Angle> GON = GRADE;
    public static final Unit<Angle> MINUTE_ANGLE = UCUM.ucum(NonSI.MINUTE_ANGLE);
    public static final Unit<Angle> SECOND_ANGLE = UCUM.ucum(NonSI.SECOND_ANGLE);
    public static final Unit<Volume> LITER = UCUM.ucum(NonSI.LITRE);
    public static final Unit<Area> ARE = UCUM.ucum(NonSI.ARE);
    public static final Unit<Duration> MINUTE = UCUM.ucum(NonSI.MINUTE);
    public static final Unit<Duration> HOUR = UCUM.ucum(NonSI.HOUR);
    public static final Unit<Duration> DAY = UCUM.ucum(NonSI.DAY);
    public static final Unit<Duration> YEAR_TROPICAL = UCUM.ucum(DAY.times(365.24219));
    public static final Unit<Duration> YEAR_JULIAN = UCUM.ucum(DAY.times(365.25));
    public static final Unit<Duration> YEAR_GREGORIAN = UCUM.ucum(DAY.times(365.2425));
    public static final Unit<Duration> YEAR = UCUM.ucum(DAY.times(365.25));
    public static final Unit<Duration> MONTH_SYNODAL = UCUM.ucum(DAY.times(29.53059));
    public static final Unit<Duration> MONTH_JULIAN = UCUM.ucum(YEAR_JULIAN.divide(12L));
    public static final Unit<Duration> MONTH_GREGORIAN = UCUM.ucum(YEAR_GREGORIAN.divide(12L));
    public static final Unit<Duration> MONTH = UCUM.ucum(YEAR_JULIAN.divide(12L));
    public static final Unit<Mass> TONNE = UCUM.ucum(NonSI.METRIC_TON);
    public static final Unit<Pressure> BAR = UCUM.ucum(NonSI.BAR);
    public static final Unit<Mass> ATOMIC_MASS_UNIT = UCUM.ucum(NonSI.ATOMIC_MASS);
    public static final Unit<Energy> ELECTRON_VOLT = UCUM.ucum(NonSI.ELECTRON_VOLT);
    public static final Unit<Length> ASTRONOMIC_UNIT = UCUM.ucum(NonSI.ASTRONOMICAL_UNIT);
    public static final Unit<Length> PARSEC = UCUM.ucum(NonSI.PARSEC);
    public static final Unit<Velocity> C = UCUM.ucum(NonSI.C);
    public static final Unit<Action> PLANCK = UCUM.ucum(JOULE.times(SECOND).times(6.6260755E-24));
    public static final Unit<Dimensionless> BOLTZMAN = UCUM.ucum(JOULE.divide(KELVIN).times(1.380658E-23));
    public static final Unit<ElectricPermittivity> PERMITTIVITY_OF_VACUUM = UCUM.ucum(FARAD.divide(METER).times(8.854187817E-12));
    public static final Unit<MagneticPermeability> PERMEABILITY_OF_VACUUM = UCUM.ucum(NEWTON.times(1.2566370614359173E-6).divide(AMPERE.pow(2)));
    public static final Unit<ElectricCharge> ELEMENTARY_CHARGE = UCUM.ucum(NonSI.E);
    public static final Unit<Mass> ELECTRON_MASS = UCUM.ucum(NonSI.ELECTRON_MASS);
    public static final Unit<Mass> PROTON_MASS = UCUM.ucum(GRAM.times(1.6726231E-24));
    public static final Unit<Dimensionless> NEWTON_CONSTANT_OF_GRAVITY = UCUM.ucum(METER.pow(3).times(SI.KILOGRAM.pow(-1)).times(SECOND.pow(-2)).times(6.67259E-11));
    public static final Unit<Acceleration> ACCELLERATION_OF_FREEFALL = UCUM.ucum(NonSI.G);
    public static final Unit<Pressure> ATMOSPHERE = UCUM.ucum(NonSI.ATMOSPHERE);
    public static final Unit<Length> LIGHT_YEAR = UCUM.ucum(NonSI.LIGHT_YEAR);
    public static final Unit<Force> GRAM_FORCE = UCUM.ucum(GRAM.times(ACCELLERATION_OF_FREEFALL));
    public static final Unit<Wavenumber> KAYSER = UCUM.ucum(Unit.ONE.divide(SI.CENTI(METER)));
    public static final Unit<Acceleration> GAL = UCUM.ucum(SI.CENTI(METER).divide(SECOND.pow(2)));
    public static final Unit<Force> DYNE = UCUM.ucum(NonSI.DYNE);
    public static final Unit<Energy> ERG = UCUM.ucum(NonSI.ERG);
    public static final Unit<DynamicViscosity> POISE = UCUM.ucum(NonSI.POISE);
    public static final Unit<ElectricCurrent> BIOT = UCUM.ucum(AMPERE.times(10L));
    public static final Unit<KinematicViscosity> STOKES = UCUM.ucum(NonSI.STOKE);
    public static final Unit<MagneticFlux> MAXWELL = UCUM.ucum(NonSI.MAXWELL);
    public static final Unit<MagneticFluxDensity> GAUSS = UCUM.ucum(NonSI.GAUSS);
    public static final Unit<MagneticFieldStrength> OERSTED = UCUM.ucum(Unit.ONE.divide(PI).times(AMPERE).divide(METER).times(250L));
    public static final Unit<MagnetomotiveForce> GILBERT = UCUM.ucum(OERSTED.times(SI.CENTI(METER)));
    public static final Unit<Luminance> STILB = UCUM.ucum(CANDELA.divide(SI.CENTI(METER).pow(2)));
    public static final Unit<Illuminance> LAMBERT = UCUM.ucum(NonSI.LAMBERT);
    public static final Unit<Illuminance> PHOT = UCUM.ucum(LUX.divide(10000L));
    public static final Unit<RadioactiveActivity> CURIE = UCUM.ucum(NonSI.CURIE);
    public static final Unit<IonizingRadiation> ROENTGEN = UCUM.ucum(NonSI.ROENTGEN);
    public static final Unit<RadiationDoseAbsorbed> RAD = UCUM.ucum(NonSI.RAD);
    public static final Unit<RadiationDoseEffective> REM = UCUM.ucum(NonSI.REM);
    public static final Unit<Length> INCH_INTERNATIONAL = UCUM.ucum(SI.CENTI(METER).times(254L).divide(100L));
    public static final Unit<Length> FOOT_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.times(12L));
    public static final Unit<Length> YARD_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.times(3L));
    public static final Unit<Length> MILE_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.times(5280L));
    public static final Unit<Length> FATHOM_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.times(6L));
    public static final Unit<Length> NAUTICAL_MILE_INTERNATIONAL = UCUM.ucum(METER.times(1852L));
    public static final Unit<Velocity> KNOT_INTERNATIONAL = UCUM.ucum(NAUTICAL_MILE_INTERNATIONAL.divide(HOUR));
    public static final Unit<Area> SQUARE_INCH_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.pow(2));
    public static final Unit<Area> SQUARE_FOOT_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.pow(2));
    public static final Unit<Area> SQUARE_YARD_INTERNATIONAL = UCUM.ucum(YARD_INTERNATIONAL.pow(2));
    public static final Unit<Volume> CUBIC_INCH_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.pow(3));
    public static final Unit<Volume> CUBIC_FOOT_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.pow(3));
    public static final Unit<Volume> CUBIC_YARD_INTERNATIONAL = UCUM.ucum(YARD_INTERNATIONAL.pow(3));
    public static final Unit<Volume> BOARD_FOOT_INTERNATIONAL = UCUM.ucum(CUBIC_INCH_INTERNATIONAL.times(144L));
    public static final Unit<Volume> CORD_INTERNATIONAL = UCUM.ucum(CUBIC_FOOT_INTERNATIONAL.times(128L));
    public static final Unit<Length> MIL_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.divide(1000L));
    public static final Unit<Area> CIRCULAR_MIL_INTERNATIONAL = UCUM.ucum(MIL_INTERNATIONAL.times(PI).divide(4L));
    public static final Unit<Length> HAND_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.times(4L));
    public static final Unit<Length> FOOT_US_SURVEY = UCUM.ucum(METER.times(1200L).divide(3937L));
    public static final Unit<Length> YARD_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.times(3L));
    public static final Unit<Length> INCH_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.divide(12L));
    public static final Unit<Length> ROD_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.times(33L).divide(2L));
    public static final Unit<Length> CHAIN_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.times(4L));
    public static final Unit<Length> LINK_US_SURVEY = UCUM.ucum(CHAIN_US_SURVEY.divide(100L));
    public static final Unit<Length> RAMDEN_CHAIN_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.times(100L));
    public static final Unit<Length> RAMDEN_LINK_US_SURVEY = UCUM.ucum(CHAIN_US_SURVEY.divide(100L));
    public static final Unit<Length> FATHOM_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.times(6L));
    public static final Unit<Length> FURLONG_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.times(40L));
    public static final Unit<Length> MILE_US_SURVEY = UCUM.ucum(FURLONG_US_SURVEY.times(8L));
    public static final Unit<Area> ACRE_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.pow(2).times(160L));
    public static final Unit<Area> SQUARE_ROD_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.pow(2));
    public static final Unit<Area> SQUARE_MILE_US_SURVEY = UCUM.ucum(MILE_US_SURVEY.pow(2));
    public static final Unit<Area> SECTION_US_SURVEY = UCUM.ucum(MILE_US_SURVEY.pow(2));
    public static final Unit<Area> TOWNSHP_US_SURVEY = UCUM.ucum(SECTION_US_SURVEY.times(36L));
    public static final Unit<Length> MIL_US_SURVEY = UCUM.ucum(INCH_US_SURVEY.divide(1000L));
    public static final Unit<Length> INCH_BRITISH = UCUM.ucum(SI.CENTI(METER).times(2539998L).divide(1000000L));
    public static final Unit<Length> FOOT_BRITISH = UCUM.ucum(INCH_BRITISH.times(12L));
    public static final Unit<Length> ROD_BRITISH = UCUM.ucum(FOOT_BRITISH.times(33L).divide(2L));
    public static final Unit<Length> CHAIN_BRITISH = UCUM.ucum(ROD_BRITISH.times(4L));
    public static final Unit<Length> LINK_BRITISH = UCUM.ucum(CHAIN_BRITISH.divide(100L));
    public static final Unit<Length> FATHOM_BRITISH = UCUM.ucum(FOOT_BRITISH.times(6L));
    public static final Unit<Length> PACE_BRITISH = UCUM.ucum(FOOT_BRITISH.times(5L).divide(20L));
    public static final Unit<Length> YARD_BRITISH = UCUM.ucum(FOOT_BRITISH.times(3L));
    public static final Unit<Length> MILE_BRITISH = UCUM.ucum(FOOT_BRITISH.times(5280L));
    public static final Unit<Length> NAUTICAL_MILE_BRITISH = UCUM.ucum(FOOT_BRITISH.times(6080L));
    public static final Unit<Length> KNOT_BRITISH = UCUM.ucum(NAUTICAL_MILE_BRITISH.divide(HOUR));
    public static final Unit<Area> ACRE_BRITISH = UCUM.ucum(YARD_BRITISH.pow(2).times(4840L));
    public static final Unit<Volume> GALLON_US = UCUM.ucum(CUBIC_INCH_INTERNATIONAL.times(231L));
    public static final Unit<Volume> BARREL_US = UCUM.ucum(GALLON_US.times(42L));
    public static final Unit<Volume> QUART_US = UCUM.ucum(GALLON_US.divide(4L));
    public static final Unit<Volume> PINT_US = UCUM.ucum(QUART_US.divide(2L));
    public static final Unit<Volume> GILL_US = UCUM.ucum(PINT_US.divide(4L));
    public static final Unit<Volume> FLUID_OUNCE_US = UCUM.ucum(GILL_US.divide(4L));
    public static final Unit<Volume> FLUID_DRAM_US = UCUM.ucum(FLUID_OUNCE_US.divide(8L));
    public static final Unit<Volume> MINIM_US = UCUM.ucum(FLUID_DRAM_US.divide(60L));
    public static final Unit<Volume> CORD_US = UCUM.ucum(CUBIC_FOOT_INTERNATIONAL.times(128L));
    public static final Unit<Volume> BUSHEL_US = UCUM.ucum(CUBIC_INCH_INTERNATIONAL.times(215042L).divide(100L));
    public static final Unit<Volume> GALLON_WINCHESTER = UCUM.ucum(BUSHEL_US.divide(8L));
    public static final Unit<Volume> PECK_US = UCUM.ucum(BUSHEL_US.divide(4L));
    public static final Unit<Volume> DRY_QUART_US = UCUM.ucum(PECK_US.divide(8L));
    public static final Unit<Volume> DRY_PINT_US = UCUM.ucum(DRY_QUART_US.divide(2L));
    public static final Unit<Volume> TABLESPOON_US = UCUM.ucum(FLUID_OUNCE_US.divide(2L));
    public static final Unit<Volume> TEASPOON_US = UCUM.ucum(TABLESPOON_US.divide(3L));
    public static final Unit<Volume> CUP_US = UCUM.ucum(TABLESPOON_US.times(16L));
    public static final Unit<Volume> GALLON_BRITISH = UCUM.ucum(LITER.times(454609L).divide(100000L));
    public static final Unit<Volume> PECK_BRITISH = UCUM.ucum(GALLON_BRITISH.times(2L));
    public static final Unit<Volume> BUSHEL_BRITISH = UCUM.ucum(PECK_BRITISH.times(4L));
    public static final Unit<Volume> QUART_BRITISH = UCUM.ucum(GALLON_BRITISH.divide(4L));
    public static final Unit<Volume> PINT_BRITISH = UCUM.ucum(QUART_BRITISH.divide(2L));
    public static final Unit<Volume> GILL_BRITISH = UCUM.ucum(PINT_BRITISH.divide(4L));
    public static final Unit<Volume> FLUID_OUNCE_BRITISH = UCUM.ucum(GILL_BRITISH.divide(5L));
    public static final Unit<Volume> FLUID_DRAM_BRITISH = UCUM.ucum(FLUID_OUNCE_BRITISH.divide(8L));
    public static final Unit<Volume> MINIM_BRITISH = UCUM.ucum(FLUID_DRAM_BRITISH.divide(60L));
    public static final Unit<Mass> GRAIN = UCUM.ucum(SI.MILLI(GRAM).times(6479891L).divide(100000L));
    public static final Unit<Mass> POUND = UCUM.ucum(GRAM.times(7000L));
    public static final Unit<Mass> OUNCE = UCUM.ucum(POUND.divide(16L));
    public static final Unit<Mass> DRAM = UCUM.ucum(OUNCE.divide(16L));
    public static final Unit<Mass> SHORT_HUNDREDWEIGHT = UCUM.ucum(POUND.times(100L));
    public static final Unit<Mass> LONG_HUNDREDWEIGHT = UCUM.ucum(POUND.times(112L));
    public static final Unit<Mass> SHORT_TON = UCUM.ucum(SHORT_HUNDREDWEIGHT.times(20L));
    public static final Unit<Mass> LONG_TON = UCUM.ucum(LONG_HUNDREDWEIGHT.times(20L));
    public static final Unit<Mass> STONE = UCUM.ucum(POUND.times(14L));
    public static final Unit<Force> POUND_FORCE = UCUM.ucum(POUND.times(ACCELLERATION_OF_FREEFALL));
    public static final Unit<Mass> PENNYWEIGHT_TROY = UCUM.ucum(GRAIN.times(24L));
    public static final Unit<Mass> OUNCE_TROY = UCUM.ucum(PENNYWEIGHT_TROY.times(24L));
    public static final Unit<Mass> POUND_TROY = UCUM.ucum(OUNCE_TROY.times(12L));
    public static final Unit<Mass> SCRUPLE_APOTHECARY = UCUM.ucum(GRAIN.times(20L));
    public static final Unit<Mass> DRAM_APOTHECARY = UCUM.ucum(SCRUPLE_APOTHECARY.times(3L));
    public static final Unit<Mass> OUNCE_APOTHECARY = UCUM.ucum(DRAM_APOTHECARY.times(8L));
    public static final Unit<Mass> POUND_APOTHECARY = UCUM.ucum(OUNCE_APOTHECARY.times(12L));
    public static final Unit<Length> LINE = UCUM.ucum(INCH_INTERNATIONAL.divide(12L));
    public static final Unit<Length> POINT = UCUM.ucum(LINE.divide(6L));
    public static final Unit<Length> PICA = UCUM.ucum(POINT.times(12L));
    public static final Unit<Length> POINT_PRINTER = UCUM.ucum(INCH_INTERNATIONAL.times(13837L).divide(1000000L));
    public static final Unit<Length> PICA_PRINTER = UCUM.ucum(POINT_PRINTER.times(12L));
    public static final Unit<Length> PIED = UCUM.ucum(SI.CENTI(METER).times(3248L).divide(100L));
    public static final Unit<Length> POUCE = UCUM.ucum(PIED.divide(12L));
    public static final Unit<Length> LINGE = UCUM.ucum(POUCE.divide(12L));
    public static final Unit<Length> DIDOT = UCUM.ucum(LINGE.divide(6L));
    public static final Unit<Length> CICERO = UCUM.ucum(DIDOT.times(12L));
    public static final Unit<Temperature> FAHRENHEIT = UCUM.ucum(KELVIN.times(5L).divide(9L).plus(459.67));
    public static final Unit<Energy> CALORIE_AT_15C = UCUM.ucum(JOULE.times(41858L).divide(10000L));
    public static final Unit<Energy> CALORIE_AT_20C = UCUM.ucum(JOULE.times(41819L).divide(10000L));
    public static final Unit<Energy> CALORIE_MEAN = UCUM.ucum(JOULE.times(419002L).divide(100000L));
    public static final Unit<Energy> CALORIE_INTERNATIONAL_TABLE = UCUM.ucum(JOULE.times(41868L).divide(10000L));
    public static final Unit<Energy> CALORIE_THERMOCHEMICAL = UCUM.ucum(JOULE.times(4184L).divide(1000L));
    public static final Unit<Energy> CALORIE = UCUM.ucum(CALORIE_THERMOCHEMICAL);
    public static final Unit<Energy> CALORIE_FOOD = UCUM.ucum(SI.KILO(CALORIE_THERMOCHEMICAL));
    public static final Unit<Energy> BTU_AT_39F = UCUM.ucum(SI.KILO(JOULE).times(105967L).divide(100000L));
    public static final Unit<Energy> BTU_AT_59F = UCUM.ucum(SI.KILO(JOULE).times(105480L).divide(100000L));
    public static final Unit<Energy> BTU_AT_60F = UCUM.ucum(SI.KILO(JOULE).times(105468L).divide(100000L));
    public static final Unit<Energy> BTU_MEAN = UCUM.ucum(SI.KILO(JOULE).times(105587L).divide(100000L));
    public static final Unit<Energy> BTU_INTERNATIONAL_TABLE = UCUM.ucum(SI.KILO(JOULE).times(105505585262L).divide(100000000000L));
    public static final Unit<Energy> BTU_THERMOCHEMICAL = UCUM.ucum(SI.KILO(JOULE).times(105735L).divide(100000L));
    public static final Unit<Energy> BTU = UCUM.ucum(BTU_THERMOCHEMICAL);
    public static final Unit<Power> HORSEPOWER = UCUM.ucum(FOOT_INTERNATIONAL.times(POUND_FORCE).divide(SECOND));
    public static final Unit<Volume> STERE = UCUM.ucum(METER.pow(3));
    public static final Unit<Length> ANGSTROM = UCUM.ucum(SI.NANO(METER).divide(10L));
    public static final Unit<Area> BARN = UCUM.ucum(SI.FEMTO(METER).pow(2).times(100L));
    public static final Unit<Pressure> ATMOSPHERE_TECHNICAL = UCUM.ucum(SI.KILO(GRAM_FORCE).divide(SI.CENTI(METER).pow(2)));
    public static final Unit<ElectricConductance> MHO = UCUM.ucum(SIEMENS.alternate("mho").asType(ElectricConductance.class));
    public static final Unit<Pressure> POUND_PER_SQUARE_INCH = UCUM.ucum(POUND_FORCE.divide(INCH_INTERNATIONAL.pow(2)));
    public static final Unit<Pressure> CIRCLE = UCUM.ucum(PI.times(RADIAN).times(2L));
    public static final Unit<Pressure> SPHERE = UCUM.ucum(PI.times(STERADIAN).times(4L));
    public static final Unit<Mass> CARAT_METRIC = UCUM.ucum(GRAM.divide(5L));
    public static final Unit<Dimensionless> CARAT_GOLD = UCUM.ucum(Unit.ONE.divide(24L));
    public static final Unit<DataAmount> BIT = UCUM.ucum(SI.BIT);
    public static final Unit<DataAmount> BYTE = UCUM.ucum(NonSI.BYTE);
    public static final Unit<DataRate> BAUD = UCUM.ucum(Unit.ONE.divide(SECOND));

    public static UCUM getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U ucum(U unit) {
        UNITS.add(unit);
        return unit;
    }

    private UCUM() {
    }

    @Override
    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(UNITS);
    }
}

