/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit.format;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.measure.converter.LogConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.measure.unit.format.ParseException;
import javax.measure.unit.format.Prefix;
import javax.measure.unit.format.SimpleCharStream;
import javax.measure.unit.format.SymbolMap;
import javax.measure.unit.format.Token;
import javax.measure.unit.format.UnitParserConstants;
import javax.measure.unit.format.UnitParserTokenManager;

class UnitParser
implements UnitParserConstants {
    private SymbolMap _symbols;
    public UnitParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        UnitParser.jj_la1_0();
    }

    public UnitParser(SymbolMap symbols, Reader in) {
        this(in);
        this._symbols = symbols;
    }

    public final Unit parseUnit() throws ParseException {
        Unit result = this.CompoundExpr();
        this.jj_consume_token(0);
        return result;
    }

    public final Unit CompoundExpr() throws ParseException {
        Unit result = Unit.ONE;
        Unit temp = Unit.ONE;
        result = this.AddExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(11);
            temp = this.AddExpr();
            result = result.compound(temp);
        }
        return result;
    }

    public final Unit AddExpr() throws ParseException {
        Unit result = Unit.ONE;
        Number n1 = null;
        Token sign1 = null;
        Number n2 = null;
        Token sign2 = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            n1 = this.NumberExpr();
            sign1 = this.Sign();
        }
        result = this.MulExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: {
                sign2 = this.Sign();
                n2 = this.NumberExpr();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        if (n1 != null) {
            if (sign1.image.equals("-")) {
                result = result.times(-1L);
            }
            result = result.plus(n1.doubleValue());
        }
        if (n2 != null) {
            double offset = n2.doubleValue();
            if (sign2.image.equals("-")) {
                offset = -offset;
            }
            result = result.plus(offset);
        }
        return result;
    }

    public final Unit MulExpr() throws ParseException {
        Unit<Quantity> result;
        block12: {
            result = Unit.ONE;
            Unit temp = Unit.ONE;
            result = this.ExponentExpr();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.jj_consume_token(7);
                                break;
                            }
                            case 8: {
                                this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        temp = this.ExponentExpr();
                        result = result.times(temp);
                        continue block11;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        temp = this.ExponentExpr();
                        result = result.divide(temp);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final Unit ExponentExpr() throws ParseException {
        Unit<Quantity> result = Unit.ONE;
        Unit<Dimensionless> temp = Unit.ONE;
        Exponent exponent = null;
        Token token = null;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    token = this.jj_consume_token(14);
                    break;
                }
                case 19: {
                    token = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(10);
            result = this.AtomicExpr();
            double base = token.kind == 14 ? (double)Integer.parseInt(token.image) : Math.E;
            return result.transform(new LogConverter(base).inverse());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 14: 
            case 16: 
            case 20: {
                result = this.AtomicExpr();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 15: {
                        exponent = this.Exp();
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                if (exponent != null) {
                    if (exponent.pow != 1) {
                        result = result.pow(exponent.pow);
                    }
                    if (exponent.root != 1) {
                        result = result.root(exponent.root);
                    }
                }
                return result;
            }
            case 17: 
            case 18: {
                block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 14: {
                                token = this.jj_consume_token(14);
                                break block11;
                            }
                        }
                        this.jj_la1[7] = this.jj_gen;
                        break;
                    }
                    case 18: {
                        token = this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(12);
                result = this.AddExpr();
                this.jj_consume_token(13);
                double base = 10.0;
                if (token != null) {
                    if (token.kind == 14) {
                        base = Integer.parseInt(token.image);
                    } else if (token.kind == 18) {
                        base = Math.E;
                    }
                }
                return result.transform(new LogConverter(base));
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Unit AtomicExpr() throws ParseException {
        Unit result = Unit.ONE;
        Unit<Dimensionless> temp = Unit.ONE;
        Number n = null;
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 16: {
                n = this.NumberExpr();
                if (n instanceof Integer) {
                    return result.times(n.intValue());
                }
                return result.times(n.doubleValue());
            }
            case 20: {
                token = this.jj_consume_token(20);
                Unit unit = this._symbols.getUnit(token.image);
                if (unit == null) {
                    String prefixSymbol;
                    Prefix prefix = this._symbols.getPrefix(token.image);
                    if (prefix != null && (unit = this._symbols.getUnit(token.image.substring((prefixSymbol = this._symbols.getSymbol(prefix)).length()))) != null) {
                        return unit.transform(prefix.getConverter());
                    }
                    throw new ParseException();
                }
                return unit;
            }
            case 12: {
                this.jj_consume_token(12);
                result = this.AddExpr();
                this.jj_consume_token(13);
                return result;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token Sign() throws ParseException {
        Token result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                result = this.jj_consume_token(5);
                break;
            }
            case 6: {
                result = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Number NumberExpr() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                token = this.jj_consume_token(14);
                return Long.valueOf(token.image);
            }
            case 16: {
                token = this.jj_consume_token(16);
                return Double.valueOf(token.image);
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Exponent Exp() throws ParseException {
        Token powSign = null;
        Token powToken = null;
        Token rootSign = null;
        Token rootToken = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 14: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 6: {
                                powSign = this.Sign();
                                break;
                            }
                            default: {
                                this.jj_la1[13] = this.jj_gen;
                            }
                        }
                        powToken = this.jj_consume_token(14);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        return new Exponent(pow, 1);
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 6: {
                                powSign = this.Sign();
                                break;
                            }
                            default: {
                                this.jj_la1[14] = this.jj_gen;
                            }
                        }
                        powToken = this.jj_consume_token(14);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 9: {
                                this.jj_consume_token(9);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 5: 
                                    case 6: {
                                        rootSign = this.Sign();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[15] = this.jj_gen;
                                    }
                                }
                                rootToken = this.jj_consume_token(14);
                                break;
                            }
                            default: {
                                this.jj_la1[16] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(13);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        int root = 1;
                        if (rootToken != null) {
                            root = Integer.parseInt(rootToken.image);
                            if (rootSign != null && rootSign.image.equals("-")) {
                                root = -root;
                            }
                        }
                        return new Exponent(pow, root);
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 15: {
                powToken = this.jj_consume_token(15);
                int pow = 0;
                int i = 0;
                while (i < powToken.image.length()) {
                    pow *= 10;
                    switch (powToken.image.charAt(i)) {
                        case '\u00b9': {
                            ++pow;
                            break;
                        }
                        case '\u00b2': {
                            pow += 2;
                            break;
                        }
                        case '\u00b3': {
                            pow += 3;
                            break;
                        }
                        case '\u2074': {
                            pow += 4;
                            break;
                        }
                        case '\u2075': {
                            pow += 5;
                            break;
                        }
                        case '\u2076': {
                            pow += 6;
                            break;
                        }
                        case '\u2077': {
                            pow += 7;
                            break;
                        }
                        case '\u2078': {
                            pow += 8;
                            break;
                        }
                        case '\u2079': {
                            pow += 9;
                        }
                    }
                    ++i;
                }
                return new Exponent(pow, 1);
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_6()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_6() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return this.jj_scan_token(10);
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_3()) {
            return true;
        }
        return this.jj_3R_4();
    }

    private final boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_5() {
        return this.jj_scan_token(14);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{2048, 96, 896, 384, 896, 540672, 33792, 16384, 393216, 1527808, 0x115000, 96, 81920, 96, 96, 96, 512, 20576, 33792};
    }

    public UnitParser(InputStream stream) {
        this(stream, null);
    }

    public UnitParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new UnitParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 19) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 19) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public UnitParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new UnitParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 19) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 19) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public UnitParser(UnitParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 19) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(UnitParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 19) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[21];
        int i = 0;
        while (i < 21) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 19) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 21) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 2) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

