/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParsePosition;
import javax.measure.Measurable;
import javax.measure.MeasureFormat;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Measure<Q extends Quantity>
implements Measurable<Q>,
Serializable {
    private static final long serialVersionUID = -4993173119977931016L;

    protected Measure() {
    }

    public abstract Number getValue();

    public abstract Unit<Q> getUnit();

    public Measure<Q> toSI() {
        return this.to(this.getUnit().toSI());
    }

    public Measure<Q> to(Unit<Q> unit) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        return Measure.valueOf(this.doubleValue(unit), unit);
    }

    public Measure<Q> to(Unit<Q> unit, MathContext ctx) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        return Measure.valueOf(this.decimalValue(unit, ctx), unit);
    }

    @Override
    public int compareTo(Measurable<Q> that) {
        Unit<Q> unit = this.getUnit();
        return Double.compare(this.doubleValue(unit), that.doubleValue(unit));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Measure)) {
            return false;
        }
        Measure that = (Measure)obj;
        return this.getUnit().equals(that.getUnit()) && this.getValue().equals(that.getValue());
    }

    public boolean equals(Measurable<Q> that, double epsilon, Unit<Q> epsilonUnit) {
        return Math.abs(this.doubleValue(epsilonUnit) - that.doubleValue(epsilonUnit)) <= epsilon;
    }

    public int hashCode() {
        return this.getUnit().hashCode() + this.getValue().hashCode();
    }

    public final String toString() {
        return MeasureFormat.getStandard().format(this);
    }

    @Override
    public final int intValue(Unit<Q> unit) throws ArithmeticException {
        long longValue = this.longValue(unit);
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Cannot convert " + longValue + " to int (overflow)");
        }
        return (int)longValue;
    }

    @Override
    public long longValue(Unit<Q> unit) throws ArithmeticException {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public final float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    public final <T extends Quantity> Measure<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    public static Measure<?> valueOf(CharSequence csq) {
        return MeasureFormat.getStandard().parse(csq, new ParsePosition(0));
    }

    public static <Q extends Quantity> Measure<Q> valueOf(int intValue, Unit<Q> unit) {
        return new IntegerMeasure<Q>(intValue, unit);
    }

    public static <Q extends Quantity> Measure<Q> valueOf(long longValue, Unit<Q> unit) {
        return new LongMeasure<Q>(longValue, unit);
    }

    public static <Q extends Quantity> Measure<Q> valueOf(float floatValue, Unit<Q> unit) {
        return new FloatMeasure<Q>(floatValue, unit);
    }

    public static <Q extends Quantity> Measure<Q> valueOf(double doubleValue, Unit<Q> unit) {
        return new DoubleMeasure<Q>(doubleValue, unit);
    }

    public static <Q extends Quantity> Measure<Q> valueOf(BigDecimal decimalValue, Unit<Q> unit) {
        return new DecimalMeasure<Q>(decimalValue, unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DecimalMeasure<T extends Quantity>
    extends Measure<T> {
        private static final long serialVersionUID = 6504081836032983882L;
        BigDecimal _value;
        Unit<T> _unit;

        public DecimalMeasure(BigDecimal value, Unit<T> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public BigDecimal getValue() {
            return this._value;
        }

        @Override
        public Unit<T> getUnit() {
            return this._unit;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return this._unit.equals(unit) ? this._value.doubleValue() : this._unit.getConverterTo(unit).convert(this._value.doubleValue());
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            return this._unit.equals(unit) ? this._value : this._unit.getConverterTo(unit).convert(this._value, ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleMeasure<T extends Quantity>
    extends Measure<T> {
        double _value;
        Unit<T> _unit;
        private static final long serialVersionUID = 1L;

        public DoubleMeasure(double value, Unit<T> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Double getValue() {
            return this._value;
        }

        @Override
        public Unit<T> getUnit() {
            return this._unit;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return this._unit.equals(unit) ? this._value : this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this._value);
            return this._unit.equals(unit) ? decimal : this._unit.getConverterTo(unit).convert(decimal, ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatMeasure<T extends Quantity>
    extends Measure<T> {
        float _value;
        Unit<T> _unit;
        private static final long serialVersionUID = 1L;

        public FloatMeasure(float value, Unit<T> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this._value);
        }

        @Override
        public Unit<T> getUnit() {
            return this._unit;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return this._unit.equals(unit) ? (double)this._value : this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this._value);
            return this._unit.equals(unit) ? decimal : this._unit.getConverterTo(unit).convert(decimal, ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongMeasure<T extends Quantity>
    extends Measure<T> {
        private static final long serialVersionUID = -7465490977335120477L;
        long _value;
        Unit<T> _unit;

        public LongMeasure(long value, Unit<T> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Long getValue() {
            return this._value;
        }

        @Override
        public Unit<T> getUnit() {
            return this._unit;
        }

        @Override
        public long longValue(Unit<T> unit) {
            return this._unit.equals(unit) || this._unit.getConverterTo(unit) == UnitConverter.IDENTITY ? this._value : super.longValue(unit);
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return this._unit.equals(unit) ? (double)this._value : this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this._value);
            return this._unit.equals(unit) ? decimal : this._unit.getConverterTo(unit).convert(decimal, ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerMeasure<T extends Quantity>
    extends Measure<T> {
        private static final long serialVersionUID = 5355395476874521709L;
        int _value;
        Unit<T> _unit;

        public IntegerMeasure(int value, Unit<T> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        @Override
        public Unit<T> getUnit() {
            return this._unit;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return this._unit.equals(unit) ? (double)this._value : this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this._value);
            return this._unit.equals(unit) ? decimal : this._unit.getConverterTo(unit).convert(decimal, ctx);
        }
    }
}

