/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.ExpConverter;
import javax.measure.converter.UnitConverter;

public final class LogConverter
extends UnitConverter {
    private static final long serialVersionUID = -5581266460675123322L;
    private final double base;
    private final double logOfBase;

    public LogConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    public UnitConverter inverse() {
        return new ExpConverter(this.base);
    }

    public final String toString() {
        return "LogConverter(" + this.base + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogConverter)) {
            return false;
        }
        LogConverter that = (LogConverter)obj;
        return this.base == that.base;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.base);
        return (int)(bits ^ bits >>> 32);
    }

    public double convert(double amount) {
        return Math.log(amount) / this.logOfBase;
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public boolean isLinear() {
        return false;
    }
}

