/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;

public final class MultiplyConverter
extends UnitConverter {
    private static final long serialVersionUID = 6497743504427978825L;
    private final double factor;

    public MultiplyConverter(double factor) {
        if (factor == 1.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof MultiplyConverter) {
            double newfactor = this.factor * ((MultiplyConverter)converter).factor;
            return newfactor == 1.0 ? IDENTITY : new MultiplyConverter(newfactor);
        }
        return super.concatenate(converter);
    }

    public MultiplyConverter inverse() {
        return new MultiplyConverter(1.0 / this.factor);
    }

    public double convert(double value) {
        return value * this.factor;
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.multiply(BigDecimal.valueOf(this.factor), ctx);
    }

    public final String toString() {
        return "MultiplyConverter(" + this.factor + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiplyConverter)) {
            return false;
        }
        MultiplyConverter that = (MultiplyConverter)obj;
        return this.factor == that.factor;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.factor);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean isLinear() {
        return true;
    }
}

