/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit.format;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javax.measure.unit.format.Prefix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolMapImpl
implements UnitFormat.SymbolMap {
    private Map<String, Unit<?>> _symbolToUnit = new HashMap();
    private Map<Unit<?>, String> _unitToSymbol = new HashMap();
    private Map<String, Object> _symbolToPrefix = new HashMap<String, Object>();
    private Map<Object, String> _prefixToSymbol = new HashMap<Object, String>();
    private Map<UnitConverter, Prefix> _converterToPrefix = new HashMap<UnitConverter, Prefix>();

    public SymbolMapImpl() {
    }

    public SymbolMapImpl(ResourceBundle rb) {
        this();
        Enumeration<String> i = rb.getKeys();
        while (i.hasMoreElements()) {
            String fqn = i.nextElement();
            String symbol = rb.getString(fqn);
            boolean isAlias = false;
            int lastDot = fqn.lastIndexOf(46);
            String className = fqn.substring(0, lastDot);
            String fieldName = fqn.substring(lastDot + 1, fqn.length());
            if (Character.isDigit(fieldName.charAt(0))) {
                isAlias = true;
                fqn = className;
                lastDot = fqn.lastIndexOf(46);
                className = fqn.substring(0, lastDot);
                fieldName = fqn.substring(lastDot + 1, fqn.length());
            }
            try {
                Class<?> c = Class.forName(className);
                Field field = c.getField(fieldName);
                Object value = field.get(null);
                if (value instanceof Unit) {
                    if (isAlias) {
                        this.alias((Unit)value, symbol);
                        continue;
                    }
                    this.label((Unit)value, symbol);
                    continue;
                }
                if (value instanceof Prefix) {
                    this.label((Prefix)((Object)value), symbol);
                    continue;
                }
                throw new ClassCastException("unable to cast " + value + " to Unit or Prefix");
            }
            catch (Exception e) {
                System.err.println("ERROR reading Unit names: " + e.toString());
            }
        }
    }

    @Override
    public void label(Unit<?> unit, String symbol) {
        this._symbolToUnit.put(symbol, unit);
        this._unitToSymbol.put(unit, symbol);
    }

    @Override
    public void alias(Unit<?> unit, String symbol) {
        this._symbolToUnit.put(symbol, unit);
    }

    @Override
    public void prefix(UnitConverter cvtr, String symbol) {
        throw new UnsupportedOperationException("Prefixes are not modifiable");
    }

    @Override
    public Unit<?> getUnit(String symbol) {
        return this._symbolToUnit.get(symbol);
    }

    @Override
    public String getSymbol(Unit<?> unit) {
        return this._unitToSymbol.get(unit);
    }

    @Override
    public String getPrefix(UnitConverter cvtr) {
        Prefix prefix = this.getPrefixObject(cvtr);
        if (prefix == null) {
            return null;
        }
        return this._prefixToSymbol.get((Object)prefix);
    }

    @Override
    public UnitConverter getConverter(String prefix) {
        Prefix prefixObject = (Prefix)((Object)this._symbolToPrefix.get(prefix));
        if (prefixObject == null) {
            return null;
        }
        return prefixObject.getConverter();
    }

    void label(Prefix prefix, String symbol) {
        this._symbolToPrefix.put(symbol, (Object)prefix);
        this._prefixToSymbol.put((Object)prefix, symbol);
        this._converterToPrefix.put(prefix.getConverter(), prefix);
    }

    Prefix getPrefix(String symbol) {
        for (String pfSymbol : this._symbolToPrefix.keySet()) {
            if (!symbol.startsWith(pfSymbol)) continue;
            return (Prefix)((Object)this._symbolToPrefix.get(pfSymbol));
        }
        return null;
    }

    Prefix getPrefixObject(UnitConverter converter) {
        return this._converterToPrefix.get(converter);
    }

    String getSymbol(Prefix prefix) {
        return this._prefixToSymbol.get((Object)prefix);
    }
}

