/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

final class Bitmap
implements ImageConsumer {
    int width;
    int height;
    int bpp;
    byte[] pixels8;
    int[] pixels32;
    ColorModel colorModel;
    DisplayList display;
    private boolean loaded;
    private boolean grabbing;
    private int flags;
    private ImageProducer producer;
    private static int[][][] PixCoverage = new int[8][8][4];
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int RGBSlabChunkSize = 256;
    private static int[] pixBuf;
    private int n;
    private int[] ce = new int[4];

    Bitmap(ImageProducer ip, DisplayList display) {
        this.producer = ip;
        this.display = display;
        ip.startProduction(this);
        this.grabBits();
    }

    Bitmap(Image image, DisplayList display) {
        this(image.getSource(), display);
        image.flush();
    }

    Bitmap(int[] pixels32, int width, int height, DisplayList display) {
        this.pixels32 = pixels32;
        this.width = width;
        this.height = height;
        this.display = display;
        this.bpp = 32;
    }

    Bitmap(byte[] pixels8, int width, int height, DisplayList display) {
        this.pixels8 = pixels8;
        this.width = width;
        this.height = height;
        this.display = display;
        this.bpp = 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void grabBits() {
        int i222;
        this.grabbing = true;
        try {
            int i222;
            block9: {
                try {
                    while (this.grabbing && this.producer != null) {
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    this.pixels8 = null;
                    this.pixels32 = null;
                    this.height = 0;
                    this.width = 0;
                    this.loaded = false;
                    Object var3_2 = null;
                    this.grabbing = false;
                    this.producer = null;
                    if (!this.loaded) return;
                    if (this.pixels32 == null) return;
                    i222 = this.width * this.height;
                    break block9;
                }
                Object var3_1 = null;
                this.grabbing = false;
                this.producer = null;
                if (!this.loaded) return;
                if (this.pixels32 == null) return;
                int i222 = this.width * this.height;
                while (i222 > 0) {
                    int n2 = --i222;
                    this.pixels32[n2] = this.pixels32[n2] | 0xFF000000;
                }
                return;
            }
            while (i222 > 0) {
                int n3 = --i222;
                this.pixels32[n3] = this.pixels32[n3] | 0xFF000000;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.grabbing = false;
            this.producer = null;
            if (!this.loaded) throw throwable;
            if (this.pixels32 == null) throw throwable;
            i222 = this.width * this.height;
        }
        while (true) {
            if (i222 <= 0) {
                throw throwable;
            }
            int n4 = --i222;
            this.pixels32[n4] = this.pixels32[n4] | 0xFF000000;
        }
    }

    synchronized int status() {
        return this.flags;
    }

    public synchronized void imageComplete(int status) {
        this.loaded = status == 3;
        this.grabbing = false;
        switch (status) {
            default: {
                this.flags |= 0xC0;
                break;
            }
            case 4: {
                this.flags |= 0x80;
                break;
            }
            case 3: {
                this.flags |= 0x20;
                break;
            }
            case 2: {
                this.flags |= 0x10;
            }
        }
        if (this.producer != null) {
            this.producer.removeConsumer(this);
        }
        this.producer = null;
        this.notify();
    }

    public void setColorModel(ColorModel model) {
        this.colorModel = model;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHints(int hints) {
    }

    public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, byte[] pixels, int srcOff, int srcScan) {
        if (this.pixels8 == null) {
            this.pixels8 = new byte[this.width * this.height];
            this.bpp = 8;
        }
        System.arraycopy(pixels, srcOff, this.pixels8, this.width * srcY + srcX, srcScan);
    }

    public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, int[] pixels, int srcOff, int srcScan) {
        if (this.pixels32 == null) {
            this.pixels32 = new int[this.width * this.height];
            this.bpp = 32;
        }
        System.arraycopy(pixels, srcOff, this.pixels32, this.width * srcY + srcX, srcScan);
    }

    public void setProperties(Hashtable props) {
    }

    private static void buildCoverageTable() {
        int xf = 0;
        while (xf < 8) {
            int yf = 0;
            while (yf < 8) {
                Bitmap.PixCoverage[xf][yf][0] = (8 - xf) * (8 - yf);
                Bitmap.PixCoverage[xf][yf][1] = xf * (8 - yf);
                Bitmap.PixCoverage[xf][yf][2] = (8 - xf) * yf;
                Bitmap.PixCoverage[xf][yf][3] = xf * yf;
                int big = 0;
                int sum = 0;
                int j2 = 0;
                while (j2 <= 3) {
                    Bitmap.PixCoverage[xf][yf][j2] = (PixCoverage[xf][yf][j2] + 4) / 8;
                    sum += PixCoverage[xf][yf][j2];
                    if (PixCoverage[xf][yf][j2] > PixCoverage[xf][yf][big]) {
                        big = j2;
                    }
                    ++j2;
                }
                int err = 8 - sum;
                int[] nArray = PixCoverage[xf][yf];
                int n2 = big;
                nArray[n2] = nArray[n2] + err;
                ++yf;
            }
            ++xf;
        }
    }

    static int LimitAbs(int v, int range) {
        int i2 = v / range;
        if (v < 0) {
            --i2;
        }
        return v - i2 * range;
    }

    static int LimitAbsI(int v, int range) {
        int i2 = v / range;
        if (v < 0) {
            --i2;
        }
        return v - i2 * range;
    }

    private int CalcLimit(int x, int dx, int limit) {
        if (dx > 0) {
            while (x > limit) {
                x -= limit;
            }
            int lim = (limit - x + dx - 1) / dx;
            if (this.n > lim) {
                this.n = lim;
            }
        } else if (dx < 0) {
            while (x < 0) {
                x += limit;
            }
            int lim = (x - dx - 1) / -dx;
            if (this.n > lim) {
                this.n = lim;
            }
        }
        return x;
    }

    private void UnpackPix32(int pix, int[] RGB) {
        RGB[0] = pix >>> 16 & 0xFF;
        RGB[1] = pix >>> 8 & 0xFF;
        RGB[2] = pix & 0xFF;
    }

    private static int Pix32ToWide(int pix) {
        return (pix & 0xFF0000) << 5 | (pix & 0xFF00) << 2 | (pix & 0xFF) >>> 1;
    }

    private void WideToRGBI(int pixW, int[] RGB) {
        RGB[0] = pixW >>> 24;
        RGB[1] = pixW >>> 13 & 0xFF;
        RGB[2] = pixW >>> 2 & 0xFF;
    }

    int GetRGBPixel(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.height) {
            y = this.height - 1;
        }
        if (x >= this.width) {
            x = this.width - 1;
        }
        int rowOffset = y * this.width;
        if (this.bpp == 8) {
            return this.display.IndexToRGB(this.pixels8[rowOffset + x]);
        }
        return this.pixels32[rowOffset + x];
    }

    int GetSSRGBPixel(int xH, int yH) {
        int x = xH >> 16;
        int y = yH >> 16;
        int xf = (xH & 0xFFFF) >> 13;
        int yf = (yH & 0xFFFF) >> 13;
        this.ce[0] = PixCoverage[xf][yf][0];
        this.ce[1] = PixCoverage[xf][yf][1];
        this.ce[2] = PixCoverage[xf][yf][2];
        this.ce[3] = PixCoverage[xf][yf][3];
        if (x < 0) {
            x = 0;
            this.ce[0] = this.ce[0] + this.ce[1];
            this.ce[1] = 0;
            this.ce[2] = this.ce[2] + this.ce[3];
            this.ce[3] = 0;
        } else if (x >= this.width - 1) {
            x = this.width - 2;
            this.ce[1] = this.ce[1] + this.ce[0];
            this.ce[0] = 0;
            this.ce[3] = this.ce[3] + this.ce[2];
            this.ce[2] = 0;
        }
        if (y < 0) {
            y = 0;
            this.ce[0] = this.ce[0] + this.ce[2];
            this.ce[2] = 0;
            this.ce[1] = this.ce[1] + this.ce[3];
            this.ce[3] = 0;
        } else if (y >= this.height - 1) {
            y = this.height - 2;
            this.ce[2] = this.ce[2] + this.ce[0];
            this.ce[0] = 0;
            this.ce[3] = this.ce[3] + this.ce[1];
            this.ce[1] = 0;
        }
        long pixW = 0L;
        int rowOffset = y * this.width;
        if (this.bpp != 8) {
            int offset = rowOffset + x;
            pixW = (long)Bitmap.Pix32ToWide(this.pixels32[offset]) * (long)this.ce[0];
            pixW += (long)Bitmap.Pix32ToWide(this.pixels32[offset + 1]) * (long)this.ce[1];
            pixW += (long)Bitmap.Pix32ToWide(this.pixels32[offset += this.width]) * (long)this.ce[2];
            pixW += (long)Bitmap.Pix32ToWide(this.pixels32[offset + 1]) * (long)this.ce[3];
        }
        int pix = (int)pixW;
        return pix >>> 8 & 0xFF0000 | pix >>> 5 & 0xFF00 | pix >>> 2 & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    void Blt32to8(RColor color, Point pt, int n, byte[] dst, int dstOffset) {
        block3: {
            if (color.bmDy != 0) ** GOTO lbl17
            srcOffset = (pt.y >> 16) * this.width;
            if (Math.abs(color.bmDx - 65536) >= 256) ** GOTO lbl12
            srcOffset += pt.x >> 16;
            pt.x += n * color.bmDx;
            while (n-- > 0) {
                dst[dstOffset++] = (byte)this.display.RGBToIndex(this.pixels32[srcOffset++]);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                dst[dstOffset++] = (byte)this.display.RGBToIndex(this.pixels32[srcOffset + (pt.x >> 16)]);
                pt.x += color.bmDx;
lbl12:
                // 2 sources

                ** while (n-- > 0)
            }
lbl13:
            // 1 sources

            break block3;
lbl-1000:
            // 1 sources

            {
                dst[dstOffset++] = (byte)this.display.RGBToIndex(this.pixels32[(pt.y >> 16) * this.width + (pt.x >> 16)]);
                pt.x += color.bmDx;
                pt.y += color.bmDy;
lbl17:
                // 2 sources

                ** while (n-- > 0)
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void Blt32to32(RColor color, Point pt, int n, int[] dst, int dstOffset) {
        block3: {
            if (color.bmDy != 0) ** GOTO lbl17
            srcOffset = (pt.y >> 16) * this.width;
            if (Math.abs(color.bmDx - 65536) >= 256) ** GOTO lbl12
            srcOffset += pt.x >> 16;
            pt.x += n * color.bmDx;
            while (n-- > 0) {
                dst[dstOffset++] = this.pixels32[srcOffset++];
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                dst[dstOffset++] = this.pixels32[srcOffset + (pt.x >> 16)];
                pt.x += color.bmDx;
lbl12:
                // 2 sources

                ** while (n-- > 0)
            }
lbl13:
            // 1 sources

            break block3;
lbl-1000:
            // 1 sources

            {
                dst[dstOffset++] = this.pixels32[(pt.y >> 16) * this.width + (pt.x >> 16)];
                pt.x += color.bmDx;
                pt.y += color.bmDy;
lbl17:
                // 2 sources

                ** while (n-- > 0)
            }
        }
    }

    private void Blt32toI(RColor color, Point pt, int n2, int[] pix) {
        int count = 0;
        if (color.bmDy == 0) {
            int rowOffset = (pt.y >> 16) * this.width;
            int i2 = n2;
            while (i2 > 0) {
                pix[count] = this.pixels32[rowOffset + (pt.x >> 16)];
                ++count;
                pt.x += color.bmDx;
                --i2;
            }
        } else {
            int i3 = n2;
            while (i3 > 0) {
                pix[count] = this.pixels32[(pt.y >> 16) * this.width + (pt.x >> 16)];
                ++count;
                pt.x += color.bmDx;
                pt.y += color.bmDy;
                --i3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void DrawSlab(int dstOffset, int xmin, int xmax, RColor color) {
        block23: {
            pt = new Point(0, 0);
            dst8 = this.display.pixels8;
            dst32 = this.display.pixels32;
            pt.x = xmin << 16;
            pt.y = this.display.bitY << 16;
            color.bmInvMat.transform(pt, pt);
            wLimit = this.width << 16;
            hLimit = this.height << 16;
            if (color.fillType == 65) {
                w = this.width;
                h = this.height;
                if (color.bmSmooth) {
                    --h;
                    --w;
                }
                tail = new Point(0, 0);
                count = xmax - xmin;
                tail.x = pt.x + color.bmDx * count;
                tail.y = pt.y + color.bmDy * count;
                while (true) {
                    x = pt.x >> 16;
                    y = pt.y >> 16;
                    if (x >= 0 && y >= 0 && x < w && y < h || xmin >= xmax) break;
                    pix = color.bmSmooth != false ? this.GetSSRGBPixel(pt.x, pt.y) : this.GetRGBPixel(x, y);
                    if (color.cx != null) {
                        pix = color.cx.ApplyColorMap(pix);
                    }
                    if (dst8 != null) {
                        dst8[xmin + dstOffset] = (byte)this.display.RGBToIndex(pix);
                    } else {
                        dst32[xmin + dstOffset] = pix;
                    }
                    pt.x += color.bmDx;
                    pt.y += color.bmDy;
                    ++xmin;
                }
                while (true) {
                    x = tail.x >> 16;
                    y = tail.y >> 16;
                    if ((x < 0 || y < 0 || x >= w || y >= h) && xmin < xmax) {
                        pix = color.bmSmooth != false ? this.GetSSRGBPixel(tail.x, tail.y) : this.GetRGBPixel(x, y);
                        --xmax;
                        if (color.cx != null) {
                            pix = color.cx.ApplyColorMap(pix);
                        }
                        if (dst8 != null) {
                            dst8[xmax + dstOffset] = (byte)pix;
                        } else {
                            dst32[xmax + dstOffset] = pix;
                        }
                        tail.x -= color.bmDx;
                        tail.y -= color.bmDy;
                        continue;
                    }
                    break;
                }
            } else {
                pt.x = Bitmap.LimitAbs(pt.x, wLimit);
                pt.y = Bitmap.LimitAbs(pt.y, hLimit);
            }
            if (!color.bmFast) ** GOTO lbl94
            while (xmin < xmax) {
                this.n = Math.min(xmax - xmin, 256);
                pt.x = this.CalcLimit(pt.x, color.bmDx, wLimit);
                pt.y = this.CalcLimit(pt.y, color.bmDy, hLimit);
                if (dst8 != null) {
                    this.Blt32to8(color, pt, this.n, dst8, xmin + dstOffset);
                } else {
                    this.Blt32to32(color, pt, this.n, dst32, xmin + dstOffset);
                }
                xmin += this.n;
            }
            break block23;
lbl-1000:
            // 1 sources

            {
                this.n = Math.min(xmax - xmin, 256);
                pt.x = this.CalcLimit(pt.x, color.bmDx, wLimit);
                pt.y = this.CalcLimit(pt.y, color.bmDy, hLimit);
                if (dst8 != null) {
                    this.Blt32toI(color, pt, this.n, Bitmap.pixBuf);
                } else {
                    this.Blt32toI(color, pt, this.n, Bitmap.pixBuf);
                }
                if (color.cx != null) {
                    color.cx.ApplyColorMap(Bitmap.pixBuf, this.n);
                }
                if (dst8 != null) {
                    offset = xmin + dstOffset;
                    count = 0;
                    i = this.n;
                    while (i > 0) {
                        dst8[offset] = (byte)this.display.RGBToIndex(Bitmap.pixBuf[count]);
                        --i;
                        ++offset;
                        ++count;
                    }
                } else {
                    offset = xmin + dstOffset;
                    count = 0;
                    i = this.n;
                    while (i > 0) {
                        dst32[offset] = Bitmap.pixBuf[count];
                        --i;
                        ++offset;
                        ++count;
                    }
                }
                xmin += this.n;
lbl94:
                // 2 sources

                ** while (xmin < xmax)
            }
        }
    }

    static {
        Bitmap.buildCoverageTable();
        pixBuf = new int[256];
    }
}

