/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import java.io.ByteArrayInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

public class JavaSoundPlayer {
    static final int kHeaderSize = 28;
    static byte[] lutTableL = new byte[256];
    static byte[] lutTableH = new byte[256];
    byte[] mulawData = null;
    byte[] pcmData = null;
    int loopCount;
    Clip source = null;
    boolean zeroLoop = false;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public JavaSoundPlayer(byte[] mulawData, int loopCount) {
        this.mulawData = mulawData;
        if (loopCount < 0) {
            this.loopCount = -1;
        } else if (loopCount > 0) {
            this.loopCount = loopCount - 1;
        } else {
            this.zeroLoop = true;
        }
        if (!this.zeroLoop) {
            int pcmlen = 2 * (mulawData.length - 28);
            this.pcmData = new byte[pcmlen];
            this.createTable();
            this.decodeMulaw();
        }
    }

    private void createTable() {
        int i2 = 0;
        while (i2 < 256) {
            int input = ~i2;
            int mantissa = ((input & 0xF) << 3) + 132;
            int segment = (input & 0x70) >> 4;
            int value = mantissa << segment;
            value -= 132;
            if ((input & 0x80) != 0) {
                value = -value;
            }
            JavaSoundPlayer.lutTableL[i2] = (byte)value;
            JavaSoundPlayer.lutTableH[i2] = (byte)(value >> 8);
            ++i2;
        }
    }

    private void decodeMulaw() {
        int inOff = 0;
        int outOff = 0;
        int temp = 0;
        inOff = 28;
        while (inOff < this.mulawData.length) {
            temp = this.mulawData[inOff] & 0xFF;
            this.pcmData[outOff++] = lutTableL[temp];
            this.pcmData[outOff++] = lutTableH[temp];
            ++inOff;
        }
    }

    public void play() {
        if (this.zeroLoop) {
            return;
        }
        try {
            AudioInputStream muais = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.mulawData));
            AudioFormat ulawFormat = muais.getFormat();
            AudioFormat pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ulawFormat.getSampleRate(), ulawFormat.getSampleSizeInBits() * 2, ulawFormat.getChannels(), ulawFormat.getFrameSize() * 2, ulawFormat.getFrameRate(), false);
            AudioInputStream ais = AudioSystem.getAudioInputStream(pcmFormat, muais);
            if (ais == null) {
                System.out.println("Can't convert from ulaw to pcm");
                return;
            }
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = JavaSoundPlayer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, ais.getFormat());
            if (!AudioSystem.isLineSupported(info)) {
                System.out.println("Not Support Line Info : " + info);
                return;
            }
            this.source = (Clip)AudioSystem.getLine(info);
            this.source.open(ais);
            this.source.loop(this.loopCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Exception {
        if (this.source == null) {
            return;
        }
        this.source.stop();
        this.source.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

